package com.atlassian.crowd.util;

import com.google.common.base.Strings;
import com.google.common.primitives.Longs;

import java.time.Duration;
import java.util.Optional;

public final class AttributeUtil {
    private AttributeUtil() {}

    /**
     * Returns the value of the provided string parsed as a duration or returns the fallback value if the attribute
     * cannot be parsed or is null. The provided string is assumed to be in milliseconds.
     * @param attribute the string to parse
     * @param defaultDuration the default duration to be used if the attribute cannot be parsed.
     * @return the successfully parsed value or the provided default
     */
    public static Duration safeParseDurationMillis(String attribute, Duration defaultDuration) {
        return Optional.ofNullable(Longs.tryParse(Strings.nullToEmpty(attribute)))
                .map(Duration::ofMillis)
                .orElse(defaultDuration);
    }
}
