package com.atlassian.crowd.manager.recovery;

import com.atlassian.crowd.embedded.api.Directory;

/**
 * Internal service that provides access point to Crowd's recovery mode.
 * <p>
 * When {@link #isRecoveryModeOn() recovery mode is activated} this service provides access to a special, in-memory
 * {@link #getRecoveryDirectory() recovery directory} that contains a single user - host applications need to make
 * sure that this user has all the necessary permissions to recover from any malfunction or misconfiguration, should
 * one happen.
 * <p>
 * Interested parties (notably host applications) should subscribe to the
 * {@link com.atlassian.crowd.event.recovery.RecoveryModeActivatedEvent} to be notified of the recovery mode activation.
 *
 * @since 2.7.2
 */
public interface RecoveryModeService {
    /**
     * @return {@code true}, if recovery mode is currently activated. An appropriate event will be raised to notify
     * about the recovery mode being activated in the system
     * @see com.atlassian.crowd.event.recovery.RecoveryModeActivatedEvent
     */
    boolean isRecoveryModeOn();

    /**
     * @return the recovery directory that contains the recovery user.
     * @throws java.lang.IllegalStateException if the recovery mode {@link #isRecoveryModeOn() is off}
     */
    Directory getRecoveryDirectory();

    /**
     * @return the username of the recovery user
     * @throws java.lang.IllegalStateException if the recovery mode {@link #isRecoveryModeOn() is off}
     */
    String getRecoveryUsername();

    /**
     * Checks if directory is RecoveryModeDirectory
     * @param directory to check
     * @return true when directory is recovery directory
     */
    boolean isRecoveryDirectory(Directory directory);
}
