package com.atlassian.crowd.manager.property;

import com.atlassian.crowd.service.HomeDirectoryService;
import org.springframework.transaction.annotation.Transactional;

import java.io.File;
import java.util.Optional;

import static com.atlassian.crowd.model.property.Property.CROWD_DEFAULT_ENCRYPTOR_PROPERTY;

@Transactional
public class PropertyBasedEncryptionSettings implements EncryptionSettings {
    private final PropertyManager propertyManager;
    private final HomeDirectoryService homeDirectoryService;

    public PropertyBasedEncryptionSettings(PropertyManager propertyManager, HomeDirectoryService homeDirectoryService) {
        this.propertyManager = propertyManager;
        this.homeDirectoryService = homeDirectoryService;
    }

    @Override
    public Optional<String> getDefaultEncryptor() {
        return propertyManager.getOptionalProperty(CROWD_DEFAULT_ENCRYPTOR_PROPERTY);
    }

    @Override
    public void setDefaultEncryptor(String encryptor) {
        propertyManager.setProperty(CROWD_DEFAULT_ENCRYPTOR_PROPERTY, encryptor);
    }

    @Override
    public void setEncryptionKeyPath(String encryptor, String keyPath) {
        propertyManager.setProperty(getPropertyNameForEncryptionKeyPath(encryptor), keyPath);
    }

    @Override
    public Optional<String> getEncryptionKeyPath(String encryptor) {
        return propertyManager.getOptionalProperty(getPropertyNameForEncryptionKeyPath(encryptor));
    }

    @Override
    public String getKeyFilesDirectoryPath() {
        return  homeDirectoryService.getSharedHome() + File.separator + "keys";
    }

    private String getPropertyNameForEncryptionKeyPath(String encryptor) {
        return String.format("crowd.encryption.encryptor.%s.keyPath", encryptor);
    }
}
