package com.atlassian.crowd.manager.directory.monitor.poller;

import com.atlassian.crowd.manager.directory.SynchronisationMode;

/**
 * Manager for adding and removing DirectoryPollers.
 *
 * Implementations are used in a thread-safe manner by
 * the DirectoryMonitorManager.
 */
public interface DirectoryPollerManager {
    /**
     * Manually triggers the directory poller to immediately poll the directory and synchronise changes.
     *
     * This can be used to asynchronously start a directory synchronisation using the
     * underlying scheduler.
     *
     * If a manual poll is triggered while another poll is running, the manual poll will
     * not queue (i.e. it will do nothing). You can check if a directory is currently synchronising
     * by calling the {@link com.atlassian.crowd.manager.directory.DirectoryManager#isSynchronising(long)}.
     *
     * If the directory does not exist or has no poller associated with it, this method
     * will do nothing.
     *
     * @param directoryID         directory ID.
     * @param synchronisationMode determines whether the poll only requests elements that have changed since a timestamp or if
     *                            it queries for the entire user base from the remote directory and determines changes locally.
     */
    void triggerPoll(long directoryID, SynchronisationMode synchronisationMode);
}
