
package com.atlassian.crowd.manager.directory.monitor.poller;

import com.atlassian.crowd.manager.directory.SynchronisationMode;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.Schedule;
import com.google.common.collect.ImmutableMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.Serializable;

import static com.atlassian.crowd.manager.directory.monitor.poller.DirectoryPollerJobRunner.JOB_RUNNER_KEY;
import static com.atlassian.crowd.manager.directory.monitor.poller.DirectoryPollerJobRunner.PARAM_DIRECTORY_ID;
import static com.atlassian.crowd.manager.directory.monitor.poller.DirectoryPollerJobRunner.PARAM_SYNC_MODE;
import static com.atlassian.scheduler.config.RunMode.RUN_ONCE_PER_CLUSTER;

/**
 * Implementation of DirectoryPollerManager that uses Atlassian Scheduler
 *
 * @since 2.8
 */
public class AtlassianSchedulerDirectoryPollerManager implements DirectoryPollerManager {
    private static final Logger log = LoggerFactory.getLogger(AtlassianSchedulerDirectoryPollerManager.class);
    private final SchedulerService schedulerService;

    public AtlassianSchedulerDirectoryPollerManager(SchedulerService schedulerService) {
        this.schedulerService = schedulerService;
    }

    @Override
    public void triggerPoll(long directoryID, SynchronisationMode syncMode) {
        JobConfig config = JobConfig.forJobRunnerKey(JOB_RUNNER_KEY)
                .withRunMode(RUN_ONCE_PER_CLUSTER)
                .withSchedule(Schedule.runOnce(null))
                .withParameters(ImmutableMap.<String, Serializable>builder()
                        .put(PARAM_DIRECTORY_ID, directoryID)
                        .put(PARAM_SYNC_MODE, syncMode)
                        .build());
        try {
            // Schedule with generated ID to not overwrite the run config for the automatic sync schedule.
            schedulerService.scheduleJobWithGeneratedId(config);
        } catch (SchedulerServiceException e) {
            throw new RuntimeException(e);
        }
    }
}
