package com.atlassian.crowd.manager.directory;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

/**
 * An in-memory implementation of {@link DirectorySynchronisationTokenStore} that stores the tokens in memory
 */
@Deprecated
public class InMemoryDirectorySynchronisationTokenStore implements DirectorySynchronisationTokenStore {

    private ConcurrentMap<Long, String> tokens;

    public InMemoryDirectorySynchronisationTokenStore() {
        this(new ConcurrentHashMap<>());
    }

    public InMemoryDirectorySynchronisationTokenStore(ConcurrentMap<Long, String> tokens) {
        this.tokens = tokens;
    }

    @Override
    public String getLastSynchronisationTokenForDirectory(long directoryId) {
        return tokens.get(directoryId);
    }

    @Override
    public void storeSynchronisationTokenForDirectory(long directoryId, String syncStatus) {
        tokens.put(directoryId, syncStatus);
    }

    @Override
    public void clearSynchronisationTokenForDirectory(long directoryId) {
        tokens.remove(directoryId);
    }
}
