package com.atlassian.crowd.manager.directory;

/**
 * Provides utilities for dealing with failed synchronizations
 * @since 3.2.0
 */
public interface FailedSynchronisationManager {

    /**
     * Finds and finalizes synchronisations which started, but haven't finished yet
     */
    void finalizeSynchronisationStatuses();

    /**
     * Attempts to find synchronisations started by nodes that have terminated, and reschedule them.
     * @return number of rescheduled synchronisations
     * @see SynchronisationStatusFinalizer for non-clustered handling
     */
    int rescheduleStalledSynchronisations();
}
