package com.atlassian.crowd.manager.audit;

import com.atlassian.crowd.audit.AuditLogChangeset;
import com.atlassian.crowd.audit.query.AuditLogQuery;

import java.util.Collections;
import java.util.List;

/**
 * No-op implementation of {@link AuditService}, to be used by products embedding Crowd.
 */
public class NoOpAuditService implements AuditService {
    @Override
    public void saveAudit(AuditLogChangeset changeset) {

    }

    @Override
    public List<AuditLogChangeset> searchAuditLog(AuditLogQuery query) {
        return Collections.emptyList();
    }

    @Override
    public boolean isEnabled() {
        return false;
    }

    @Override
    public void saveConfiguration(AuditLogConfiguration auditLogConfiguration) {

    }

    @Override
    public AuditLogConfiguration getConfiguration() {
        return AuditLogConfiguration.defaultConfiguration();
    }

    @Override
    public boolean shouldAuditEvent() {
        return false;
    }
}
