package com.atlassian.crowd.manager.audit;

import com.atlassian.annotations.Internal;
import com.atlassian.crowd.audit.AuditLogChangeset;

import java.time.Instant;
import java.util.Collection;

/**
 * Extends AuditService for operations like removing stale entries, etc
 */
@Internal
public interface InternalAuditService extends AuditService {
    /**
     * Removes stale entries basing on current configuration
     *
     * @return number of removed entries
     */
    int removeStaleEntries();

    /**
     * Removes entries created before the given instant
     * @return number of removed entries
     * @since v3.2
     */
    int removeEntriesOlderThan(Instant cutoff);

    /**
     * Persists the given audit log changesets. Their timestamps will be set to the current time.
     * Will not do anything when audit log is disabled.
     *
     * @param changesets the changesets that will be persisted
     * @since v3.2
     */
    void saveAudits(Collection<AuditLogChangeset> changesets);


    /**
     * @return the amount of changesets in the audit log
     */
    long getAuditLogSize();
}
