package com.atlassian.crowd.manager.audit;

import javax.annotation.Nullable;

import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Responsible for cleaning state audit log entries
 */
public class AuditLogPruner implements JobRunner {
    private static final Logger logger = LoggerFactory.getLogger(AuditLogPruner.class);

    private final InternalAuditService internalAuditService;

    public AuditLogPruner(InternalAuditService internalAuditService) {
        this.internalAuditService = internalAuditService;
    }

    @Nullable
    @Override
    public JobRunnerResponse runJob(JobRunnerRequest request) {
        try {
            logger.debug("Cleaning stale audit log entries");
            internalAuditService.removeStaleEntries();
            return JobRunnerResponse.success();
        } catch (Exception e) {
            logger.warn("Could not remove stale audit log entries", e);
            return JobRunnerResponse.failed(e);
        }
    }
}
