package com.atlassian.crowd.manager.application.search;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.manager.application.canonicality.CanonicalityChecker;
import com.atlassian.crowd.manager.application.filtering.AccessFilter;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.search.query.membership.MembershipQuery;

import java.util.List;
import java.util.function.BiFunction;

/**
 * An in-memory {@link MembershipSearchStrategy} which aggregates memberships across multiple directories.
 * <p>
 * This is considered the worse case {@link MembershipSearchStrategy} to use as searching across multiple directories
 * will be done in-memory, potentially consuming a lot of memory. This is the same (in spirit) as what Crowd 2.8
 * and earlier would do by default.
 *
 * @see com.atlassian.crowd.model.application.Application#isMembershipAggregationEnabled()
 */
public class InMemoryAggregatingMembershipSearchStrategy extends AbstractInMemoryMembershipSearchStrategy {
    public InMemoryAggregatingMembershipSearchStrategy(DirectoryManager directoryManager, List<Directory> directories, AccessFilter accessFilter) {
        super(directoryManager, directories, accessFilter);
    }

    @Override
    protected CanonicalityChecker getCanonicalityCheckerIfNeeded(MembershipQuery<?> query) {
        return null;
    }

    @Override
    protected <T> BiFunction<Directory, MembershipQuery<T>, MembershipQuery<T>> getQueryTransformer(MembershipQuery<T> original) {
        return (directoryId, query) -> query;
    }
}
