package com.atlassian.crowd.manager.application.search;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.Query;
import com.atlassian.crowd.search.query.membership.MembershipQuery;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import java.util.List;
import java.util.Objects;
import java.util.function.UnaryOperator;

/**
 * Defines query and results filter that should be run for a given directory.
 */
public class DirectoryQueryWithFilter<T> {
    @Nonnull
    private final Directory directory;
    @Nonnull
    private final Query<T> query;
    @Nonnull
    private final UnaryOperator<List<T>> filter;

    public DirectoryQueryWithFilter(@Nonnull Directory directory, @Nullable Query<T> query, @Nonnull UnaryOperator<List<T>> filter) {
        this.directory = Objects.requireNonNull(directory);
        this.query = Objects.requireNonNull(query);
        this.filter = Objects.requireNonNull(filter);
    }

    public Directory getDirectory() {
        return directory;
    }

    /**
     * Returns query that should be run against given directory.
     * If {@code null} is returned then no query should be run and empty results should be returned.
     */
    @Nonnull
    public Query<T> getQuery() {
        return query;
    }

    @Nonnull
    public MembershipQuery<T> getMembershipQuery() {
        return (MembershipQuery<T>) query;
    }

    /**
     * Performs filtering of results of the query ({@link #getQuery()}). Does not perform any filtering related
     * to start index and maximum number of results.
     */
    public List<T> filterResults(List<T> list) {
        return filter.apply(list);
    }
}
