package com.atlassian.crowd.manager.application;

import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.application.ApplicationDirectoryMapping;

import java.util.Collections;
import java.util.List;

/**
 * A no-op implementation of {@link DefaultGroupMembershipService}, meant to be used in products
 *
 * @since v3.1.0
 */
public class NoOpDefaultGroupMembershipService implements DefaultGroupMembershipService {

    @Override
    public void add(final Application application, final ApplicationDirectoryMapping directoryMapping, final String groupName) throws OperationFailedException {
    }

    @Override
    public void remove(final Application application, final ApplicationDirectoryMapping directoryMapping, final String groupName) throws OperationFailedException {
    }

    @Override
    public List<String> listAll(final Application application, final ApplicationDirectoryMapping directoryMapping) throws OperationFailedException {
        return Collections.emptyList();
    }
}
