package com.atlassian.crowd.directory;

import com.atlassian.crowd.core.event.DelegatingMultiEventPublisher;
import com.atlassian.crowd.core.event.MultiEventPublisher;
import com.atlassian.crowd.directory.synchronisation.cache.DefaultGroupActionStrategy;
import com.atlassian.crowd.directory.synchronisation.cache.ExternalIdCheckingGroupActionStrategy;
import com.atlassian.crowd.directory.synchronisation.cache.DirectoryCache;
import com.atlassian.crowd.directory.ldap.cache.DirectoryCacheFactory;
import com.atlassian.crowd.embedded.spi.DirectoryDao;
import com.atlassian.crowd.embedded.spi.GroupDao;
import com.atlassian.crowd.embedded.spi.UserDao;
import com.atlassian.crowd.manager.directory.SynchronisationStatusManager;
import com.atlassian.event.api.EventPublisher;

/**
 * DirectoryCacheFactory that returns DbCachingRemoteDirectoryCache instance.
 */
public class DirectoryCacheFactoryImpl implements DirectoryCacheFactory {
    private static final String AZURE_AD_CLASS_NAME = "com.atlassian.crowd.directory.AzureAdDirectory";
    private final DirectoryDao directoryDao;
    private final SynchronisationStatusManager synchronisationStatusManager;
    private final MultiEventPublisher eventPublisher;
    private final UserDao userDao;
    private final GroupDao groupDao;

    // used by products, that don't need special handling for mass event publications
    public DirectoryCacheFactoryImpl(DirectoryDao directoryDao,
                                     SynchronisationStatusManager synchronisationStatusManager,
                                     EventPublisher eventPublisher,
                                     UserDao userDao,
                                     GroupDao groupDao) {
        this(directoryDao, synchronisationStatusManager, new DelegatingMultiEventPublisher(eventPublisher), userDao, groupDao);
    }

    // used by Crowd internally
    public DirectoryCacheFactoryImpl(DirectoryDao directoryDao,
                                     SynchronisationStatusManager synchronisationStatusManager,
                                     MultiEventPublisher eventPublisher,
                                     UserDao userDao,
                                     GroupDao groupDao) {
        this.directoryDao = directoryDao;
        this.synchronisationStatusManager = synchronisationStatusManager;
        this.eventPublisher = eventPublisher;
        this.userDao = userDao;
        this.groupDao = groupDao;
    }

    DirectoryCacheChangeOperations createDirectoryCacheChangeOperations(RemoteDirectory remoteDirectory, InternalRemoteDirectory internalDirectory) {
        return new DbCachingRemoteChangeOperations(directoryDao,
                remoteDirectory,
                internalDirectory,
                synchronisationStatusManager,
                eventPublisher,
                userDao,
                groupDao,
                remoteDirectory.getClass().getName().equals(AZURE_AD_CLASS_NAME) ? new ExternalIdCheckingGroupActionStrategy() : new DefaultGroupActionStrategy());
    }

    public final DirectoryCache createDirectoryCache(RemoteDirectory remoteDirectory, InternalRemoteDirectory internalDirectory) {
        DirectoryCacheChangeOperations x = createDirectoryCacheChangeOperations(
                remoteDirectory,
                internalDirectory);

        return new DirectoryCacheImplUsingChangeOperations(x);
    }
}
