package com.atlassian.crowd.core.event;

import java.util.Collection;

import com.atlassian.event.api.EventPublisher;

/**
 * Basic implementation of {@link MultiEventPublisher} that delegates to an underlying {@link EventPublisher}
 */
public class DelegatingMultiEventPublisher implements MultiEventPublisher {
    protected final EventPublisher delegate;

    public DelegatingMultiEventPublisher(EventPublisher delegate) {
        this.delegate = delegate;
    }

    @Override
    public void publishAll(Collection<Object> events) {
        events.forEach(delegate::publish);
    }

    @Override
    public void publish(Object event) {
        delegate.publish(event);
    }

    @Override
    public void register(Object listener) {
        delegate.register(listener);
    }

    @Override
    public void unregister(Object listener) {
        delegate.unregister(listener);
    }

    @Override
    public void unregisterAll() {
        delegate.unregisterAll();
    }
}
