package com.atlassian.crowd.cache;

import javax.annotation.Nullable;

import com.atlassian.crowd.model.user.User;

/**
 * Cache to determine whether a user is authorised to authenticate with an application.
 * Was public api until 3.0.
 *
 * @since v2.2
 */
public interface UserAuthorisationCache {
    /**
     * Sets whether the user is permitted to authenticate with the application.
     *
     * @param user            the user to cache fore
     * @param applicationName name of the application to authenticate
     * @param permitted       set to <tt>true</tt> if the user is allowed to authenticate with the application, otherwise false.
     */
    void setPermitted(User user, String applicationName, boolean permitted);

    /**
     * Returns whether the user is permitted to authenticate with the application.
     *
     * @param user            the user to check for
     * @param applicationName name of the application the user is authenticating against
     * @return <tt>true</tt> if the user is permitted to authenticate with the application, <tt>false</tt> if the user
     * is not permitted to authenticate, and <tt>null</tt> if the result is not in the cache.
     */
    @Nullable
    Boolean isPermitted(User user, String applicationName);

    /**
     * Clears the user authorisation cache.
     */
    void clear();
}
