package com.atlassian.crowd.cache;

import javax.annotation.Nullable;

import com.atlassian.crowd.model.user.User;

public class DelegatingUserAuthorisationCache implements UserAuthorisationCache {
    private final UserAuthorisationCache delegate;

    public DelegatingUserAuthorisationCache(UserAuthorisationCache delegate) {
        this.delegate = delegate;
    }

    @Override
    public void setPermitted(User user, String applicationName, boolean permitted) {
        delegate.setPermitted(user, applicationName, permitted);
    }

    @Nullable
    @Override
    public Boolean isPermitted(User user, String applicationName) {
        return delegate.isPermitted(user, applicationName);
    }

    @Override
    public void clear() {
        delegate.clear();
    }
}