package com.atlassian.crowd.audit;

/**
 * A no-op implementation of the audit log context that will execute the passed action. Applicable for products that
 * don't use Crowd's auditing capabilities.
 *
 * @since 3.2.0
 */
public class NoOpAuditLogContext implements AuditLogContext {
    @Override
    public <T> T withAuditLogAuthor(AuditLogAuthor author, AuditLogContextCallback<T> callback) throws Exception {
        return callback.execute();
    }

    @Override
    public <T> T withAuditLogSource(AuditLogEventSource source, AuditLogContextCallback<T> callback) throws Exception {
        return callback.execute();
    }
}
