/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.crypto;

import com.atlassian.crowd.crypto.SaltingEncryptor;
import com.atlassian.crowd.embedded.api.Encryptor;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import java.time.Duration;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BooleanSupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachedEncryptor
implements Encryptor {
    private static final Logger logger = LoggerFactory.getLogger(CachedEncryptor.class);
    private static final String NULL_REPLACEMENT = "";
    private static final String NON_NULL_PREFIX = "p";
    private final ConcurrentMap<String, String> encryptionCache;
    private final ConcurrentMap<String, String> decryptionCache;
    private final BooleanSupplier cacheEnabledSupplier;
    private final Encryptor delegate;

    public CachedEncryptor(Encryptor delegate, long maxCacheSize, Duration expireAfterAccess, BooleanSupplier cacheEnabledSupplier) {
        Preconditions.checkArgument((!(delegate instanceof SaltingEncryptor) ? 1 : 0) != 0, (Object)"SaltingEncryptor should not be cached");
        this.delegate = delegate;
        this.encryptionCache = CachedEncryptor.createCache(maxCacheSize, expireAfterAccess);
        this.decryptionCache = CachedEncryptor.createCache(maxCacheSize, expireAfterAccess);
        this.cacheEnabledSupplier = cacheEnabledSupplier;
    }

    private static ConcurrentMap<String, String> createCache(long maxCacheSize, Duration expireAfterAccess) {
        return CacheBuilder.newBuilder().maximumSize(maxCacheSize).expireAfterAccess(expireAfterAccess).build().asMap();
    }

    public String encrypt(String password) {
        if (!this.cacheEnabledSupplier.getAsBoolean()) {
            return this.delegate.encrypt(password);
        }
        String sanitizedPassword = this.wrapNull(password);
        String encrypted = this.encryptionCache.computeIfAbsent(sanitizedPassword, key -> {
            logger.debug("Encrypted password not found in encryption cache. Encrypting.");
            return this.wrapNull(this.delegate.encrypt(password));
        });
        this.decryptionCache.put(encrypted, sanitizedPassword);
        return this.unwrapNull(encrypted);
    }

    public String decrypt(String encryptedPassword) {
        if (!this.cacheEnabledSupplier.getAsBoolean()) {
            return this.delegate.decrypt(encryptedPassword);
        }
        String decrypted = this.decryptionCache.computeIfAbsent(this.wrapNull(encryptedPassword), key -> {
            logger.debug("Decrypted password not found in decryption cache. Decrypting.");
            return this.wrapNull(this.delegate.decrypt(encryptedPassword));
        });
        return this.unwrapNull(decrypted);
    }

    private String wrapNull(String data) {
        return data == null ? NULL_REPLACEMENT : NON_NULL_PREFIX + data;
    }

    private String unwrapNull(String data) {
        return NULL_REPLACEMENT.equals(data) ? null : data.substring(NON_NULL_PREFIX.length());
    }

    public boolean changeEncryptionKey() {
        try {
            boolean bl = this.delegate.changeEncryptionKey();
            return bl;
        }
        finally {
            logger.debug("Clearing the encryption cache.");
            this.clearCache();
        }
    }

    @VisibleForTesting
    void clearCache() {
        this.encryptionCache.clear();
        this.decryptionCache.clear();
    }
}

