/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.manager.directory;

import com.atlassian.beehive.ClusterLock;
import com.atlassian.beehive.ClusterLockService;
import com.atlassian.crowd.audit.AuditLogContext;
import com.atlassian.crowd.audit.AuditLogEventSource;
import com.atlassian.crowd.directory.RemoteDirectory;
import com.atlassian.crowd.directory.SynchronisableDirectory;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectorySynchronisationRoundInformation;
import com.atlassian.crowd.event.directory.RemoteDirectorySynchronisationFailedEvent;
import com.atlassian.crowd.event.directory.RemoteDirectorySynchronisationStartedEvent;
import com.atlassian.crowd.event.directory.RemoteDirectorySynchronisedEvent;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.manager.directory.DirectorySynchronisationUtils;
import com.atlassian.crowd.manager.directory.DirectorySynchroniser;
import com.atlassian.crowd.manager.directory.DirectorySynchroniserHelper;
import com.atlassian.crowd.manager.directory.InternalSynchronisationStatusManager;
import com.atlassian.crowd.manager.directory.SynchronisationMode;
import com.atlassian.crowd.manager.directory.SynchronisationStatusManager;
import com.atlassian.crowd.model.directory.SynchronisationStatusKey;
import com.atlassian.event.api.EventPublisher;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public class DirectorySynchroniserImpl
implements DirectorySynchroniser {
    private static final Logger log = LoggerFactory.getLogger(DirectorySynchroniser.class);
    private final ClusterLockService lockService;
    private final DirectorySynchroniserHelper directorySynchroniserHelper;
    private final InternalSynchronisationStatusManager synchronisationStatusManager;
    private final EventPublisher eventPublisher;
    private final AuditLogContext auditLogContext;

    public DirectorySynchroniserImpl(ClusterLockService lockService, DirectorySynchroniserHelper directorySynchroniserHelper, InternalSynchronisationStatusManager synchronisationStatusManager, EventPublisher eventPublisher, AuditLogContext auditLogContext) {
        this.lockService = lockService;
        this.directorySynchroniserHelper = directorySynchroniserHelper;
        this.synchronisationStatusManager = synchronisationStatusManager;
        this.eventPublisher = eventPublisher;
        this.auditLogContext = auditLogContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional(propagation=Propagation.NEVER)
    public void synchronise(SynchronisableDirectory remoteDirectory, SynchronisationMode mode) throws DirectoryNotFoundException, OperationFailedException {
        block10: {
            long directoryId = remoteDirectory.getDirectoryId();
            Directory directory = this.findDirectoryById(directoryId);
            if (!directory.isActive()) {
                log.debug("Request to synchronise directory [ {} ] in {} mode is returning silently because the directory is not active.", (Object)directoryId, (Object)mode);
                return;
            }
            log.debug("request to synchronise directory [ {} ] in {} mode", (Object)directoryId, (Object)mode);
            ClusterLock lock = this.lockService.getLockForName(DirectorySynchronisationUtils.getLockName(directoryId));
            if (lock.tryLock()) {
                boolean successful = false;
                long startTime = System.currentTimeMillis();
                try {
                    this.directorySynchroniserHelper.updateSyncStartTime(remoteDirectory);
                    this.synchronisationStatusManager.syncStarted(directory);
                    try {
                        this.auditLogContext.withAuditLogSource(AuditLogEventSource.SYNCHRONIZATION, () -> {
                            this.eventPublisher.publish((Object)new RemoteDirectorySynchronisationStartedEvent((RemoteDirectory)remoteDirectory));
                            remoteDirectory.synchroniseCache(mode, (SynchronisationStatusManager)this.synchronisationStatusManager);
                            return null;
                        });
                        successful = true;
                        break block10;
                    }
                    catch (Exception ignored) {
                        Throwables.propagateIfPossible((Throwable)ignored, DirectoryNotFoundException.class, OperationFailedException.class);
                        throw new RuntimeException(ignored);
                    }
                    finally {
                        this.finishSynchronisationIfWasNotFinishedAlready(directory, successful);
                        this.directorySynchroniserHelper.updateSyncEndTime(remoteDirectory);
                        this.publishSynchronisationEndedEvent((RemoteDirectory)remoteDirectory, successful, System.currentTimeMillis() - startTime);
                    }
                }
                finally {
                    lock.unlock();
                }
            }
            log.debug("directory [ {} ] already synchronising", (Object)directoryId);
        }
    }

    @VisibleForTesting
    void finishSynchronisationIfWasNotFinishedAlready(Directory directory, boolean successful) {
        SynchronisationStatusKey defaultKey = successful ? SynchronisationStatusKey.SUCCESS_FULL : SynchronisationStatusKey.FAILURE;
        DirectorySynchronisationRoundInformation activeRound = this.synchronisationStatusManager.getDirectorySynchronisationInformation(directory).getActiveRound();
        if (activeRound != null) {
            SynchronisationStatusKey resolvedKey = SynchronisationStatusKey.fromKey((String)activeRound.getStatusKey()).filter(SynchronisationStatusKey::isFinal).orElse(defaultKey);
            this.synchronisationStatusManager.syncFinished(directory.getId(), resolvedKey, (List)ImmutableList.of());
        }
    }

    private void publishSynchronisationEndedEvent(RemoteDirectory remoteDirectory, boolean wasSuccessful, long timeTakenInMs) {
        try {
            this.auditLogContext.withAuditLogSource(AuditLogEventSource.SYNCHRONIZATION, () -> {
                if (wasSuccessful) {
                    this.eventPublisher.publish((Object)new RemoteDirectorySynchronisedEvent((Object)this, remoteDirectory, timeTakenInMs));
                } else {
                    this.eventPublisher.publish((Object)new RemoteDirectorySynchronisationFailedEvent((Object)this, remoteDirectory, timeTakenInMs));
                }
                return null;
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean isSynchronising(long directoryId) throws DirectoryNotFoundException {
        return this.directorySynchroniserHelper.isSynchronising(directoryId);
    }

    private Directory findDirectoryById(long directoryId) throws DirectoryNotFoundException {
        return this.directorySynchroniserHelper.findDirectoryById(directoryId);
    }
}

