/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.manager.application;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.ObjectNotFoundException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.manager.application.AbstractInMemorySearchStrategy;
import com.atlassian.crowd.manager.application.ResultsAggregator;
import com.atlassian.crowd.manager.application.SingleDirectorySearchStrategy;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.model.DirectoryEntities;
import com.atlassian.crowd.model.DirectoryEntity;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.Combine;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.QueryUtils;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.restriction.NullRestriction;
import com.atlassian.crowd.search.query.entity.restriction.NullRestrictionImpl;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.constants.UserTermKeys;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryNonAggregatingSearchStrategy
extends AbstractInMemorySearchStrategy {
    private static final Logger logger = LoggerFactory.getLogger(InMemoryNonAggregatingSearchStrategy.class);

    public InMemoryNonAggregatingSearchStrategy(DirectoryManager directoryManager, List<Directory> activeDirectories) {
        super(directoryManager, activeDirectories);
    }

    @Override
    public <T> List<T> searchDirectGroupRelationships(MembershipQuery<T> query) {
        QueryUtils.checkAssignableFrom((Class)query.getReturnType(), (Class[])new Class[]{String.class, Group.class, User.class});
        ResultsAggregator<T> results = ResultsAggregator.with(InMemoryNonAggregatingSearchStrategy.getAggregatingAndSortingComparatorFor(query.getReturnType()), query);
        LinkedHashMap<Long, List<DirectoryEntity>> allEntities = new LinkedHashMap<Long, List<DirectoryEntity>>();
        if (query.isFindChildren()) {
            for (Directory directory : this.activeDirectories) {
                List<Object> itemsToAdd;
                if (query.getReturnType() == User.class || query.getReturnType() == Group.class) {
                    MembershipQuery<T> castQuery = query;
                    itemsToAdd = this.doDirectDirectoryMembershipQuery(castQuery, directory.getId());
                } else if (query.getReturnType() == String.class && query.getEntityToReturn().equals((Object)EntityDescriptor.user())) {
                    itemsToAdd = InMemoryNonAggregatingSearchStrategy.usersInDirectory(directory.getId(), this.doDirectDirectoryMembershipQuery(query, directory.getId()));
                } else if (query.getReturnType() == String.class && query.getEntityToReturn().equals((Object)EntityDescriptor.group())) {
                    itemsToAdd = InMemoryNonAggregatingSearchStrategy.groupsInDirectory(directory.getId(), this.doDirectDirectoryMembershipQuery(query, directory.getId()));
                } else {
                    throw new IllegalArgumentException("Unsupported query return type or entity: " + query.toString());
                }
                allEntities.put(directory.getId(), new ArrayList<T>(itemsToAdd));
            }
            this.removeNonCanonicalEntities(allEntities, this.activeDirectories, query);
            this.addResultsFromDirectories(query, results, allEntities);
        } else {
            try {
                DirectoryEntity entity = this.findEntityByName(query.getEntityNameToMatch(), query.getEntityToMatch());
                results.addAll(this.doDirectDirectoryMembershipQuery(query, entity.getDirectoryId()));
            }
            catch (ObjectNotFoundException objectNotFoundException) {
                // empty catch block
            }
        }
        return results.constrainResults();
    }

    private <T> void addResultsFromDirectories(MembershipQuery<T> query, ResultsAggregator<T> results, Map<Long, List<DirectoryEntity>> allEntities) {
        for (List<DirectoryEntity> directoryEntities : allEntities.values()) {
            if (query.getReturnType() == User.class || query.getReturnType() == Group.class) {
                results.addAll(directoryEntities);
                continue;
            }
            if (query.getReturnType() != String.class || !query.getEntityToReturn().equals((Object)EntityDescriptor.user()) && !query.getEntityToReturn().equals((Object)EntityDescriptor.group())) continue;
            results.addAll(Iterables.transform(directoryEntities, (Function)DirectoryEntities.NAME_FUNCTION));
        }
    }

    @Override
    public <T> List<T> searchNestedGroupRelationships(MembershipQuery<T> query) {
        QueryUtils.checkAssignableFrom((Class)query.getReturnType(), (Class[])new Class[]{String.class, Group.class, User.class});
        ResultsAggregator<T> results = ResultsAggregator.with(InMemoryNonAggregatingSearchStrategy.getAggregatingAndSortingComparatorFor(query.getReturnType()), query);
        LinkedHashMap<Long, List<DirectoryEntity>> allEntities = new LinkedHashMap<Long, List<DirectoryEntity>>();
        if (query.isFindChildren()) {
            for (Directory directory : this.activeDirectories) {
                MembershipQuery expandedQuery;
                List<T> itemsToAdd;
                if (query.getReturnType() == User.class || query.getReturnType() == Group.class) {
                    MembershipQuery<T> castQuery = query;
                    itemsToAdd = this.doNestedDirectoryMembershipQuery(castQuery, directory.getId());
                } else if (query.getReturnType() == String.class && query.getEntityToReturn().equals((Object)EntityDescriptor.user())) {
                    expandedQuery = new MembershipQuery(query, User.class);
                    itemsToAdd = this.doNestedDirectoryMembershipQuery(expandedQuery, directory.getId());
                } else if (query.getReturnType() == String.class && query.getEntityToReturn().equals((Object)EntityDescriptor.group())) {
                    expandedQuery = new MembershipQuery(query, Group.class);
                    itemsToAdd = this.doNestedDirectoryMembershipQuery(expandedQuery, directory.getId());
                } else {
                    throw new IllegalArgumentException("Unsupported query return type or entity: " + query.toString());
                }
                allEntities.put(directory.getId(), new ArrayList<T>(itemsToAdd));
            }
            this.removeNonCanonicalEntities(allEntities, this.activeDirectories, query);
            this.addResultsFromDirectories(query, results, allEntities);
        } else {
            try {
                DirectoryEntity entity = this.findEntityByName(query.getEntityNameToMatch(), query.getEntityToMatch());
                results.addAll(this.doNestedDirectoryMembershipQuery(query, entity.getDirectoryId()));
            }
            catch (ObjectNotFoundException objectNotFoundException) {
                // empty catch block
            }
        }
        return results.constrainResults();
    }

    private <T> void removeNonCanonicalEntities(Map<Long, List<DirectoryEntity>> allEntities, List<Directory> activeDirectories, MembershipQuery<T> originalQuery) {
        this.removeEntitiesFoundInTheFirstDirectory(allEntities, activeDirectories);
        for (int i = 1; i < activeDirectories.size(); ++i) {
            Directory directory = activeDirectories.get(i);
            List succeedingDirectories = activeDirectories.stream().skip(i + 1).collect(Collectors.toList());
            List<DirectoryEntity> directoryEntities = allEntities.get(directory.getId());
            if (directoryEntities.size() == 0) continue;
            List<Directory> precedingDirectories = activeDirectories.subList(0, i);
            for (Directory precedingDirectory : precedingDirectories) {
                List<String> matchingNamesInDirectory = this.findRemainingEntities(originalQuery, directoryEntities, precedingDirectory);
                HashSet<String> canonicalEntityNames = new HashSet<String>(Lists.transform(matchingNamesInDirectory, (Function)IdentifierUtils.TO_LOWER_CASE));
                this.removeCanonicalUsers(canonicalEntityNames, allEntities.get(directory.getId()));
                succeedingDirectories.stream().map(dir -> (List)allEntities.get(dir.getId())).forEach(users -> this.removeCanonicalUsers((Set<String>)canonicalEntityNames, (List<DirectoryEntity>)users));
            }
        }
    }

    private void removeEntitiesFoundInTheFirstDirectory(Map<Long, List<DirectoryEntity>> allEntities, List<Directory> activeDirectories) {
        Directory directory = activeDirectories.get(0);
        List<DirectoryEntity> directoryEntities = allEntities.get(directory.getId());
        HashSet canonicalEntityNames = new HashSet(Lists.transform(directoryEntities, (Function)DirectoryEntities.LOWER_NAME_FUNCTION));
        List succeedingDirectories = activeDirectories.stream().skip(1L).collect(Collectors.toList());
        succeedingDirectories.stream().map(dir -> (List)allEntities.get(dir.getId())).forEach(users -> this.removeCanonicalUsers(canonicalEntityNames, (List<DirectoryEntity>)users));
    }

    private <T> List<String> findRemainingEntities(MembershipQuery<T> originalQuery, List<DirectoryEntity> directoryEntities, Directory precedingDirectory) {
        List<String> matchingNamesInDirectory;
        EntityQuery<String> remainingEntitiesQuery = this.createRemainingEntitiesQuery(originalQuery, directoryEntities);
        SingleDirectorySearchStrategy searchStrategy = new SingleDirectorySearchStrategy(this.directoryManager, precedingDirectory.getId());
        if (remainingEntitiesQuery.getEntityDescriptor().equals((Object)EntityDescriptor.user())) {
            matchingNamesInDirectory = searchStrategy.searchUsers(remainingEntitiesQuery);
        } else if (remainingEntitiesQuery.getEntityDescriptor().equals((Object)EntityDescriptor.group())) {
            matchingNamesInDirectory = searchStrategy.searchGroups(remainingEntitiesQuery);
        } else {
            throw new IllegalArgumentException("Type " + remainingEntitiesQuery.getReturnType() + "is not supported");
        }
        return matchingNamesInDirectory;
    }

    private <T> EntityQuery<String> createRemainingEntitiesQuery(MembershipQuery<T> originalQuery, List<DirectoryEntity> directoryEntities) {
        List remainingEntitiesRestrictions = directoryEntities.stream().map(user -> Restriction.on((Property)UserTermKeys.USERNAME).exactlyMatching((Object)user.getName())).collect(Collectors.toList());
        NullRestriction queryRestriction = remainingEntitiesRestrictions.size() > 0 ? Combine.anyOf(remainingEntitiesRestrictions) : NullRestrictionImpl.INSTANCE;
        return QueryBuilder.queryFor(String.class, (EntityDescriptor)originalQuery.getEntityToReturn(), (SearchRestriction)queryRestriction, (int)0, (int)-1);
    }

    private void removeCanonicalUsers(Set<String> canonicalUserNames, List<DirectoryEntity> usersInSucceedingDirectories) {
        Iterables.removeIf(usersInSucceedingDirectories, entity -> canonicalUserNames.contains(DirectoryEntities.LOWER_NAME_FUNCTION.apply(entity)));
    }

    private User findUserByName(String name) throws UserNotFoundException {
        for (Directory directory : this.activeDirectories) {
            try {
                User user = this.directoryManager.findUserByName(directory.getId().longValue(), name);
                logger.debug("Located user '{}' in directory {} '{}'", new Object[]{user.getName(), directory.getId(), directory.getName()});
                return user;
            }
            catch (UserNotFoundException user) {
            }
            catch (DirectoryNotFoundException e) {
                logger.debug("Directory {} '{}' was active at the start of the loop, but can no longer be found", (Object)directory.getId(), (Object)directory.getName());
                throw InMemoryNonAggregatingSearchStrategy.concurrentModificationExceptionForDirectoryIteration(e);
            }
            catch (OperationFailedException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        throw new UserNotFoundException(name);
    }

    private Group findGroupByName(String name) throws GroupNotFoundException {
        for (Directory directory : this.activeDirectories) {
            try {
                return this.directoryManager.findGroupByName(directory.getId().longValue(), name);
            }
            catch (GroupNotFoundException groupNotFoundException) {
            }
            catch (DirectoryNotFoundException e) {
                throw InMemoryNonAggregatingSearchStrategy.concurrentModificationExceptionForDirectoryIteration(e);
            }
            catch (OperationFailedException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        throw new GroupNotFoundException(name);
    }

    private DirectoryEntity findEntityByName(String entityName, EntityDescriptor entityDescriptor) throws ObjectNotFoundException {
        if (entityDescriptor == EntityDescriptor.user()) {
            return this.findUserByName(entityName);
        }
        if (entityDescriptor == EntityDescriptor.group()) {
            return this.findGroupByName(entityName);
        }
        throw new IllegalArgumentException("Expected a User or Group");
    }

    private static List<DirectoryEntity> usersInDirectory(final long directoryId, List<String> names) {
        return Lists.transform(names, (Function)new Function<String, DirectoryEntity>(){

            public DirectoryEntity apply(String name) {
                return new LightweightUser(directoryId, name);
            }
        });
    }

    private static List<DirectoryEntity> groupsInDirectory(final long directoryId, List<String> names) {
        return Lists.transform(names, (Function)new Function<String, DirectoryEntity>(){

            public DirectoryEntity apply(String name) {
                return new LightweightGroup(directoryId, name);
            }
        });
    }

    private static ConcurrentModificationException concurrentModificationExceptionForDirectoryIteration(DirectoryNotFoundException e) {
        ConcurrentModificationException concurrentModificationException = new ConcurrentModificationException("Directory mapping was removed while iterating through directories");
        concurrentModificationException.initCause(e);
        return concurrentModificationException;
    }

    private static class LightweightGroup
    extends LightweightDirectoryEntity {
        LightweightGroup(long directoryId, String name) {
            super(directoryId, name);
        }
    }

    private static class LightweightUser
    extends LightweightDirectoryEntity {
        LightweightUser(long directoryId, String name) {
            super(directoryId, name);
        }
    }

    private static abstract class LightweightDirectoryEntity
    implements DirectoryEntity {
        private final long directoryId;
        private final String name;

        LightweightDirectoryEntity(long directoryId, String name) {
            this.directoryId = directoryId;
            this.name = (String)Preconditions.checkNotNull((Object)name);
        }

        public long getDirectoryId() {
            return this.directoryId;
        }

        public String getName() {
            return this.name;
        }

        public int hashCode() {
            return 31 * (31 + (int)(this.directoryId ^ this.directoryId >>> 32)) + IdentifierUtils.toLowerCase((String)this.name).hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            LightweightDirectoryEntity other = (LightweightDirectoryEntity)obj;
            return this.directoryId == other.directoryId && IdentifierUtils.equalsInLowerCase((String)this.name, (String)other.name);
        }
    }
}

