/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.directory;

import com.atlassian.crowd.core.event.DelegatingMultiEventPublisher;
import com.atlassian.crowd.core.event.MultiEventPublisher;
import com.atlassian.crowd.dao.group.InternalGroupDao;
import com.atlassian.crowd.dao.user.InternalUserDao;
import com.atlassian.crowd.directory.DbCachingRemoteChangeOperations;
import com.atlassian.crowd.directory.DirectoryCacheChangeOperations;
import com.atlassian.crowd.directory.DirectoryCacheImplUsingChangeOperations;
import com.atlassian.crowd.directory.InternalRemoteDirectory;
import com.atlassian.crowd.directory.RemoteDirectory;
import com.atlassian.crowd.directory.ldap.cache.DirectoryCacheFactory;
import com.atlassian.crowd.directory.synchronisation.cache.DefaultGroupActionStrategy;
import com.atlassian.crowd.directory.synchronisation.cache.DirectoryCache;
import com.atlassian.crowd.directory.synchronisation.cache.ExternalIdCheckingGroupActionStrategy;
import com.atlassian.crowd.directory.synchronisation.cache.GroupActionStrategy;
import com.atlassian.crowd.embedded.spi.DirectoryDao;
import com.atlassian.crowd.manager.directory.SynchronisationStatusManager;
import com.atlassian.event.api.EventPublisher;

public class DirectoryCacheFactoryImpl
implements DirectoryCacheFactory {
    private static final String AZURE_AD_CLASS_NAME = "com.atlassian.crowd.directory.AzureAdDirectory";
    private final DirectoryDao directoryDao;
    private final SynchronisationStatusManager synchronisationStatusManager;
    private final MultiEventPublisher eventPublisher;
    private final InternalUserDao userDao;
    private final InternalGroupDao groupDao;

    public DirectoryCacheFactoryImpl(DirectoryDao directoryDao, SynchronisationStatusManager synchronisationStatusManager, EventPublisher eventPublisher, InternalUserDao userDao, InternalGroupDao groupDao) {
        this(directoryDao, synchronisationStatusManager, new DelegatingMultiEventPublisher(eventPublisher), userDao, groupDao);
    }

    public DirectoryCacheFactoryImpl(DirectoryDao directoryDao, SynchronisationStatusManager synchronisationStatusManager, MultiEventPublisher eventPublisher, InternalUserDao userDao, InternalGroupDao groupDao) {
        this.directoryDao = directoryDao;
        this.synchronisationStatusManager = synchronisationStatusManager;
        this.eventPublisher = eventPublisher;
        this.userDao = userDao;
        this.groupDao = groupDao;
    }

    DirectoryCacheChangeOperations createDirectoryCacheChangeOperations(RemoteDirectory remoteDirectory, InternalRemoteDirectory internalDirectory) {
        return new DbCachingRemoteChangeOperations(this.directoryDao, remoteDirectory, internalDirectory, this.synchronisationStatusManager, this.eventPublisher, this.userDao, this.groupDao, (GroupActionStrategy)(remoteDirectory.getClass().getName().equals(AZURE_AD_CLASS_NAME) ? new ExternalIdCheckingGroupActionStrategy() : new DefaultGroupActionStrategy()));
    }

    public final DirectoryCache createDirectoryCache(RemoteDirectory remoteDirectory, InternalRemoteDirectory internalDirectory) {
        DirectoryCacheChangeOperations x = this.createDirectoryCacheChangeOperations(remoteDirectory, internalDirectory);
        return new DirectoryCacheImplUsingChangeOperations(x);
    }
}

