/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.manager.directory;

import com.atlassian.beehive.ClusterLock;
import com.atlassian.beehive.ClusterLockService;
import com.atlassian.crowd.directory.RemoteDirectory;
import com.atlassian.crowd.directory.SynchronisableDirectory;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectorySynchronisationRoundInformation;
import com.atlassian.crowd.event.directory.RemoteDirectorySynchronisationFailedEvent;
import com.atlassian.crowd.event.directory.RemoteDirectorySynchronisedEvent;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.manager.directory.DirectorySynchronisationUtils;
import com.atlassian.crowd.manager.directory.DirectorySynchroniser;
import com.atlassian.crowd.manager.directory.DirectorySynchroniserHelper;
import com.atlassian.crowd.manager.directory.SynchronisationMode;
import com.atlassian.crowd.manager.directory.SynchronisationStatusManager;
import com.atlassian.crowd.model.directory.SynchronisationStatusKey;
import com.atlassian.event.api.EventPublisher;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public class DirectorySynchroniserImpl
implements DirectorySynchroniser {
    private static final Logger log = LoggerFactory.getLogger(DirectorySynchroniser.class);
    private final ClusterLockService lockService;
    private final DirectorySynchroniserHelper directorySynchroniserHelper;
    private final SynchronisationStatusManager synchronisationStatusManager;
    private final EventPublisher eventPublisher;

    public DirectorySynchroniserImpl(ClusterLockService lockService, DirectorySynchroniserHelper directorySynchroniserHelper, SynchronisationStatusManager synchronisationStatusManager, EventPublisher eventPublisher) {
        this.lockService = lockService;
        this.directorySynchroniserHelper = directorySynchroniserHelper;
        this.synchronisationStatusManager = synchronisationStatusManager;
        this.eventPublisher = eventPublisher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional(propagation=Propagation.NEVER)
    public void synchronise(SynchronisableDirectory remoteDirectory, SynchronisationMode mode) throws DirectoryNotFoundException, OperationFailedException {
        block12: {
            long directoryId = remoteDirectory.getDirectoryId();
            Directory directory = this.findDirectoryById(directoryId);
            if (!directory.isActive()) {
                log.debug("Request to synchronise directory [ {} ] in {} mode is returning silently because the directory is not active.", (Object)directoryId, (Object)mode);
                return;
            }
            log.debug("request to synchronise directory [ {} ] in {} mode", (Object)directoryId, (Object)mode);
            ClusterLock lock = this.lockService.getLockForName(DirectorySynchronisationUtils.getLockName(directoryId));
            if (lock.tryLock()) {
                boolean successful = true;
                long startTime = System.currentTimeMillis();
                try {
                    this.directorySynchroniserHelper.updateSyncStartTime(remoteDirectory);
                    this.synchronisationStatusManager.syncStarted(directory);
                    try {
                        remoteDirectory.synchroniseCache(mode, this.synchronisationStatusManager);
                        this.finishSynchronisationIfWasNotFinishedAlready(directory, SynchronisationStatusKey.SUCCESS_FULL);
                        break block12;
                    }
                    catch (Exception ignored) {
                        successful = false;
                        this.finishSynchronisationIfWasNotFinishedAlready(directory, SynchronisationStatusKey.FAILURE);
                        throw ignored;
                    }
                    finally {
                        this.directorySynchroniserHelper.updateSyncEndTime(remoteDirectory);
                    }
                }
                finally {
                    lock.unlock();
                    long timeTakenInMs = System.currentTimeMillis() - startTime;
                    if (successful) {
                        this.eventPublisher.publish((Object)new RemoteDirectorySynchronisedEvent((Object)this, (RemoteDirectory)remoteDirectory, timeTakenInMs));
                    } else {
                        this.eventPublisher.publish((Object)new RemoteDirectorySynchronisationFailedEvent((Object)this, (RemoteDirectory)remoteDirectory, timeTakenInMs));
                    }
                }
            }
            log.debug("directory [ {} ] already synchronising", (Object)directoryId);
        }
    }

    private void finishSynchronisationIfWasNotFinishedAlready(Directory directory, SynchronisationStatusKey defaultKey) {
        DirectorySynchronisationRoundInformation activeRound = this.synchronisationStatusManager.getDirectorySynchronisationInformation(directory).getActiveRound();
        if (activeRound != null) {
            this.synchronisationStatusManager.syncFinished(directory.getId().longValue(), SynchronisationStatusKey.fromKey((String)activeRound.getStatusKey()).orElse(defaultKey), (List)ImmutableList.of());
        }
    }

    @Override
    public boolean isSynchronising(long directoryId) throws DirectoryNotFoundException {
        return this.directorySynchroniserHelper.isSynchronising(directoryId);
    }

    private Directory findDirectoryById(long directoryId) throws DirectoryNotFoundException {
        return this.directorySynchroniserHelper.findDirectoryById(directoryId);
    }
}

