/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.manager.application;

import com.atlassian.crowd.cache.UserAuthorisationCache;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.exception.ApplicationPermissionException;
import com.atlassian.crowd.exception.BulkAddFailedException;
import com.atlassian.crowd.exception.ExpiredCredentialException;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.InactiveAccountException;
import com.atlassian.crowd.exception.InvalidAuthenticationException;
import com.atlassian.crowd.exception.InvalidCredentialException;
import com.atlassian.crowd.exception.InvalidEmailAddressException;
import com.atlassian.crowd.exception.InvalidGroupException;
import com.atlassian.crowd.exception.InvalidMembershipException;
import com.atlassian.crowd.exception.InvalidUserException;
import com.atlassian.crowd.exception.MembershipNotFoundException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.manager.application.ApplicationService;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.group.GroupTemplate;
import com.atlassian.crowd.model.group.GroupWithAttributes;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.model.user.UserTemplate;
import com.atlassian.crowd.model.user.UserTemplateWithCredentialAndAttributes;
import com.atlassian.crowd.model.user.UserWithAttributes;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachingApplicationService
implements ApplicationService {
    private final ApplicationService applicationService;
    private final UserAuthorisationCache userAuthorisationCache;

    public CachingApplicationService(ApplicationService applicationService, UserAuthorisationCache userAuthorisationCache) {
        this.applicationService = (ApplicationService)Preconditions.checkNotNull((Object)applicationService);
        this.userAuthorisationCache = (UserAuthorisationCache)Preconditions.checkNotNull((Object)userAuthorisationCache);
    }

    public User authenticateUser(Application application, String username, PasswordCredential passwordCredential) throws OperationFailedException, InactiveAccountException, InvalidAuthenticationException, ExpiredCredentialException {
        return this.applicationService.authenticateUser(application, username, passwordCredential);
    }

    public boolean isUserAuthorised(Application application, String username) {
        Boolean allowedToAuthenticate = this.userAuthorisationCache.isPermitted(username, application.getName());
        if (allowedToAuthenticate != null) {
            return allowedToAuthenticate;
        }
        boolean permitted = this.applicationService.isUserAuthorised(application, username);
        if (permitted) {
            this.userAuthorisationCache.setPermitted(username, application.getName(), permitted);
        }
        return permitted;
    }

    public void addAllUsers(Application application, Collection<UserTemplateWithCredentialAndAttributes> users) throws ApplicationPermissionException, OperationFailedException, BulkAddFailedException {
        this.applicationService.addAllUsers(application, users);
    }

    public User findUserByName(Application application, String name) throws UserNotFoundException {
        return this.applicationService.findUserByName(application, name);
    }

    public UserWithAttributes findUserWithAttributesByName(Application application, String name) throws UserNotFoundException {
        return this.applicationService.findUserWithAttributesByName(application, name);
    }

    public User addUser(Application application, UserTemplate user, PasswordCredential credential) throws InvalidUserException, OperationFailedException, InvalidCredentialException, ApplicationPermissionException {
        return this.applicationService.addUser(application, user, credential);
    }

    public User updateUser(Application application, UserTemplate user) throws InvalidUserException, OperationFailedException, ApplicationPermissionException, UserNotFoundException {
        return this.applicationService.updateUser(application, user);
    }

    public void updateUserCredential(Application application, String username, PasswordCredential credential) throws OperationFailedException, UserNotFoundException, InvalidCredentialException, ApplicationPermissionException {
        this.applicationService.updateUserCredential(application, username, credential);
    }

    public void resetUserCredential(Application application, String username) throws OperationFailedException, UserNotFoundException, InvalidCredentialException, ApplicationPermissionException, InvalidEmailAddressException {
        this.applicationService.resetUserCredential(application, username);
    }

    public void storeUserAttributes(Application application, String username, Map<String, Set<String>> attributes) throws OperationFailedException, ApplicationPermissionException, UserNotFoundException {
        this.applicationService.storeUserAttributes(application, username, attributes);
    }

    public void removeUserAttributes(Application application, String username, String attributeName) throws OperationFailedException, ApplicationPermissionException, UserNotFoundException {
        this.applicationService.removeUserAttributes(application, username, attributeName);
    }

    public void removeUser(Application application, String user) throws OperationFailedException, UserNotFoundException, ApplicationPermissionException {
        this.applicationService.removeUser(application, user);
    }

    public <T> List<T> searchUsers(Application application, EntityQuery<T> query) {
        return this.applicationService.searchUsers(application, query);
    }

    public List<User> searchUsersAllowingDuplicateNames(Application application, EntityQuery<User> query) {
        return this.applicationService.searchUsersAllowingDuplicateNames(application, query);
    }

    public Group findGroupByName(Application application, String name) throws GroupNotFoundException {
        return this.applicationService.findGroupByName(application, name);
    }

    public GroupWithAttributes findGroupWithAttributesByName(Application application, String name) throws GroupNotFoundException {
        return this.applicationService.findGroupWithAttributesByName(application, name);
    }

    public Group addGroup(Application application, GroupTemplate group) throws InvalidGroupException, OperationFailedException, ApplicationPermissionException {
        return this.applicationService.addGroup(application, group);
    }

    public Group updateGroup(Application application, GroupTemplate group) throws InvalidGroupException, OperationFailedException, ApplicationPermissionException, GroupNotFoundException {
        return this.applicationService.updateGroup(application, group);
    }

    public void storeGroupAttributes(Application application, String groupname, Map<String, Set<String>> attributes) throws OperationFailedException, ApplicationPermissionException, GroupNotFoundException {
        this.applicationService.storeGroupAttributes(application, groupname, attributes);
    }

    public void removeGroupAttributes(Application application, String groupname, String attributeName) throws OperationFailedException, ApplicationPermissionException, GroupNotFoundException {
        this.applicationService.removeGroupAttributes(application, groupname, attributeName);
    }

    public void removeGroup(Application application, String group) throws OperationFailedException, GroupNotFoundException, ApplicationPermissionException {
        this.applicationService.removeGroup(application, group);
    }

    public <T> List<T> searchGroups(Application application, EntityQuery<T> query) {
        return this.applicationService.searchGroups(application, query);
    }

    public void addUserToGroup(Application application, String username, String groupName) throws OperationFailedException, UserNotFoundException, GroupNotFoundException, ApplicationPermissionException {
        this.applicationService.addUserToGroup(application, username, groupName);
    }

    public void addGroupToGroup(Application application, String childGroupName, String parentGroupName) throws OperationFailedException, GroupNotFoundException, ApplicationPermissionException, InvalidMembershipException {
        this.applicationService.addGroupToGroup(application, childGroupName, parentGroupName);
    }

    public void removeUserFromGroup(Application application, String username, String groupName) throws OperationFailedException, GroupNotFoundException, UserNotFoundException, ApplicationPermissionException, MembershipNotFoundException {
        this.applicationService.removeUserFromGroup(application, username, groupName);
    }

    public void removeGroupFromGroup(Application application, String childGroup, String parentGroup) throws OperationFailedException, GroupNotFoundException, ApplicationPermissionException, MembershipNotFoundException {
        this.applicationService.removeGroupFromGroup(application, childGroup, parentGroup);
    }

    public boolean isUserDirectGroupMember(Application application, String username, String groupName) {
        return this.applicationService.isUserDirectGroupMember(application, username, groupName);
    }

    public boolean isGroupDirectGroupMember(Application application, String childGroup, String parentGroup) {
        return this.applicationService.isGroupDirectGroupMember(application, childGroup, parentGroup);
    }

    public boolean isUserNestedGroupMember(Application application, String username, String groupName) {
        return this.applicationService.isUserNestedGroupMember(application, username, groupName);
    }

    public boolean isGroupNestedGroupMember(Application application, String childGroup, String parentGroup) {
        return this.applicationService.isGroupNestedGroupMember(application, childGroup, parentGroup);
    }

    public <T> List<T> searchDirectGroupRelationships(Application application, MembershipQuery<T> query) {
        return this.applicationService.searchDirectGroupRelationships(application, query);
    }

    public <T> List<T> searchNestedGroupRelationships(Application application, MembershipQuery<T> query) {
        return this.applicationService.searchNestedGroupRelationships(application, query);
    }
}

