/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.directory;

import java.text.MessageFormat;
import java.util.Stack;

public class TimerStack {
    private static ThreadLocal<Stack<TimerStackNode>> current = new ThreadLocal();

    public static String pop(String message) {
        Stack<TimerStackNode> stack = current.get();
        TimerStackNode timerStackNode = stack.pop();
        String formattedTime = TimerStack.formatTime(System.currentTimeMillis() - timerStackNode.startTime);
        String result = null;
        try {
            result = new MessageFormat(message).format(new Object[]{formattedTime});
        }
        catch (IllegalArgumentException e) {
            result = "IllegalArgumentException: " + e.getMessage() + ": " + message;
        }
        if (stack.isEmpty()) {
            current.remove();
        }
        return result;
    }

    private static String formatTime(long time) {
        return String.valueOf(time) + "ms";
    }

    public static void push() {
        Stack<TimerStackNode> stack = current.get();
        if (stack == null) {
            stack = new Stack();
        }
        stack.push(new TimerStackNode());
        current.set(stack);
    }

    private static class TimerStackNode {
        public final long startTime = System.currentTimeMillis();
    }
}

