/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.cache;

import com.atlassian.crowd.cache.UserAuthorisationCache;
import com.atlassian.crowd.manager.cache.CacheManager;
import com.atlassian.crowd.manager.cache.NotInCacheException;
import com.google.common.collect.ImmutableList;
import java.io.Serializable;

public class UserAuthorisationCacheImpl
implements UserAuthorisationCache {
    private static final String CACHE_NAME = "com.atlassian.crowd.userauthorisationcache";
    private final CacheManager cacheManager;

    public UserAuthorisationCacheImpl(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public void setPermitted(String userName, String applicationName, boolean permitted) {
        this.cacheManager.put(CACHE_NAME, this.getCacheKey(userName, applicationName), (Serializable)Boolean.valueOf(permitted));
    }

    public Boolean isPermitted(String userName, String applicationName) {
        try {
            return (Boolean)this.cacheManager.get(CACHE_NAME, this.getCacheKey(userName, applicationName));
        }
        catch (NotInCacheException e) {
            return null;
        }
    }

    public void clear() {
        this.cacheManager.removeAll(CACHE_NAME);
    }

    private Serializable getCacheKey(String userName, String applicationName) {
        return ImmutableList.of((Object)userName, (Object)applicationName);
    }
}

