/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.util;

import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.model.user.UserTemplate;
import com.atlassian.crowd.util.Assert;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class UserUtils {
    public static final String EMAIL_REGEX = "(?:[a-z0-9!#$%&'*+/=?^_`{|}~-]+(?:\\.[a-z0-9!#$%&'*+/=?^_`{|}~-]+)*|\"(?:[\\x01-\\x08\\x0b\\x0c\\x0e-\\x1f\\x21\\x23-\\x5b\\x5d-\\x7f]|\\\\[\\x01-\\x09\\x0b\\x0c\\x0e-\\x7f])*\")@(?:(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?|\\[(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?|[a-z0-9-]*[a-z0-9]:(?:[\\x01-\\x08\\x0b\\x0c\\x0e-\\x1f\\x21-\\x5a\\x53-\\x7f]|\\\\[\\x01-\\x09\\x0b\\x0c\\x0e-\\x7f])+)\\])";
    private static final Pattern EMAIL_PATTERN = Pattern.compile("(?:[a-z0-9!#$%&'*+/=?^_`{|}~-]+(?:\\.[a-z0-9!#$%&'*+/=?^_`{|}~-]+)*|\"(?:[\\x01-\\x08\\x0b\\x0c\\x0e-\\x1f\\x21\\x23-\\x5b\\x5d-\\x7f]|\\\\[\\x01-\\x09\\x0b\\x0c\\x0e-\\x7f])*\")@(?:(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?|\\[(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?|[a-z0-9-]*[a-z0-9]:(?:[\\x01-\\x08\\x0b\\x0c\\x0e-\\x1f\\x21-\\x5a\\x53-\\x7f]|\\\\[\\x01-\\x09\\x0b\\x0c\\x0e-\\x7f])+)\\])");

    public static boolean isValidEmail(String email) {
        if (email == null) {
            return false;
        }
        Matcher matcher = EMAIL_PATTERN.matcher(email);
        return matcher.find();
    }

    static String[] getFirstNameLastName(String fullname) {
        String lastName;
        String firstName;
        String[] strings = StringUtils.split((String)fullname, (String)" ", (int)2);
        if (strings == null || strings.length == 0) {
            firstName = "";
            lastName = "";
        } else if (strings.length > 1) {
            firstName = strings[0].trim();
            lastName = strings[1].trim();
        } else {
            firstName = "";
            lastName = strings[0].trim();
        }
        return new String[]{firstName, lastName};
    }

    static String getDisplayName(String displayName, String firstName, String lastName, String username) {
        Assert.notBlank((String)username);
        if (StringUtils.isNotBlank((String)displayName)) {
            return displayName;
        }
        if (StringUtils.isNotBlank((String)firstName) && StringUtils.isNotBlank((String)lastName)) {
            return firstName + " " + lastName;
        }
        if (StringUtils.isNotBlank((String)firstName)) {
            return firstName;
        }
        if (StringUtils.isNotBlank((String)lastName)) {
            return lastName;
        }
        return username;
    }

    static String getFirstName(String firstName, String displayName) {
        if (StringUtils.isNotBlank((String)firstName)) {
            return firstName;
        }
        String[] firstLast = UserUtils.getFirstNameLastName(displayName);
        return firstLast[0];
    }

    static String getLastName(String lastName, String displayName) {
        Assert.notBlank((String)displayName);
        if (StringUtils.isNotBlank((String)lastName)) {
            return lastName;
        }
        String[] firstLast = UserUtils.getFirstNameLastName(displayName);
        if (StringUtils.isNotBlank((String)firstLast[1])) {
            return firstLast[1];
        }
        return displayName;
    }

    public static User populateNames(User user) {
        UserTemplate populatedUser = new UserTemplate(user);
        String calculatedDisplayName = UserUtils.getDisplayName(user.getDisplayName(), user.getFirstName(), user.getLastName(), user.getName());
        populatedUser.setDisplayName(calculatedDisplayName);
        if (StringUtils.isNotBlank((String)user.getDisplayName()) || StringUtils.isBlank((String)user.getLastName())) {
            populatedUser.setFirstName(UserUtils.getFirstName(user.getFirstName(), calculatedDisplayName));
            populatedUser.setLastName(UserUtils.getLastName(user.getLastName(), calculatedDisplayName));
        } else {
            populatedUser.setFirstName(StringUtils.defaultString((String)populatedUser.getFirstName(), (String)""));
        }
        return populatedUser;
    }
}

