/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.directory;

import com.atlassian.crowd.directory.RemoteDirectory;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.exception.ExpiredCredentialException;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.InactiveAccountException;
import com.atlassian.crowd.exception.InvalidAuthenticationException;
import com.atlassian.crowd.exception.InvalidGroupException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.OperationNotSupportedException;
import com.atlassian.crowd.exception.ProductNotFoundException;
import com.atlassian.crowd.exception.ProductPermissionAlreadyExistsException;
import com.atlassian.crowd.exception.ProductPermissionNotFoundException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.group.GroupTemplate;
import com.atlassian.crowd.model.group.InternalDirectoryGroup;
import com.atlassian.crowd.model.permission.ProductPermission;
import com.atlassian.crowd.model.user.TimestampedUser;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.model.user.UserTemplate;
import com.atlassian.crowd.model.user.UserTemplateWithCredentialAndAttributes;
import com.atlassian.crowd.model.user.UserWithAttributes;
import com.atlassian.crowd.util.BatchResult;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;

public interface InternalRemoteDirectory
extends RemoteDirectory {
    public TimestampedUser findUserByName(String var1) throws UserNotFoundException;

    public TimestampedUser findUserByExternalId(String var1) throws UserNotFoundException;

    public TimestampedUser findUserByAccountId(String var1) throws UserNotFoundException;

    public InternalDirectoryGroup findGroupByName(String var1) throws GroupNotFoundException;

    public Group addLocalGroup(GroupTemplate var1) throws InvalidGroupException, OperationFailedException;

    public BatchResult<User> addAllUsers(Set<UserTemplateWithCredentialAndAttributes> var1);

    @Override
    default public User importUser(UserTemplate user, Map<String, Set<String>> attributes) throws OperationFailedException {
        throw new UnsupportedOperationException();
    }

    @Override
    default public User requestAccess(UserTemplate user, Set<String> extraGroups, Set<String> extraProducts, Optional<String> invitationText, Optional<String> continueUrl) throws OperationFailedException {
        throw new UnsupportedOperationException();
    }

    @Override
    default public User activateUser(String email) throws OperationFailedException {
        throw new UnsupportedOperationException();
    }

    @Override
    default public User deactivateUser(String email) throws OperationFailedException {
        throw new UnsupportedOperationException();
    }

    @Override
    default public User addConnectUser(String addonKey, Set<String> billingKeys, boolean isAdmin) throws OperationFailedException {
        throw new UnsupportedOperationException();
    }

    @Override
    default public User addConnectUser(String addonKey, Optional<String> displayName, Set<String> billingKeys, boolean isAdmin) throws OperationFailedException {
        throw new UnsupportedOperationException();
    }

    public BatchResult<Group> addAllGroups(Set<GroupTemplate> var1);

    public BatchResult<String> addAllUsersToGroup(Set<String> var1, String var2) throws GroupNotFoundException;

    public BatchResult<String> removeAllUsers(Set<String> var1);

    public BatchResult<String> removeAllGroups(Set<String> var1);

    public User forceRenameUser(@Nonnull User var1, @Nonnull String var2) throws UserNotFoundException;

    @Nonnull
    public Set<String> getAllUserExternalIds() throws OperationFailedException;

    public long getUserCount() throws OperationFailedException;

    public PasswordCredential getCredential(User var1) throws UserNotFoundException;

    public UserWithAttributes findUserWithAttributesByEmail(String var1) throws UserNotFoundException;

    @Nonnull
    public Collection<User> findUsersByEmail(String var1);

    public User authenticateLocalServiceDeskUser(String var1, UserWithAttributes var2, PasswordCredential var3) throws InactiveAccountException, InvalidAuthenticationException, ExpiredCredentialException, UserNotFoundException;

    @Override
    default public boolean supportsProductPermissions() {
        return true;
    }

    public void addProductPermission(ProductPermission var1) throws OperationFailedException, GroupNotFoundException, ProductNotFoundException, ProductPermissionAlreadyExistsException;

    public void updateProductPermission(ProductPermission var1) throws OperationNotSupportedException, OperationFailedException, GroupNotFoundException, ProductPermissionNotFoundException, ProductNotFoundException;

    public void removeProductPermission(ProductPermission var1) throws OperationFailedException, GroupNotFoundException, ProductNotFoundException, ProductPermissionNotFoundException;

    public void removeCachedExternalIds();
}

