/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.utils;

import com.atlassian.crowd.acceptance.utils.CrowdTestingEngine;
import java.io.File;
import java.io.PrintStream;
import java.net.URL;
import java.util.List;
import java.util.concurrent.TimeUnit;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import net.sourceforge.jwebunit.api.ITestingEngine;
import net.sourceforge.jwebunit.html.Table;
import net.sourceforge.jwebunit.junit.WebTester;
import net.sourceforge.jwebunit.util.TestContext;
import net.sourceforge.jwebunit.util.TestingEngineRegistry;
import org.apache.log4j.Logger;

public class CrowdWebTestCase
extends TestCase {
    protected WebTester tester = null;
    protected final Logger logger = Logger.getLogger(((Object)((Object)this)).getClass());

    public CrowdWebTestCase(String name) throws ClassNotFoundException {
        super(name);
        this.setTestingEngineKey(CrowdTestingEngine.CROWD_TESTING_ENGINE_KEY);
    }

    public CrowdWebTestCase() {
    }

    public void tearDown() throws Exception {
        this.closeBrowser();
        super.tearDown();
    }

    protected void setUp() throws Exception {
        super.setUp();
        TestingEngineRegistry.addTestingEngine((String)CrowdTestingEngine.CROWD_TESTING_ENGINE_KEY, (String)CrowdTestingEngine.class.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runBare() throws Throwable {
        try {
            this.tester = new WebTester();
            super.runBare();
        }
        finally {
            this.tester = null;
        }
    }

    public ITestingEngine getDialog() {
        return this.tester.getDialog();
    }

    public void closeBrowser() {
        this.tester.closeBrowser();
    }

    public void closeWindow() {
        this.tester.closeWindow();
    }

    public void setDialog(ITestingEngine aIJWebUnitDialog) {
        this.tester.setDialog(aIJWebUnitDialog);
    }

    public TestContext getTestContext() {
        return this.tester.getTestContext();
    }

    public void setTestContext(TestContext aTestContext) {
        this.tester.setTestContext(aTestContext);
    }

    public void beginAt(String aRelativeURL) {
        try {
            this.tester.beginAt(aRelativeURL);
        }
        catch (AssertionFailedError error) {
            System.err.print(this.tester.getPageSource());
            throw error;
        }
    }

    public String getMessage(String key) {
        return this.tester.getMessage(key);
    }

    public void assertTitleEquals(String title) {
        this.tester.assertTitleEquals(title);
    }

    public void assertTitleMatch(String regexp) {
        this.tester.assertTitleMatch(regexp);
    }

    public void assertTitleEqualsKey(String titleKey) {
        this.tester.assertTitleEqualsKey(titleKey);
    }

    public void assertKeyPresent(String key) {
        try {
            this.tester.assertKeyPresent(key);
        }
        catch (AssertionFailedError error) {
            System.err.println("Unable to find key " + key + "(text: \"" + this.getMessage(key) + "\") in page: ");
            System.err.print(this.tester.getPageSource());
            throw error;
        }
    }

    public void assertKeyPresent(String key, List args) {
        try {
            this.tester.assertKeyPresent(key, args.toArray());
        }
        catch (AssertionFailedError error) {
            System.err.print(this.tester.getPageSource());
            throw error;
        }
    }

    public void assertTextPresent(String text) {
        this.assertTextPresent(text, false);
    }

    public void assertTextPresent(String text, boolean suppressMessage) {
        try {
            this.tester.assertTextPresent(text);
        }
        catch (AssertionFailedError error) {
            if (!suppressMessage) {
                System.err.println("Unable to find " + text + " in:");
                System.err.print(this.tester.getPageSource());
            }
            throw error;
        }
    }

    public void assertMatch(String regexp) {
        this.tester.assertMatch(regexp);
    }

    public void assertKeyNotPresent(String key) {
        try {
            this.tester.assertKeyNotPresent(key);
        }
        catch (AssertionFailedError error) {
            System.err.println("Key " + key + " (value: " + this.getMessage(key) + ") was present in page: ");
            System.err.print(this.tester.getPageSource());
            throw error;
        }
    }

    public void assertWarningNotPresent() {
        if (this.tester.getPageSource().indexOf("noteBox") > 0) {
            System.err.print(this.tester.getPageSource());
            Assert.fail((String)"Warning present in page!");
        }
    }

    public void assertErrorNotPresent() {
        if (this.tester.getPageSource().indexOf("warningBox") > 0 || this.tester.getPageSource().indexOf("errorBox") > 0) {
            System.err.print(this.tester.getPageSource());
            Assert.fail((String)"Error present in page!");
        }
    }

    public void assertWarningAndErrorNotPresent() {
        this.assertErrorNotPresent();
        this.assertWarningNotPresent();
    }

    public void assertErrorPresent() {
        if (this.tester.getPageSource().indexOf("errorBox") < 0) {
            System.err.print(this.tester.getPageSource());
            Assert.fail((String)"Error not present in page!");
        }
    }

    public void assertErrorPresentWithKey(String keyName) {
        this.assertErrorPresent();
        this.assertKeyPresent(keyName);
    }

    public void assertErrorPresentWithText(String text) {
        this.assertErrorPresent();
        this.assertTextPresent(text);
    }

    public void assertWarningPresent() {
        if (this.tester.getPageSource().indexOf("warningBox") < 0) {
            System.err.print(this.tester.getPageSource());
            Assert.fail((String)"Warning not present in page!");
        }
    }

    public void assertWarningPresentWithKey(String keyName) {
        this.assertWarningPresent();
        this.assertKeyPresent(keyName);
    }

    public void assertWarningPresentWithText(String text) {
        this.assertWarningPresent();
        this.assertTextPresent(text);
    }

    public void assertTextNotPresent(String text) {
        this.tester.assertTextNotPresent(text);
    }

    public void assertNoMatch(String regexp) {
        this.tester.assertNoMatch(regexp);
    }

    public Table getTable(String tableSummaryNameOrId) {
        return this.tester.getTable(tableSummaryNameOrId);
    }

    public void assertTablePresent(String tableSummaryNameOrId) {
        this.tester.assertTablePresent(tableSummaryNameOrId);
    }

    public void assertTableNotPresent(String tableSummaryNameOrId) {
        this.tester.assertTableNotPresent(tableSummaryNameOrId);
    }

    public void assertKeyInTable(String tableSummaryOrId, String key) {
        this.tester.assertKeyInTable(tableSummaryOrId, key);
    }

    public void assertTextInTable(String tableSummaryNameOrId, String text) {
        try {
            this.tester.assertTextInTable(tableSummaryNameOrId, text);
        }
        catch (AssertionFailedError e) {
            System.err.print(this.tester.getPageSource());
            throw e;
        }
    }

    public void assertMatchInTable(String tableSummaryNameOrId, String regexp) {
        this.tester.assertMatchInTable(tableSummaryNameOrId, regexp);
    }

    public void assertKeysInTable(String tableSummaryOrId, String[] keys) {
        this.tester.assertKeysInTable(tableSummaryOrId, keys);
    }

    public void assertTextInTable(String tableSummaryOrId, String[] text) {
        try {
            this.tester.assertTextInTable(tableSummaryOrId, text);
        }
        catch (AssertionFailedError e) {
            System.err.print(this.tester.getPageSource());
            throw e;
        }
    }

    public void assertMatchInTable(String tableSummaryOrId, String[] regexp) {
        try {
            this.tester.assertMatchInTable(tableSummaryOrId, regexp);
        }
        catch (AssertionFailedError e) {
            System.err.print(this.tester.getPageSource());
            throw e;
        }
    }

    public void assertKeyNotInTable(String tableSummaryOrId, String key) {
        this.tester.assertKeyNotInTable(tableSummaryOrId, key);
    }

    public void assertTextNotInTable(String tableSummaryNameOrId, String text) {
        try {
            this.tester.assertTextNotInTable(tableSummaryNameOrId, text);
        }
        catch (AssertionFailedError error) {
            System.err.print(this.tester.getPageSource());
            throw error;
        }
    }

    public void assertTextNotInTable(String tableSummaryNameOrId, String[] text) {
        try {
            this.tester.assertTextNotInTable(tableSummaryNameOrId, text);
        }
        catch (AssertionFailedError error) {
            System.err.print(this.tester.getPageSource());
            throw error;
        }
    }

    public void assertNoMatchInTable(String tableSummaryNameOrId, String regexp) {
        this.tester.assertNoMatchInTable(tableSummaryNameOrId, regexp);
    }

    public void assertNoMatchInTable(String tableSummaryNameOrId, String[] regexp) {
        this.tester.assertNoMatchInTable(tableSummaryNameOrId, regexp);
    }

    public void assertTableEquals(String tableSummaryNameOrId, Table expectedTable) {
        this.tester.assertTableEquals(tableSummaryNameOrId, expectedTable);
    }

    public void assertTableEquals(String tableSummaryNameOrId, String[][] expectedCellValues) {
        this.tester.assertTableEquals(tableSummaryNameOrId, expectedCellValues);
    }

    public void assertTableRowsEqual(String tableSummaryNameOrId, int startRow, Table expectedTable) {
        this.tester.assertTableRowsEqual(tableSummaryNameOrId, startRow, expectedTable);
    }

    public void assertTableRowsEqual(String tableSummaryNameOrId, int startRow, String[][] expectedTable) {
        this.tester.assertTableRowsEqual(tableSummaryNameOrId, startRow, expectedTable);
    }

    public void assertTableRowCountEquals(String tableSummaryNameOrId, int expectedRowCount) {
        try {
            this.tester.assertTableRowCountEquals(tableSummaryNameOrId, expectedRowCount);
        }
        catch (AssertionFailedError error) {
            System.err.print(this.tester.getPageSource());
            throw error;
        }
    }

    public void assertTableMatch(String tableSummaryOrId, Table expectedTable) {
        this.tester.assertTableMatch(tableSummaryOrId, expectedTable);
    }

    public void assertTableMatch(String tableSummaryOrId, String[][] expectedCellValues) {
        this.tester.assertTableMatch(tableSummaryOrId, expectedCellValues);
    }

    public void assertTableRowsMatch(String tableSummaryOrId, int startRow, Table expectedTable) {
        this.tester.assertTableRowsMatch(tableSummaryOrId, startRow, expectedTable);
    }

    public void assertTableRowsMatch(String tableSummaryOrId, int startRow, String[][] expectedTable) {
        this.tester.assertTableRowsMatch(tableSummaryOrId, startRow, expectedTable);
    }

    public void assertFormElementPresent(String formElementName) {
        this.tester.assertFormElementPresent(formElementName);
    }

    public void assertFormElementNotPresent(String formElementName) {
        this.tester.assertFormElementNotPresent(formElementName);
    }

    public void assertCheckboxPresent(String checkboxName) {
        this.tester.assertCheckboxPresent(checkboxName);
    }

    public void assertCheckboxPresent(String checkboxName, String checkboxValue) {
        this.tester.assertCheckboxPresent(checkboxName, checkboxValue);
    }

    public void assertCheckboxNotPresent(String checkboxName) {
        this.tester.assertCheckboxNotPresent(checkboxName);
    }

    public void assertCheckboxNotPresent(String checkboxName, String checkboxValue) {
        this.tester.assertCheckboxNotPresent(checkboxName, checkboxValue);
    }

    public void assertFormPresent() {
        this.tester.assertFormPresent();
    }

    public void assertFormPresent(String nameOrID) {
        this.tester.assertFormPresent(nameOrID);
    }

    public void assertFormNotPresent() {
        this.tester.assertFormNotPresent();
    }

    public void assertFormNotPresent(String nameOrID) {
        this.tester.assertFormNotPresent(nameOrID);
    }

    public void assertFormElementEquals(String formElementName, String expectedValue) {
        this.tester.assertFormElementEquals(formElementName, expectedValue);
    }

    public void assertFormElementMatch(String formElementName, String regexp) {
        this.tester.assertFormElementMatch(formElementName, regexp);
    }

    public void assertFormElementEmpty(String formElementName) {
        this.tester.assertFormElementEmpty(formElementName);
    }

    public void assertTextFieldEquals(String formElementName, String expectedValue) {
        try {
            this.tester.assertTextFieldEquals(formElementName, expectedValue);
        }
        catch (RuntimeException error) {
            System.err.print(this.tester.getPageSource());
            throw error;
        }
    }

    public void assertHiddenFieldPresent(String formElementName, String expectedValue) {
        this.tester.assertHiddenFieldPresent(formElementName, expectedValue);
    }

    public void assertCheckboxSelected(String checkBoxName) {
        this.tester.assertCheckboxSelected(checkBoxName);
    }

    public void assertCheckboxSelected(String checkBoxName, String checkBoxValue) {
        this.tester.assertCheckboxSelected(checkBoxName, checkBoxValue);
    }

    public void assertCheckboxNotSelected(String checkBoxName) {
        try {
            this.tester.assertCheckboxNotSelected(checkBoxName);
        }
        catch (RuntimeException error) {
            System.err.print(this.tester.getPageSource());
            throw error;
        }
    }

    public void assertCheckboxNotSelected(String checkBoxName, String checkBoxValue) {
        try {
            this.tester.assertCheckboxNotSelected(checkBoxName, checkBoxValue);
        }
        catch (RuntimeException error) {
            System.err.print(this.tester.getPageSource());
            throw error;
        }
    }

    public void assertRadioOptionPresent(String name, String radioOption) {
        this.tester.assertRadioOptionPresent(name, radioOption);
    }

    public void assertRadioOptionNotPresent(String name, String radioOption) {
        this.tester.assertRadioOptionNotPresent(name, radioOption);
    }

    public void assertRadioOptionSelected(String name, String radioOption) {
        this.tester.assertRadioOptionSelected(name, radioOption);
    }

    public void assertRadioOptionNotSelected(String name, String radioOption) {
        this.tester.assertRadioOptionNotSelected(name, radioOption);
    }

    public void assertSelectOptionsPresent(String selectName, String[] optionLabels) {
        this.tester.assertSelectOptionsPresent(selectName, optionLabels);
    }

    public void assertSelectOptionPresent(String selectName, String optionLabel) {
        this.tester.assertSelectOptionPresent(selectName, optionLabel);
    }

    public void assertSelectOptionValuesPresent(String selectName, String[] optionValues) {
        this.tester.assertSelectOptionValuesPresent(selectName, optionValues);
    }

    public void assertSelectOptionValuePresent(String selectName, String optionValue) {
        this.tester.assertSelectOptionValuePresent(selectName, optionValue);
    }

    public void assertSelectOptionValueNotPresent(String selectName, String optionValue) {
        this.tester.assertSelectOptionValueNotPresent(selectName, optionValue);
    }

    public void assertSelectOptionNotPresent(String selectName, String optionLabel) {
        this.tester.assertSelectOptionNotPresent(selectName, optionLabel);
    }

    public void assertSelectOptionsEqual(String selectName, String[] expectedOptions) {
        this.tester.assertSelectOptionsEqual(selectName, expectedOptions);
    }

    public void assertSelectOptionsNotEqual(String selectName, String[] expectedOptions) {
        this.tester.assertSelectOptionsNotEqual(selectName, expectedOptions);
    }

    public void assertSelectOptionValuesEqual(String selectName, String[] expectedValues) {
        this.tester.assertSelectOptionValuesEqual(selectName, expectedValues);
    }

    public void assertSelectOptionValuesNotEqual(String selectName, String[] optionValues) {
        this.tester.assertSelectOptionValuesNotEqual(selectName, optionValues);
    }

    public void assertSelectedOptionsEqual(String selectName, String[] labels) {
        this.tester.assertSelectedOptionsEqual(selectName, labels);
    }

    public void assertSelectedOptionEquals(String selectName, String option) {
        this.tester.assertSelectedOptionEquals(selectName, option);
    }

    public void assertSelectedOptionValuesEqual(String selectName, String[] values) {
        this.tester.assertSelectedOptionValuesEqual(selectName, values);
    }

    public void assertSelectedOptionValueEquals(String selectName, String value) {
        this.tester.assertSelectedOptionValueEquals(selectName, value);
    }

    public void assertSelectedOptionsMatch(String selectName, String[] regexps) {
        this.tester.assertSelectedOptionsMatch(selectName, regexps);
    }

    public void assertSelectedOptionMatches(String selectName, String regexp) {
        this.tester.assertSelectedOptionMatches(selectName, regexp);
    }

    public void assertSubmitButtonPresent() {
        this.tester.assertSubmitButtonPresent();
    }

    public void assertSubmitButtonPresent(String buttonName) {
        this.tester.assertSubmitButtonPresent(buttonName);
    }

    public void assertSubmitButtonNotPresent() {
        this.tester.assertSubmitButtonNotPresent();
    }

    public void assertSubmitButtonNotPresent(String buttonName) {
        this.tester.assertSubmitButtonNotPresent(buttonName);
    }

    public void assertSubmitButtonPresent(String buttonName, String buttonValue) {
        this.tester.assertSubmitButtonPresent(buttonName, buttonValue);
    }

    public void assertResetButtonPresent() {
        this.tester.assertResetButtonPresent();
    }

    public void assertResetButtonPresent(String buttonName) {
        this.tester.assertResetButtonPresent(buttonName);
    }

    public void assertResetButtonNotPresent() {
        this.tester.assertResetButtonNotPresent();
    }

    public void assertResetButtonNotPresent(String buttonName) {
        this.tester.assertResetButtonNotPresent(buttonName);
    }

    public void assertButtonPresent(String buttonId) {
        this.tester.assertButtonPresent(buttonId);
    }

    public void assertButtonPresentWithText(String text) {
        this.tester.assertButtonPresentWithText(text);
    }

    public void assertButtonNotPresentWithText(String text) {
        this.tester.assertButtonNotPresentWithText(text);
    }

    public void assertButtonNotPresent(String buttonId) {
        this.tester.assertButtonNotPresent(buttonId);
    }

    public void assertLinkPresent(String linkId) {
        this.tester.assertLinkPresent(linkId);
    }

    public void assertLinkNotPresent(String linkId) {
        this.tester.assertLinkNotPresent(linkId);
    }

    public void assertLinkPresentWithText(String linkText) {
        try {
            this.tester.assertLinkPresentWithText(linkText);
        }
        catch (AssertionFailedError error) {
            System.err.print(this.tester.getPageSource());
            throw error;
        }
    }

    public void assertLinkPresentWithKey(String keyName) {
        this.assertLinkPresentWithText(this.getMessage(keyName));
    }

    public void assertLinkNotPresentWithText(String linkText) {
        this.tester.assertLinkNotPresentWithText(linkText);
    }

    public void assertLinkPresentWithText(String linkText, int index) {
        this.tester.assertLinkPresentWithText(linkText, index);
    }

    public void assertLinkNotPresentWithText(String linkText, int index) {
        this.tester.assertLinkNotPresentWithText(linkText, index);
    }

    public void assertLinkPresentWithExactText(String linkText) {
        this.tester.assertLinkPresentWithExactText(linkText);
    }

    public void assertLinkNotPresentWithExactText(String linkText) {
        this.tester.assertLinkNotPresentWithExactText(linkText);
    }

    public void assertLinkPresentWithExactText(String linkText, int index) {
        this.tester.assertLinkPresentWithExactText(linkText, index);
    }

    public void assertLinkNotPresentWithExactText(String linkText, int index) {
        this.tester.assertLinkNotPresentWithExactText(linkText, index);
    }

    public void assertLinkPresentWithImage(String imageFileName) {
        this.tester.assertLinkPresentWithImage(imageFileName);
    }

    public void assertLinkNotPresentWithImage(String imageFileName) {
        this.tester.assertLinkNotPresentWithImage(imageFileName);
    }

    public void assertElementPresent(String anID) {
        this.tester.assertElementPresent(anID);
    }

    public void assertElementNotPresent(String anID) {
        this.tester.assertElementNotPresent(anID);
    }

    public void assertElementPresentByXPath(String xpath) {
        this.tester.assertElementPresentByXPath(xpath);
    }

    public void assertElementNotPresentByXPath(String xpath) {
        this.tester.assertElementNotPresentByXPath(xpath);
    }

    public void assertTextInElement(String elementID, String text) {
        try {
            this.tester.assertTextInElement(elementID, text);
        }
        catch (AssertionFailedError error) {
            System.err.print(this.tester.getPageSource());
            throw error;
        }
    }

    public void assertTextNotInElement(String elementID, String text) {
        this.tester.assertTextNotInElement(elementID, text);
    }

    public void assertMatchInElement(String elementID, String regexp) {
        this.tester.assertMatchInElement(elementID, regexp);
    }

    public void assertNoMatchInElement(String elementID, String regexp) {
        this.tester.assertNoMatchInElement(elementID, regexp);
    }

    public void assertWindowPresent(String windowName) {
        this.tester.assertWindowPresent(windowName);
    }

    public void assertWindowPresent(int windowID) {
        this.tester.assertWindowPresent(windowID);
    }

    public void assertWindowPresentWithTitle(String title) {
        this.tester.assertWindowPresentWithTitle(title);
    }

    public void assertWindowCountEquals(int windowCount) {
        this.tester.assertWindowCountEquals(windowCount);
    }

    public void assertFramePresent(String frameNameOrId) {
        this.tester.assertFramePresent(frameNameOrId);
    }

    public void assertCookiePresent(String cookieName) {
        this.tester.assertCookiePresent(cookieName);
    }

    public void assertCookieValueEquals(String cookieName, String expectedValue) {
        this.tester.assertCookieValueEquals(cookieName, expectedValue);
    }

    public void assertCookieValueMatch(String cookieName, String regexp) {
        this.tester.assertCookieValueMatch(cookieName, regexp);
    }

    public String getFormElementValue(String formElementName) {
        return this.tester.getFormElementValue(formElementName);
    }

    public void setWorkingForm(int index) {
        this.tester.setWorkingForm(index);
    }

    public void setWorkingForm(String nameOrId) {
        try {
            this.tester.setWorkingForm(nameOrId);
        }
        catch (AssertionFailedError e) {
            System.err.print(this.tester.getPageSource());
            throw e;
        }
    }

    public void setWorkingForm(String nameOrId, int index) {
        this.tester.setWorkingForm(nameOrId, index);
    }

    public void setTextField(String inputName, String value) {
        try {
            this.tester.setTextField(inputName, value);
        }
        catch (AssertionFailedError e) {
            System.err.print(this.tester.getPageSource());
            throw e;
        }
    }

    public void setRadioButton(String radioButtonName, String value) {
        try {
            this.tester.clickRadioOption(radioButtonName, value);
        }
        catch (AssertionFailedError e) {
            System.err.print(this.tester.getPageSource());
            throw e;
        }
    }

    public void checkCheckbox(String checkBoxName) {
        try {
            this.tester.checkCheckbox(checkBoxName);
        }
        catch (RuntimeException error) {
            System.err.print(this.tester.getPageSource());
            throw error;
        }
    }

    public void checkCheckbox(String checkBoxName, String value) {
        this.tester.checkCheckbox(checkBoxName, value);
    }

    public void uncheckCheckbox(String checkBoxName) {
        try {
            this.tester.uncheckCheckbox(checkBoxName);
        }
        catch (AssertionFailedError error) {
            System.err.print(this.tester.getPageSource());
            throw error;
        }
    }

    public void uncheckCheckbox(String checkBoxName, String value) {
        this.tester.uncheckCheckbox(checkBoxName, value);
    }

    public void selectOptions(String selectName, String[] labels) {
        this.tester.selectOptions(selectName, labels);
    }

    public void selectOption(String selectName, String label) {
        try {
            this.tester.selectOption(selectName, label);
        }
        catch (Error error) {
            System.err.print(this.tester.getPageSource());
            throw error;
        }
    }

    public void selectOptionsByValues(String selectName, String[] values) {
        this.tester.selectOptionsByValues(selectName, values);
    }

    public void selectOptionByValue(String selectName, String value) {
        this.tester.selectOptionByValue(selectName, value);
    }

    public void submit() {
        this.tester.submit();
    }

    public void submit(String buttonName) {
        try {
            this.tester.submit(buttonName);
        }
        catch (Error error) {
            System.err.print(this.tester.getPageSource());
            throw error;
        }
    }

    public void submit(String buttonName, String buttonValue) {
        this.tester.submit(buttonName, buttonValue);
    }

    public void reset() {
        this.tester.reset();
    }

    public void clickLinkWithKey(String key) {
        this.tester.clickLinkWithText(this.getMessage(key));
    }

    public void clickLinkWithText(String linkText) {
        try {
            this.tester.clickLinkWithText(linkText);
        }
        catch (AssertionFailedError error) {
            System.err.print(this.tester.getPageSource());
            throw error;
        }
    }

    public void clickLinkWithText(String linkText, int index) {
        this.tester.clickLinkWithText(linkText, index);
    }

    public void clickLinkWithExactText(String linkText) {
        try {
            this.tester.clickLinkWithExactText(linkText);
        }
        catch (AssertionFailedError e) {
            System.err.print(this.tester.getPageSource());
            throw e;
        }
    }

    public void clickLinkWithExactText(String linkText, int index) {
        this.tester.clickLinkWithExactText(linkText, index);
    }

    public void clickButton(String buttonId) {
        try {
            this.tester.clickButton(buttonId);
        }
        catch (AssertionFailedError error) {
            System.err.print(this.tester.getPageSource());
            throw error;
        }
    }

    public void clickButtonWithText(String buttonValueText) {
        this.tester.clickButtonWithText(buttonValueText);
    }

    public void clickLinkWithImage(String imageFileName) {
        this.tester.clickLinkWithImage(imageFileName);
    }

    public void clickLink(String linkId) {
        try {
            this.tester.clickLink(linkId);
        }
        catch (AssertionFailedError e) {
            System.err.print(this.tester.getPageSource());
            throw e;
        }
    }

    public void clickRadioOption(String radioGroup, String radioOption) {
        this.tester.clickRadioOption(radioGroup, radioOption);
    }

    public void clickElementByXPath(String xpath) {
        this.tester.clickElementByXPath(xpath);
    }

    public String getElementAttributeByXPath(String xpath, String attribute) {
        try {
            return this.tester.getElementAttributeByXPath(xpath, attribute);
        }
        catch (AssertionFailedError e) {
            System.err.print(this.tester.getPageSource());
            throw e;
        }
    }

    public String getElementTextByXPath(String xpath) {
        return this.tester.getElementTextByXPath(xpath);
    }

    public String getElementTextById(String elementId) {
        try {
            return this.tester.getElementById(elementId).getTextContent();
        }
        catch (AssertionFailedError e) {
            System.err.print(this.tester.getPageSource());
            throw e;
        }
    }

    public void gotoWindow(String windowName) {
        this.tester.gotoWindow(windowName);
    }

    public void gotoWindow(int windowID) {
        this.tester.gotoWindow(windowID);
    }

    public void gotoRootWindow() {
        this.tester.gotoRootWindow();
    }

    public void gotoWindowByTitle(String title) {
        this.tester.gotoWindowByTitle(title);
    }

    public void gotoFrame(String frameNameOrId) {
        this.tester.gotoFrame(frameNameOrId);
    }

    public void gotoPage(String url) {
        this.tester.gotoPage(url);
    }

    public void dumpCookies() {
        this.tester.dumpCookies();
    }

    public String getPageSource() {
        return this.tester.getPageSource();
    }

    public String getServerResponse() {
        return this.tester.getServerResponse();
    }

    public void saveAs(File f) {
        this.tester.saveAs(f);
    }

    public void assertDownloadedFileEquals(URL expected) {
        this.tester.assertDownloadedFileEquals(expected);
    }

    public void dumpHtml() {
        this.tester.dumpHtml();
    }

    public void dumpHtml(PrintStream stream) {
        this.tester.dumpHtml(stream);
    }

    public void dumpTable(String tableNameOrId) {
        this.tester.dumpTable(tableNameOrId);
    }

    public void dumpTable(String tableNameOrId, PrintStream stream) {
        this.tester.dumpTable(tableNameOrId, stream);
    }

    public void setScriptingEnabled(boolean value) {
        this.tester.setScriptingEnabled(value);
    }

    public void setTestingEngineKey(String testingEngineKey) {
        this.tester.setTestingEngineKey(testingEngineKey);
    }

    public String getTestingEngineKey() {
        return this.tester.getTestingEngineKey();
    }

    public void setFormElement(String formElementName, String value) {
        this.tester.setFormElement(formElementName, value);
    }

    public void setExpectedJavaScriptAlert(String message) {
        this.tester.setExpectedJavaScriptAlert(message);
    }

    public void setExpectedJavaScriptAlert(String[] messages) {
        this.tester.setExpectedJavaScriptAlert(messages);
    }

    public void setExpectedJavaScriptConfirm(String message, boolean action) {
        this.tester.setExpectedJavaScriptConfirm(message, action);
    }

    public void setExpectedJavaScriptConfirm(String[] messages, boolean[] actions) {
        this.tester.setExpectedJavaScriptConfirm(messages, actions);
    }

    public void setExpectedJavaScriptPrompt(String message, String input) {
        this.tester.setExpectedJavaScriptPrompt(message, input);
    }

    public void setExpectedJavaScriptPrompt(String[] messages, String[] inputs) {
        this.tester.setExpectedJavaScriptPrompt(messages, inputs);
    }

    public void addRequestHeader(String header, String value) {
        this.tester.getTestContext().addRequestHeader(header, value);
    }

    public void assertServerResponseContains(String string) {
        if (!this.tester.getServerResponse().contains(string)) {
            System.err.print(this.tester.getServerResponse());
            throw new AssertionError((Object)("Server response did not contain: " + string));
        }
    }

    public void assertServerResponseDoesNotContain(String string) {
        if (this.tester.getServerResponse().contains(string)) {
            System.err.print(this.tester.getServerResponse());
            throw new AssertionError((Object)("Server response contains: " + string));
        }
    }

    public void setTester(WebTester tester) {
        this.tester = tester;
    }

    public WebTester getTester() {
        return this.tester;
    }

    protected void log(String message) {
        this.logger.info((Object)message);
    }

    protected String getPageText() {
        return this.getTester().getTestingEngine().getPageText();
    }

    public void waitForText(String text, long interval, long maxInterval) throws Exception {
        maxInterval = maxInterval <= 0L ? Integer.MAX_VALUE : maxInterval;
        try {
            this.assertTextPresent(text, true);
            return;
        }
        catch (Throwable throwable) {
            long timeElapsed = TimeUnit.SECONDS.toMillis(10L);
            while (interval + timeElapsed <= maxInterval) {
                Thread.sleep(interval);
                try {
                    this.assertTextPresent(text, true);
                    return;
                }
                catch (Throwable throwable2) {
                    timeElapsed += interval;
                }
            }
            Assert.fail((String)("Unable to find text [" + text + "] on page within " + maxInterval + "ms. \n\nDumping page source: \n" + this.getPageSource()));
            return;
        }
    }

    public boolean isTextPresent(String text) {
        try {
            this.assertTextPresent(text, true);
            return true;
        }
        catch (AssertionFailedError e) {
            return false;
        }
    }

    public void waitForText(String text) throws Exception {
        this.waitForText(text, TimeUnit.SECONDS.toMillis(2L), TimeUnit.SECONDS.toMillis(120L));
    }

    public void assertKeyPresentOnce(String key) {
        String pageText = this.getPageText();
        this.assertKeyPresent(key);
        CrowdWebTestCase.assertEquals((String)("More than one occurrence of key: " + key), (int)pageText.indexOf(this.getMessage(key)), (int)pageText.lastIndexOf(this.getMessage(key)));
    }
}

