/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.persistence.dao.user;

import com.atlassian.crowd.acceptance.tests.persistence.BaseSpringTestCase;
import com.atlassian.crowd.dao.membership.MembershipDAOHibernate;
import com.atlassian.crowd.dao.user.UserDAOHibernate;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.crowd.exception.UserAlreadyExistsException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.user.InternalUser;
import com.atlassian.crowd.model.user.InternalUserWithAttributes;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.model.user.UserTemplate;
import com.atlassian.crowd.model.user.UserTemplateWithCredentialAndAttributes;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.Combine;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.UserQuery;
import com.atlassian.crowd.search.query.entity.restriction.BooleanRestriction;
import com.atlassian.crowd.search.query.entity.restriction.BooleanRestrictionImpl;
import com.atlassian.crowd.search.query.entity.restriction.MatchMode;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.PropertyRestriction;
import com.atlassian.crowd.search.query.entity.restriction.PropertyUtils;
import com.atlassian.crowd.search.query.entity.restriction.TermRestriction;
import com.atlassian.crowd.search.query.entity.restriction.constants.UserTermKeys;
import com.atlassian.crowd.util.BatchResult;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.hibernate.proxy.HibernateProxy;
import org.springframework.jdbc.support.rowset.SqlRowSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserDAOHibernateTest
extends BaseSpringTestCase {
    private UserDAOHibernate userDAO;
    private MembershipDAOHibernate membershipDAO;
    private static final long DIRECTORY_ID = 1L;
    private static final String EXISTING_USER_1 = "admin";
    private static final String EXISTING_USER_2 = "bob";
    private static final String EXISTING_USER_3 = "jane";
    private static final String NON_EXISTING_USER = "newguy";
    private static final String NON_EXISTING_USER_MIXED_CASE = "NewGuy";

    public void testFindByName() throws Exception {
        InternalUser user = this.userDAO.findByName(1L, EXISTING_USER_1);
        UserDAOHibernateTest.assertEquals((String)EXISTING_USER_1, (String)user.getName());
        UserDAOHibernateTest.assertTrue((boolean)user.isActive());
        UserDAOHibernateTest.assertEquals((String)"Admin@example.com", (String)user.getEmailAddress());
        UserDAOHibernateTest.assertEquals((String)"Super", (String)user.getFirstName());
        UserDAOHibernateTest.assertEquals((String)"Man", (String)user.getLastName());
        UserDAOHibernateTest.assertEquals((String)"Super Man", (String)user.getDisplayName());
        UserDAOHibernateTest.assertTrue((boolean)user.getCreatedDate().before(new Date()));
        UserDAOHibernateTest.assertTrue((boolean)user.getUpdatedDate().before(new Date()));
        UserDAOHibernateTest.assertEquals((long)1L, (long)user.getDirectoryId());
        UserDAOHibernateTest.assertEquals((int)2, (int)user.getCredentialHistory().size());
        UserDAOHibernateTest.assertTrue((boolean)((HibernateProxy)user.getDirectory()).getHibernateLazyInitializer().isUninitialized());
    }

    public void testFindByMixedCaseNameExactMatch() throws Exception {
        InternalUser user = this.userDAO.findByName(2L, "JohnSmith");
        UserDAOHibernateTest.assertEquals((String)"JohnSmith", (String)user.getName());
        UserDAOHibernateTest.assertEquals((String)IdentifierUtils.toLowerCase((String)"JohnSmith").toLowerCase(), (String)user.getLowerName());
        UserDAOHibernateTest.assertTrue((boolean)user.isActive());
        UserDAOHibernateTest.assertEquals((String)"johnsmith@smith.com", (String)user.getEmailAddress());
        UserDAOHibernateTest.assertEquals((String)"John", (String)user.getFirstName());
        UserDAOHibernateTest.assertEquals((String)"Smith", (String)user.getLastName());
        UserDAOHibernateTest.assertEquals((String)"John Smith", (String)user.getDisplayName());
        UserDAOHibernateTest.assertTrue((boolean)user.getCreatedDate().before(new Date()));
        UserDAOHibernateTest.assertTrue((boolean)user.getUpdatedDate().before(new Date()));
        UserDAOHibernateTest.assertEquals((long)2L, (long)user.getDirectoryId());
        UserDAOHibernateTest.assertEquals((int)0, (int)user.getCredentialHistory().size());
        UserDAOHibernateTest.assertTrue((boolean)((HibernateProxy)user.getDirectory()).getHibernateLazyInitializer().isUninitialized());
    }

    public void testFindByMixedCaseNameCaseInsensitiveMatch() throws Exception {
        InternalUser user = this.userDAO.findByName(2L, "johnsmith");
        UserDAOHibernateTest.assertEquals((String)"JohnSmith", (String)user.getName());
        UserDAOHibernateTest.assertEquals((String)IdentifierUtils.toLowerCase((String)"JohnSmith"), (String)user.getLowerName());
        UserDAOHibernateTest.assertTrue((boolean)user.isActive());
        UserDAOHibernateTest.assertEquals((String)"johnsmith@smith.com", (String)user.getEmailAddress());
        UserDAOHibernateTest.assertEquals((String)"John", (String)user.getFirstName());
        UserDAOHibernateTest.assertEquals((String)"Smith", (String)user.getLastName());
        UserDAOHibernateTest.assertEquals((String)"John Smith", (String)user.getDisplayName());
        UserDAOHibernateTest.assertTrue((boolean)user.getCreatedDate().before(new Date()));
        UserDAOHibernateTest.assertTrue((boolean)user.getUpdatedDate().before(new Date()));
        UserDAOHibernateTest.assertEquals((long)2L, (long)user.getDirectoryId());
        UserDAOHibernateTest.assertEquals((int)0, (int)user.getCredentialHistory().size());
        UserDAOHibernateTest.assertTrue((boolean)((HibernateProxy)user.getDirectory()).getHibernateLazyInitializer().isUninitialized());
    }

    public void testFindByNameWhereUserDoesNotExist() {
        try {
            this.userDAO.findByName(1L, NON_EXISTING_USER);
            UserDAOHibernateTest.fail((String)"We should of thrown an UserNotFoundException");
        }
        catch (UserNotFoundException userNotFoundException) {
            // empty catch block
        }
    }

    public void testFindByNameWithAttributes() throws Exception {
        InternalUserWithAttributes user = this.userDAO.findByNameWithAttributes(1L, EXISTING_USER_1);
        UserDAOHibernateTest.assertEquals((String)EXISTING_USER_1, (String)user.getName());
        UserDAOHibernateTest.assertTrue((boolean)user.isActive());
        UserDAOHibernateTest.assertEquals((String)"Admin@example.com", (String)user.getEmailAddress());
        UserDAOHibernateTest.assertEquals((String)"Super", (String)user.getFirstName());
        UserDAOHibernateTest.assertEquals((String)"Man", (String)user.getLastName());
        UserDAOHibernateTest.assertEquals((String)"Super Man", (String)user.getDisplayName());
        UserDAOHibernateTest.assertEquals((long)1L, (long)user.getDirectoryId());
        UserDAOHibernateTest.assertEquals((int)2, (int)user.getKeys().size());
        UserDAOHibernateTest.assertTrue((boolean)user.getKeys().contains("color"));
        UserDAOHibernateTest.assertTrue((boolean)user.getKeys().contains("openid"));
        UserDAOHibernateTest.assertEquals((int)2, (int)user.getValues("color").size());
        UserDAOHibernateTest.assertTrue((boolean)user.getValues("color").contains("black"));
        UserDAOHibernateTest.assertTrue((boolean)user.getValues("color").contains("Red"));
        UserDAOHibernateTest.assertEquals((int)1, (int)user.getValues("openid").size());
        UserDAOHibernateTest.assertEquals((String)"http://my.openid.com/admin", (String)user.getValue("openid"));
    }

    public void testAddMixedCaseName() throws Exception {
        User createdUser = this.createNewUser("NewUser");
        UserDAOHibernateTest.assertNotNull((Object)createdUser);
        UserDAOHibernateTest.assertTrue((((InternalUser)createdUser).getId() > 0L ? 1 : 0) != 0);
        InternalUser foundUser = this.userDAO.findByName(1L, "NewUser");
        UserDAOHibernateTest.assertTrue((boolean)foundUser.getName().equals("NewUser"));
        UserDAOHibernateTest.assertEquals((boolean)true, (boolean)foundUser.isActive());
        UserDAOHibernateTest.assertEquals((String)"New", (String)foundUser.getFirstName());
        UserDAOHibernateTest.assertEquals((String)"Guy", (String)foundUser.getLastName());
        UserDAOHibernateTest.assertEquals((String)"New Guy", (String)foundUser.getDisplayName());
        UserDAOHibernateTest.assertEquals((String)"nOOb@example.com", (String)foundUser.getEmailAddress());
        SqlRowSet sqlRowSet = this.jdbcTemplate.queryForRowSet("select lower_user_name, lower_first_name, lower_last_name, lower_display_name, lower_email_address from cwd_user where user_name = 'NewUser'");
        UserDAOHibernateTest.assertTrue((boolean)sqlRowSet.next());
        UserDAOHibernateTest.assertEquals((String)"new", (String)sqlRowSet.getString("lower_first_name"));
        UserDAOHibernateTest.assertEquals((String)"guy", (String)sqlRowSet.getString("lower_last_name"));
        UserDAOHibernateTest.assertEquals((String)"noob@example.com", (String)sqlRowSet.getString("lower_email_address"));
        UserDAOHibernateTest.assertEquals((String)"new guy", (String)sqlRowSet.getString("lower_display_name"));
        UserDAOHibernateTest.assertEquals((String)"newuser", (String)sqlRowSet.getString("lower_user_name"));
    }

    public void testAdd() throws Exception {
        User createdUser = this.createNewUser(NON_EXISTING_USER);
        UserDAOHibernateTest.assertNotNull((Object)createdUser);
        UserDAOHibernateTest.assertTrue((((InternalUser)createdUser).getId() > 0L ? 1 : 0) != 0);
        InternalUser foundUser = this.userDAO.findByName(1L, NON_EXISTING_USER);
        UserDAOHibernateTest.assertTrue((boolean)foundUser.getName().equals(NON_EXISTING_USER));
        UserDAOHibernateTest.assertEquals((boolean)true, (boolean)foundUser.isActive());
        UserDAOHibernateTest.assertEquals((String)"New", (String)foundUser.getFirstName());
        UserDAOHibernateTest.assertEquals((String)"Guy", (String)foundUser.getLastName());
        UserDAOHibernateTest.assertEquals((String)"New Guy", (String)foundUser.getDisplayName());
        UserDAOHibernateTest.assertEquals((String)"nOOb@example.com", (String)foundUser.getEmailAddress());
        SqlRowSet sqlRowSet = this.jdbcTemplate.queryForRowSet("select lower_first_name, lower_last_name, lower_display_name, lower_email_address from cwd_user where user_name = 'newguy'");
        UserDAOHibernateTest.assertTrue((boolean)sqlRowSet.next());
        UserDAOHibernateTest.assertEquals((String)"new", (String)sqlRowSet.getString("lower_first_name"));
        UserDAOHibernateTest.assertEquals((String)"guy", (String)sqlRowSet.getString("lower_last_name"));
        UserDAOHibernateTest.assertEquals((String)"noob@example.com", (String)sqlRowSet.getString("lower_email_address"));
        UserDAOHibernateTest.assertEquals((String)"new guy", (String)sqlRowSet.getString("lower_display_name"));
    }

    public void testAddNull() throws Exception {
        UserTemplate user = new UserTemplate(NON_EXISTING_USER, 1L);
        this.userDAO.add((User)user, PasswordCredential.encrypted((String)"secret"));
        InternalUser foundUser = this.userDAO.findByName(1L, NON_EXISTING_USER);
        UserDAOHibernateTest.assertEquals((String)NON_EXISTING_USER, (String)foundUser.getName());
        UserDAOHibernateTest.assertEquals((boolean)false, (boolean)foundUser.isActive());
        UserDAOHibernateTest.assertNull((Object)foundUser.getFirstName());
        UserDAOHibernateTest.assertNull((Object)foundUser.getLastName());
        UserDAOHibernateTest.assertNull((Object)foundUser.getDisplayName());
        UserDAOHibernateTest.assertNull((Object)foundUser.getEmailAddress());
    }

    public void testAddExistingUserWithDifferentCaseUsername() throws Exception {
        try {
            this.createNewUser("ADMIN");
            this.flush();
            UserDAOHibernateTest.fail((String)"UserAlreadyExistsException expected");
        }
        catch (UserAlreadyExistsException userAlreadyExistsException) {
            // empty catch block
        }
    }

    public void testUpdate() throws Exception {
        InternalUser user = this.userDAO.findByName(1L, EXISTING_USER_1);
        UserTemplate userTemplate = new UserTemplate((User)user);
        userTemplate.setFirstName("Someone");
        userTemplate.setLastName("Different");
        userTemplate.setActive(false);
        userTemplate.setDisplayName("A specific displayName");
        userTemplate.setEmailAddress("Someone@different.com");
        this.userDAO.update((User)userTemplate);
        InternalUser foundUser = this.userDAO.findByName(1L, EXISTING_USER_1);
        UserDAOHibernateTest.assertTrue((boolean)foundUser.getName().equals(EXISTING_USER_1));
        UserDAOHibernateTest.assertEquals((boolean)false, (boolean)foundUser.isActive());
        UserDAOHibernateTest.assertEquals((String)"Someone", (String)foundUser.getFirstName());
        UserDAOHibernateTest.assertEquals((String)"Different", (String)foundUser.getLastName());
        UserDAOHibernateTest.assertEquals((String)"A specific displayName", (String)foundUser.getDisplayName());
        UserDAOHibernateTest.assertEquals((String)"Someone@different.com", (String)foundUser.getEmailAddress());
        SqlRowSet sqlRowSet = this.jdbcTemplate.queryForRowSet("select lower_first_name, lower_last_name, lower_display_name, lower_email_address from cwd_user where user_name = 'admin'");
        UserDAOHibernateTest.assertTrue((boolean)sqlRowSet.next());
        UserDAOHibernateTest.assertEquals((String)"someone", (String)sqlRowSet.getString("lower_first_name"));
        UserDAOHibernateTest.assertEquals((String)"different", (String)sqlRowSet.getString("lower_last_name"));
        UserDAOHibernateTest.assertEquals((String)"someone@different.com", (String)sqlRowSet.getString("lower_email_address"));
        UserDAOHibernateTest.assertEquals((String)"a specific displayname", (String)sqlRowSet.getString("lower_display_name"));
    }

    public void testUpdatePassword() throws Exception {
        InternalUser user = this.userDAO.findByName(1L, EXISTING_USER_1);
        user.updateCredentialTo(new PasswordCredential("password", true), 10);
        this.userDAO.update((User)user);
        UserDAOHibernateTest.assertTrue((user.getCredentialRecords().size() > 0 ? 1 : 0) != 0);
    }

    public void testRename() throws Exception {
        InternalUser user = this.userDAO.findByName(1L, EXISTING_USER_1);
        this.userDAO.rename((User)user, NON_EXISTING_USER);
        try {
            this.userDAO.findByName(1L, EXISTING_USER_1);
        }
        catch (UserNotFoundException e) {
            // empty catch block
        }
        InternalUser renamedUser = this.userDAO.findByName(1L, NON_EXISTING_USER);
        UserDAOHibernateTest.assertEquals((String)NON_EXISTING_USER, (String)renamedUser.getName());
        UserDAOHibernateTest.assertEquals((int)0, (int)this.membershipDAO.search(1L, QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.user()).withName(EXISTING_USER_1).returningAtMost(10)).size());
        UserDAOHibernateTest.assertEquals((int)2, (int)this.membershipDAO.search(1L, QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.user()).withName(NON_EXISTING_USER).returningAtMost(10)).size());
        UserDAOHibernateTest.assertEquals((int)1, (int)this.membershipDAO.search(1L, QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.role()).parentsOf(EntityDescriptor.user()).withName(NON_EXISTING_USER).returningAtMost(10)).size());
    }

    public void testRenameMixedCase() throws Exception {
        InternalUser user = this.userDAO.findByName(2L, "JohnSmith");
        this.userDAO.rename((User)user, "BobSmith");
        try {
            this.userDAO.findByName(2L, "JohnSmith");
        }
        catch (UserNotFoundException e) {
            // empty catch block
        }
        InternalUser renamedUser = this.userDAO.findByName(2L, "BobSmith");
        UserDAOHibernateTest.assertEquals((String)"BobSmith", (String)renamedUser.getName());
        UserDAOHibernateTest.assertEquals((String)"bobsmith", (String)renamedUser.getLowerName());
        UserDAOHibernateTest.assertEquals((int)0, (int)this.membershipDAO.search(2L, QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.user()).withName("johnsmith").returningAtMost(10)).size());
        UserDAOHibernateTest.assertEquals((int)1, (int)this.membershipDAO.search(2L, QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.user()).withName("bobsmith").returningAtMost(10)).size());
        UserDAOHibernateTest.assertEquals((int)0, (int)this.membershipDAO.search(2L, QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.user()).withName("JohnSmith").returningAtMost(10)).size());
        UserDAOHibernateTest.assertEquals((int)1, (int)this.membershipDAO.search(2L, QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.user()).withName("BobSmith").returningAtMost(10)).size());
    }

    public void testRemove() throws Exception {
        InternalUser user = this.userDAO.findByName(1L, EXISTING_USER_1);
        long userId = user.getDirectoryId();
        this.userDAO.remove((User)user);
        try {
            this.userDAO.findByName(1L, EXISTING_USER_1);
        }
        catch (UserNotFoundException e) {
            // empty catch block
        }
        UserDAOHibernateTest.assertEquals((int)0, (int)this.jdbcTemplate.queryForInt("select count(*) from cwd_user_credential_record where user_id = " + userId));
        UserDAOHibernateTest.assertEquals((int)0, (int)this.membershipDAO.search(1L, QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.user()).withName(EXISTING_USER_1).returningAtMost(10)).size());
    }

    public void testRemoveMixedCaseInsensitive() throws Exception {
        InternalUser user = this.userDAO.findByName(2L, "johnSmith");
        long userId = user.getDirectoryId();
        this.userDAO.remove((User)user);
        try {
            this.userDAO.findByName(1L, "johnSmith");
        }
        catch (UserNotFoundException e) {
            // empty catch block
        }
        UserDAOHibernateTest.assertEquals((int)0, (int)this.jdbcTemplate.queryForInt("select count(*) from cwd_user_credential_record where user_id = " + userId));
        UserDAOHibernateTest.assertEquals((int)0, (int)this.membershipDAO.search(1L, QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.user()).withName("JohnSmith").returningAtMost(10)).size());
    }

    public void testRemoveAll() {
        this.userDAO.removeAll(1L);
        UserDAOHibernateTest.assertTrue((boolean)this.userDAO.search(1L, QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).returningAtMost(10)).isEmpty());
        UserDAOHibernateTest.assertEquals((int)0, (int)this.jdbcTemplate.queryForInt("select count(*) from cwd_membership where membership_type = 'GROUP_USER' and directory_id = 1"));
        UserDAOHibernateTest.assertEquals((int)0, (int)this.jdbcTemplate.queryForInt("select count(*) from cwd_user_credential_record"));
    }

    public void testStoreAttributesWithInsertForNewUser() throws Exception {
        User createdUser = this.createNewUser(NON_EXISTING_USER_MIXED_CASE);
        HashMap<String, HashSet> attributes = new HashMap<String, HashSet>();
        attributes.put("color", Sets.newHashSet((Object[])new String[]{"Blue", "Green"}));
        attributes.put("phone", Sets.newHashSet((Object[])new String[]{"131111"}));
        this.userDAO.storeAttributes(createdUser, attributes);
        InternalUserWithAttributes returnedUser = this.userDAO.findByNameWithAttributes(1L, NON_EXISTING_USER_MIXED_CASE);
        UserDAOHibernateTest.assertEquals((String)NON_EXISTING_USER_MIXED_CASE, (String)returnedUser.getInternalUser().getName());
        UserDAOHibernateTest.assertEquals((String)NON_EXISTING_USER, (String)returnedUser.getInternalUser().getLowerName());
        UserDAOHibernateTest.assertEquals((int)2, (int)returnedUser.getKeys().size());
        UserDAOHibernateTest.assertEquals((int)2, (int)returnedUser.getValues("color").size());
        UserDAOHibernateTest.assertTrue((boolean)returnedUser.getValues("color").contains("Blue"));
        UserDAOHibernateTest.assertTrue((boolean)returnedUser.getValues("color").contains("Green"));
        UserDAOHibernateTest.assertEquals((int)1, (int)returnedUser.getValues("phone").size());
        UserDAOHibernateTest.assertTrue((boolean)returnedUser.getValues("phone").contains("131111"));
        SqlRowSet sqlRowSet = this.jdbcTemplate.queryForRowSet("select attribute_lower_value from cwd_user_attribute where user_id = " + returnedUser.getInternalUser().getId());
        HashSet<String> lowerCaseAttributeValues = new HashSet<String>();
        while (sqlRowSet.next()) {
            lowerCaseAttributeValues.add(sqlRowSet.getString("attribute_lower_value"));
        }
        UserDAOHibernateTest.assertEquals((int)3, (int)lowerCaseAttributeValues.size());
        UserDAOHibernateTest.assertTrue((boolean)lowerCaseAttributeValues.contains(IdentifierUtils.toLowerCase((String)"Blue")));
        UserDAOHibernateTest.assertTrue((boolean)lowerCaseAttributeValues.contains(IdentifierUtils.toLowerCase((String)"Green")));
        UserDAOHibernateTest.assertTrue((boolean)lowerCaseAttributeValues.contains(IdentifierUtils.toLowerCase((String)"131111")));
    }

    private User createNewUser(String username) throws Exception {
        UserTemplate user = new UserTemplate(username, 1L);
        user.setActive(true);
        user.setFirstName("New");
        user.setLastName("Guy");
        user.setDisplayName("New Guy");
        user.setEmailAddress("nOOb@example.com");
        return this.userDAO.add((User)user, PasswordCredential.encrypted((String)"secret"));
    }

    public void testStoreAttributesWithUpdateAndInsertForExistingUser() throws Exception {
        InternalUserWithAttributes user = this.userDAO.findByNameWithAttributes(1L, EXISTING_USER_1);
        UserDAOHibernateTest.assertEquals((int)2, (int)user.getKeys().size());
        UserDAOHibernateTest.assertEquals((int)2, (int)user.getValues("color").size());
        UserDAOHibernateTest.assertTrue((boolean)user.getValues("color").contains("black"));
        UserDAOHibernateTest.assertTrue((boolean)user.getValues("color").contains("Red"));
        UserDAOHibernateTest.assertEquals((int)1, (int)user.getValues("openid").size());
        UserDAOHibernateTest.assertEquals((String)"http://my.openid.com/admin", (String)user.getValue("openid"));
        HashMap<String, HashSet> attributes = new HashMap<String, HashSet>();
        attributes.put("color", Sets.newHashSet((Object[])new String[]{"blue", "green", "Red"}));
        attributes.put("phone", Sets.newHashSet((Object[])new String[]{"131111"}));
        this.userDAO.storeAttributes((User)user, attributes);
        InternalUserWithAttributes returnedUser = this.userDAO.findByNameWithAttributes(1L, EXISTING_USER_1);
        UserDAOHibernateTest.assertEquals((int)3, (int)returnedUser.getKeys().size());
        UserDAOHibernateTest.assertEquals((int)3, (int)returnedUser.getValues("color").size());
        UserDAOHibernateTest.assertTrue((boolean)returnedUser.getValues("color").contains("blue"));
        UserDAOHibernateTest.assertTrue((boolean)returnedUser.getValues("color").contains("green"));
        UserDAOHibernateTest.assertTrue((boolean)returnedUser.getValues("color").contains("Red"));
        UserDAOHibernateTest.assertEquals((int)1, (int)returnedUser.getValues("phone").size());
        UserDAOHibernateTest.assertTrue((boolean)returnedUser.getValues("phone").contains("131111"));
        UserDAOHibernateTest.assertEquals((int)1, (int)returnedUser.getValues("openid").size());
        UserDAOHibernateTest.assertEquals((String)"http://my.openid.com/admin", (String)returnedUser.getValue("openid"));
    }

    public void testStoreAttributesForExistingMixedCaseUser() throws Exception {
        InternalUserWithAttributes user = this.userDAO.findByNameWithAttributes(2L, "JohnSmith");
        UserDAOHibernateTest.assertEquals((int)1, (int)user.getKeys().size());
        UserDAOHibernateTest.assertEquals((int)1, (int)user.getValues("color").size());
        UserDAOHibernateTest.assertTrue((boolean)user.getValues("color").contains("violet"));
        HashMap<String, HashSet> attributes = new HashMap<String, HashSet>();
        attributes.put("color", Sets.newHashSet((Object[])new String[]{"blue", "green", "Red"}));
        attributes.put("phone", Sets.newHashSet((Object[])new String[]{"131111"}));
        this.userDAO.storeAttributes((User)user, attributes);
        InternalUserWithAttributes returnedUser = this.userDAO.findByNameWithAttributes(2L, "JohnSmith");
        UserDAOHibernateTest.assertEquals((int)2, (int)returnedUser.getKeys().size());
        UserDAOHibernateTest.assertEquals((int)3, (int)returnedUser.getValues("color").size());
        UserDAOHibernateTest.assertTrue((boolean)returnedUser.getValues("color").contains("blue"));
        UserDAOHibernateTest.assertTrue((boolean)returnedUser.getValues("color").contains("green"));
        UserDAOHibernateTest.assertTrue((boolean)returnedUser.getValues("color").contains("Red"));
        UserDAOHibernateTest.assertEquals((int)1, (int)returnedUser.getValues("phone").size());
        UserDAOHibernateTest.assertTrue((boolean)returnedUser.getValues("phone").contains("131111"));
    }

    public void testStoreAttributesWithUpdateAndDeleteForExistingUser() throws Exception {
        InternalUserWithAttributes user = this.userDAO.findByNameWithAttributes(1L, EXISTING_USER_1);
        UserDAOHibernateTest.assertEquals((int)2, (int)user.getKeys().size());
        UserDAOHibernateTest.assertEquals((int)2, (int)user.getValues("color").size());
        UserDAOHibernateTest.assertTrue((boolean)user.getValues("color").contains("black"));
        UserDAOHibernateTest.assertTrue((boolean)user.getValues("color").contains("Red"));
        UserDAOHibernateTest.assertEquals((int)1, (int)user.getValues("openid").size());
        UserDAOHibernateTest.assertEquals((String)"http://my.openid.com/admin", (String)user.getValue("openid"));
        HashMap<String, HashSet> attributes = new HashMap<String, HashSet>();
        attributes.put("color", Sets.newHashSet((Object[])new String[]{"Red"}));
        attributes.put("phone", Sets.newHashSet((Object[])new String[]{"131111"}));
        this.userDAO.storeAttributes((User)user, attributes);
        InternalUserWithAttributes returnedUser = this.userDAO.findByNameWithAttributes(1L, EXISTING_USER_1);
        UserDAOHibernateTest.assertEquals((int)3, (int)returnedUser.getKeys().size());
        UserDAOHibernateTest.assertEquals((int)1, (int)returnedUser.getValues("color").size());
        UserDAOHibernateTest.assertTrue((boolean)returnedUser.getValues("color").contains("Red"));
        UserDAOHibernateTest.assertEquals((int)1, (int)returnedUser.getValues("phone").size());
        UserDAOHibernateTest.assertTrue((boolean)returnedUser.getValues("phone").contains("131111"));
        UserDAOHibernateTest.assertEquals((int)1, (int)returnedUser.getValues("openid").size());
        UserDAOHibernateTest.assertEquals((String)"http://my.openid.com/admin", (String)returnedUser.getValue("openid"));
    }

    public void testStoreSingleAttributeWithUpdateForExistingUser() throws Exception {
        InternalUserWithAttributes user = this.userDAO.findByNameWithAttributes(1L, EXISTING_USER_1);
        UserDAOHibernateTest.assertEquals((int)2, (int)user.getKeys().size());
        UserDAOHibernateTest.assertEquals((int)2, (int)user.getValues("color").size());
        UserDAOHibernateTest.assertTrue((boolean)user.getValues("color").contains("black"));
        UserDAOHibernateTest.assertTrue((boolean)user.getValues("color").contains("Red"));
        UserDAOHibernateTest.assertEquals((int)1, (int)user.getValues("openid").size());
        UserDAOHibernateTest.assertEquals((String)"http://my.openid.com/admin", (String)user.getValue("openid"));
        HashMap<String, HashSet> attributes = new HashMap<String, HashSet>();
        attributes.put("openid", Sets.newHashSet((Object[])new String[]{"newval"}));
        this.userDAO.storeAttributes((User)user, attributes);
        InternalUserWithAttributes returnedUser = this.userDAO.findByNameWithAttributes(1L, EXISTING_USER_1);
        UserDAOHibernateTest.assertEquals((int)2, (int)returnedUser.getKeys().size());
        UserDAOHibernateTest.assertEquals((int)2, (int)returnedUser.getValues("color").size());
        UserDAOHibernateTest.assertTrue((boolean)returnedUser.getValues("color").contains("black"));
        UserDAOHibernateTest.assertTrue((boolean)returnedUser.getValues("color").contains("Red"));
        UserDAOHibernateTest.assertEquals((int)1, (int)returnedUser.getValues("openid").size());
        UserDAOHibernateTest.assertEquals((String)"newval", (String)returnedUser.getValue("openid"));
    }

    public void testStoreAttributesWithUpdateForExistingUser() throws Exception {
        InternalUserWithAttributes user = this.userDAO.findByNameWithAttributes(1L, EXISTING_USER_1);
        UserDAOHibernateTest.assertEquals((int)2, (int)user.getKeys().size());
        UserDAOHibernateTest.assertEquals((int)2, (int)user.getValues("color").size());
        UserDAOHibernateTest.assertTrue((boolean)user.getValues("color").contains("black"));
        UserDAOHibernateTest.assertTrue((boolean)user.getValues("color").contains("Red"));
        UserDAOHibernateTest.assertEquals((int)1, (int)user.getValues("openid").size());
        UserDAOHibernateTest.assertEquals((String)"http://my.openid.com/admin", (String)user.getValue("openid"));
        HashMap<String, HashSet> attributes = new HashMap<String, HashSet>();
        attributes.put("color", Sets.newHashSet((Object[])new String[]{"orange", "Pink"}));
        attributes.put("openid", Sets.newHashSet((Object[])new String[]{"new"}));
        this.userDAO.storeAttributes((User)user, attributes);
        InternalUserWithAttributes returnedUser = this.userDAO.findByNameWithAttributes(1L, EXISTING_USER_1);
        UserDAOHibernateTest.assertEquals((int)2, (int)returnedUser.getKeys().size());
        UserDAOHibernateTest.assertEquals((int)2, (int)returnedUser.getValues("color").size());
        UserDAOHibernateTest.assertTrue((boolean)returnedUser.getValues("color").contains("orange"));
        UserDAOHibernateTest.assertTrue((boolean)returnedUser.getValues("color").contains("Pink"));
        UserDAOHibernateTest.assertEquals((int)1, (int)returnedUser.getValues("openid").size());
        UserDAOHibernateTest.assertEquals((String)"new", (String)returnedUser.getValue("openid"));
    }

    public void testRemoveAttribute() throws Exception {
        InternalUserWithAttributes user = this.userDAO.findByNameWithAttributes(1L, EXISTING_USER_1);
        UserDAOHibernateTest.assertEquals((int)2, (int)user.getKeys().size());
        this.userDAO.removeAttribute((User)user, "color");
        InternalUserWithAttributes updatedUser = this.userDAO.findByNameWithAttributes(1L, EXISTING_USER_1);
        UserDAOHibernateTest.assertEquals((int)1, (int)updatedUser.getKeys().size());
        UserDAOHibernateTest.assertEquals((int)1, (int)updatedUser.getValues("openid").size());
        UserDAOHibernateTest.assertEquals((String)"http://my.openid.com/admin", (String)updatedUser.getValue("openid"));
    }

    public void testRemoveAttributeMixedCaseUser() throws Exception {
        InternalUserWithAttributes user = this.userDAO.findByNameWithAttributes(2L, "joHnSmith");
        UserDAOHibernateTest.assertEquals((int)1, (int)user.getKeys().size());
        this.userDAO.removeAttribute((User)user, "color");
        InternalUserWithAttributes updatedUser = this.userDAO.findByNameWithAttributes(2L, "joHnSmith");
        UserDAOHibernateTest.assertEquals((int)0, (int)updatedUser.getKeys().size());
    }

    private void assertContainsExactly(List<User> users, String ... usernames) {
        UserDAOHibernateTest.assertEquals((int)usernames.length, (int)users.size());
        int index = 0;
        for (User user : users) {
            UserDAOHibernateTest.assertEquals((String)usernames[index], (String)user.getName());
            ++index;
        }
    }

    private void assertContains(List<User> users, String username) {
        UserDAOHibernateTest.assertTrue((String)("User " + username + " not found in " + users), (boolean)this.contains(users, username));
    }

    private boolean contains(List<User> users, String username) {
        for (User user : users) {
            if (!user.getName().equals(username)) continue;
            return true;
        }
        return false;
    }

    public void testSearchAllUserNames() {
        EntityQuery query = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).returningAtMost(10);
        List users = this.userDAO.search(1L, query);
        UserDAOHibernateTest.assertEquals(Arrays.asList(EXISTING_USER_1, EXISTING_USER_2, EXISTING_USER_3), (Object)users);
    }

    public void testSearchUsernameStartsWith() throws Exception {
        TermRestriction userNameRestriction = new TermRestriction(UserTermKeys.USERNAME, MatchMode.STARTS_WITH, (Object)"a");
        UserQuery query = new UserQuery(User.class, (SearchRestriction)userNameRestriction, 0, 100);
        List users = this.userDAO.search(1L, (EntityQuery)query);
        this.assertContainsExactly(users, EXISTING_USER_1);
    }

    public void testSearchEmailContains() throws Exception {
        TermRestriction userNameRestriction = new TermRestriction(UserTermKeys.EMAIL, MatchMode.CONTAINS, (Object)"@eXample");
        UserQuery query = new UserQuery(User.class, (SearchRestriction)userNameRestriction, 0, 100);
        List users = this.userDAO.search(1L, (EntityQuery)query);
        this.assertContainsExactly(users, EXISTING_USER_1, EXISTING_USER_2);
    }

    public void testSearchFirstNameExact() throws Exception {
        TermRestriction userNameRestriction = new TermRestriction(UserTermKeys.FIRST_NAME, MatchMode.EXACTLY_MATCHES, (Object)"BOB");
        UserQuery query = new UserQuery(User.class, (SearchRestriction)userNameRestriction, 0, 100);
        List users = this.userDAO.search(1L, (EntityQuery)query);
        this.assertContainsExactly(users, EXISTING_USER_2);
    }

    public void testSearchLastNameStartsWith() throws Exception {
        TermRestriction userNameRestriction = new TermRestriction(UserTermKeys.LAST_NAME, MatchMode.STARTS_WITH, (Object)"s");
        UserQuery query = new UserQuery(User.class, (SearchRestriction)userNameRestriction, 0, 100);
        List users = this.userDAO.search(1L, (EntityQuery)query);
        this.assertContainsExactly(users, EXISTING_USER_2);
    }

    public void testSearchLastNameStartsWithUsingBuilder() throws Exception {
        PropertyRestriction userNameRestriction = Restriction.on((Property)UserTermKeys.LAST_NAME).startingWith((Object)"s");
        UserQuery query = new UserQuery(User.class, (SearchRestriction)userNameRestriction, 0, 100);
        List users = this.userDAO.search(1L, (EntityQuery)query);
        this.assertContainsExactly(users, EXISTING_USER_2);
    }

    public void testSearchForActiveUsersUsingBuilder() throws Exception {
        PropertyRestriction propertyRestriction = Restriction.on((Property)UserTermKeys.ACTIVE).exactlyMatching((Object)true);
        UserQuery query = new UserQuery(User.class, (SearchRestriction)propertyRestriction, 0, 100);
        List users = this.userDAO.search(1L, (EntityQuery)query);
        this.assertContainsExactly(users, EXISTING_USER_1, EXISTING_USER_2);
    }

    public void testSearchForInactiveUsersUsingBuilder() throws Exception {
        PropertyRestriction propertyRestriction = Restriction.on((Property)UserTermKeys.ACTIVE).exactlyMatching((Object)false);
        UserQuery query = new UserQuery(User.class, (SearchRestriction)propertyRestriction, 0, 100);
        List users = this.userDAO.search(1L, (EntityQuery)query);
        this.assertContainsExactly(users, EXISTING_USER_3);
    }

    public void testSearchDisplayNameContains() throws Exception {
        TermRestriction userNameRestriction = new TermRestriction(UserTermKeys.DISPLAY_NAME, MatchMode.CONTAINS, (Object)"mI");
        UserQuery query = new UserQuery(User.class, (SearchRestriction)userNameRestriction, 0, 100);
        List users = this.userDAO.search(1L, (EntityQuery)query);
        this.assertContainsExactly(users, EXISTING_USER_2);
    }

    public void testSearchColorExact() throws Exception {
        TermRestriction userNameRestriction = new TermRestriction(PropertyUtils.ofTypeString((String)"color"), MatchMode.EXACTLY_MATCHES, (Object)"black");
        UserQuery query = new UserQuery(User.class, (SearchRestriction)userNameRestriction, 0, 100);
        List users = this.userDAO.search(1L, (EntityQuery)query);
        this.assertContainsExactly(users, EXISTING_USER_1);
    }

    public void testSearchColorNoResults() throws Exception {
        TermRestriction userNameRestriction = new TermRestriction(PropertyUtils.ofTypeString((String)"color"), MatchMode.EXACTLY_MATCHES, (Object)"crimson");
        UserQuery query = new UserQuery(User.class, (SearchRestriction)userNameRestriction, 0, 100);
        List users = this.userDAO.search(1L, (EntityQuery)query);
        UserDAOHibernateTest.assertEquals((int)0, (int)users.size());
    }

    public void testSearchNullCustomAttribute() {
        TermRestriction userAttributeRestriction = new TermRestriction(PropertyUtils.ofTypeString((String)"openid"), MatchMode.NULL, null);
        UserQuery query = new UserQuery(User.class, (SearchRestriction)userAttributeRestriction, 0, 100);
        List users = this.userDAO.search(1L, (EntityQuery)query);
        UserDAOHibernateTest.assertEquals((int)2, (int)users.size());
    }

    public void testSearchPrimaryAttributeAndNullCustomAttribute() {
        TermRestriction userEmailRestriction = new TermRestriction(UserTermKeys.USERNAME, MatchMode.CONTAINS, (Object)"a");
        TermRestriction userAttributeRestriction = new TermRestriction(PropertyUtils.ofTypeString((String)"openid"), MatchMode.NULL, null);
        UserQuery query = new UserQuery(User.class, (SearchRestriction)Combine.allOf((SearchRestriction[])new SearchRestriction[]{userEmailRestriction, userAttributeRestriction}), 0, 100);
        List users = this.userDAO.search(1L, (EntityQuery)query);
        UserDAOHibernateTest.assertEquals((int)1, (int)users.size());
    }

    public void testSearchMultipleNullValues() {
        TermRestriction r1 = new TermRestriction(PropertyUtils.ofTypeString((String)"openid"), MatchMode.NULL, null);
        TermRestriction r2 = new TermRestriction(PropertyUtils.ofTypeString((String)"something"), MatchMode.NULL, null);
        UserQuery query = new UserQuery(User.class, (SearchRestriction)Combine.anyOf((SearchRestriction[])new SearchRestriction[]{r1, r2}), 0, 100);
        List users = this.userDAO.search(1L, (EntityQuery)query);
        UserDAOHibernateTest.assertEquals((int)3, (int)users.size());
    }

    public void testSearchFirstClassDisjunction() throws Exception {
        TermRestriction userNameRestriction1 = new TermRestriction(UserTermKeys.LAST_NAME, MatchMode.STARTS_WITH, (Object)"s");
        TermRestriction userNameRestriction2 = new TermRestriction(UserTermKeys.LAST_NAME, MatchMode.STARTS_WITH, (Object)"m");
        BooleanRestrictionImpl userNameDisjunction = new BooleanRestrictionImpl(BooleanRestriction.BooleanLogic.OR, new SearchRestriction[]{userNameRestriction1, userNameRestriction2});
        UserQuery query = new UserQuery(User.class, (SearchRestriction)userNameDisjunction, 0, 100);
        List users = this.userDAO.search(1L, (EntityQuery)query);
        this.assertContainsExactly(users, EXISTING_USER_1, EXISTING_USER_2);
    }

    public void testSearchFirstClassConjunction() throws Exception {
        TermRestriction userNameRestriction1 = new TermRestriction(UserTermKeys.DISPLAY_NAME, MatchMode.STARTS_WITH, (Object)"b");
        TermRestriction userNameRestriction2 = new TermRestriction(UserTermKeys.EMAIL, MatchMode.CONTAINS, (Object)"@examplE");
        BooleanRestrictionImpl userNameDisjunction = new BooleanRestrictionImpl(BooleanRestriction.BooleanLogic.AND, new SearchRestriction[]{userNameRestriction1, userNameRestriction2});
        UserQuery query = new UserQuery(User.class, (SearchRestriction)userNameDisjunction, 0, 100);
        List users = this.userDAO.search(1L, (EntityQuery)query);
        this.assertContainsExactly(users, EXISTING_USER_2);
    }

    public void testSearchSecondClassDisjuction() throws Exception {
        TermRestriction colorRestriction1 = new TermRestriction(PropertyUtils.ofTypeString((String)"color"), MatchMode.EXACTLY_MATCHES, (Object)"Red");
        TermRestriction colorRestriction2 = new TermRestriction(PropertyUtils.ofTypeString((String)"color"), MatchMode.EXACTLY_MATCHES, (Object)"yellow");
        BooleanRestrictionImpl userNameDisjunction = new BooleanRestrictionImpl(BooleanRestriction.BooleanLogic.OR, new SearchRestriction[]{colorRestriction1, colorRestriction2});
        UserQuery query = new UserQuery(User.class, (SearchRestriction)userNameDisjunction, 0, 100);
        List users = this.userDAO.search(1L, (EntityQuery)query);
        this.assertContainsExactly(users, EXISTING_USER_1, EXISTING_USER_2);
    }

    public void testSearchSecondClassConjunction() throws Exception {
        TermRestriction colorRestriction1 = new TermRestriction(PropertyUtils.ofTypeString((String)"color"), MatchMode.EXACTLY_MATCHES, (Object)"Red");
        TermRestriction colorRestriction2 = new TermRestriction(PropertyUtils.ofTypeString((String)"color"), MatchMode.EXACTLY_MATCHES, (Object)"black");
        BooleanRestrictionImpl userNameDisjunction = new BooleanRestrictionImpl(BooleanRestriction.BooleanLogic.AND, new SearchRestriction[]{colorRestriction1, colorRestriction2});
        UserQuery query = new UserQuery(User.class, (SearchRestriction)userNameDisjunction, 0, 100);
        List users = this.userDAO.search(1L, (EntityQuery)query);
        this.assertContainsExactly(users, EXISTING_USER_1);
    }

    public void testSearchMixedClassDisjunction() throws Exception {
        TermRestriction colorRestriction = new TermRestriction(PropertyUtils.ofTypeString((String)"color"), MatchMode.EXACTLY_MATCHES, (Object)"black");
        TermRestriction displayNameRestriction = new TermRestriction(UserTermKeys.DISPLAY_NAME, MatchMode.STARTS_WITH, (Object)"b");
        BooleanRestrictionImpl userNameDisjunction = new BooleanRestrictionImpl(BooleanRestriction.BooleanLogic.OR, new SearchRestriction[]{colorRestriction, displayNameRestriction});
        UserQuery query = new UserQuery(User.class, (SearchRestriction)userNameDisjunction, 0, 100);
        List users = this.userDAO.search(1L, (EntityQuery)query);
        this.assertContainsExactly(users, EXISTING_USER_1, EXISTING_USER_2);
    }

    public void testSearchMixedClassConjunction() throws Exception {
        TermRestriction colorRestriction = new TermRestriction(PropertyUtils.ofTypeString((String)"color"), MatchMode.EXACTLY_MATCHES, (Object)"Red");
        TermRestriction displayNameRestriction = new TermRestriction(UserTermKeys.DISPLAY_NAME, MatchMode.STARTS_WITH, (Object)"b");
        BooleanRestrictionImpl userNameConjunction = new BooleanRestrictionImpl(BooleanRestriction.BooleanLogic.AND, new SearchRestriction[]{colorRestriction, displayNameRestriction});
        UserQuery query = new UserQuery(User.class, (SearchRestriction)userNameConjunction, 0, 100);
        List users = this.userDAO.search(1L, (EntityQuery)query);
        this.assertContainsExactly(users, EXISTING_USER_2);
    }

    public void testSearchNested() {
        TermRestriction colorRestriction = new TermRestriction(PropertyUtils.ofTypeString((String)"color"), MatchMode.EXACTLY_MATCHES, (Object)"Red");
        TermRestriction displayNameRestriction = new TermRestriction(UserTermKeys.DISPLAY_NAME, MatchMode.STARTS_WITH, (Object)"b");
        BooleanRestrictionImpl conjunction1 = new BooleanRestrictionImpl(BooleanRestriction.BooleanLogic.AND, new SearchRestriction[]{colorRestriction, displayNameRestriction});
        TermRestriction colorRestriction2 = new TermRestriction(PropertyUtils.ofTypeString((String)"color"), MatchMode.EXACTLY_MATCHES, (Object)"violet");
        TermRestriction displayNameRestriction2 = new TermRestriction(UserTermKeys.DISPLAY_NAME, MatchMode.STARTS_WITH, (Object)"j");
        BooleanRestrictionImpl conjunction2 = new BooleanRestrictionImpl(BooleanRestriction.BooleanLogic.AND, new SearchRestriction[]{colorRestriction2, displayNameRestriction2});
        BooleanRestrictionImpl nestedRestriction = new BooleanRestrictionImpl(BooleanRestriction.BooleanLogic.OR, new SearchRestriction[]{conjunction1, conjunction2});
        UserQuery query = new UserQuery(User.class, (SearchRestriction)nestedRestriction, 0, 100);
        List users = this.userDAO.search(1L, (EntityQuery)query);
        this.assertContainsExactly(users, EXISTING_USER_2, EXISTING_USER_3);
    }

    public void testSearchNestedCustomNullAttributes() {
        TermRestriction openidRestriction = new TermRestriction(PropertyUtils.ofTypeString((String)"openid"), MatchMode.NULL, null);
        TermRestriction displayNameRestriction = new TermRestriction(UserTermKeys.DISPLAY_NAME, MatchMode.STARTS_WITH, (Object)"Jane");
        BooleanRestrictionImpl conjunction1 = new BooleanRestrictionImpl(BooleanRestriction.BooleanLogic.AND, new SearchRestriction[]{openidRestriction, displayNameRestriction});
        TermRestriction openidRestriction2 = new TermRestriction(PropertyUtils.ofTypeString((String)"openid"), MatchMode.NULL, null);
        TermRestriction displayNameRestriction2 = new TermRestriction(UserTermKeys.DISPLAY_NAME, MatchMode.STARTS_WITH, (Object)"Bob");
        BooleanRestrictionImpl conjunction2 = new BooleanRestrictionImpl(BooleanRestriction.BooleanLogic.AND, new SearchRestriction[]{openidRestriction2, displayNameRestriction2});
        BooleanRestrictionImpl nestedRestriction = new BooleanRestrictionImpl(BooleanRestriction.BooleanLogic.OR, new SearchRestriction[]{conjunction1, conjunction2, new TermRestriction(PropertyUtils.ofTypeString((String)"openid"), MatchMode.CONTAINS, (Object)"/")});
        UserQuery query = new UserQuery(User.class, (SearchRestriction)nestedRestriction, 0, 100);
        List users = this.userDAO.search(1L, (EntityQuery)query);
        this.assertContainsExactly(users, EXISTING_USER_1, EXISTING_USER_2, EXISTING_USER_3);
    }

    public void testSearchMixedCaseUsername() {
        List users = this.userDAO.search(2L, QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Restriction.on((Property)UserTermKeys.USERNAME).containing((Object)"john")).returningAtMost(10));
        this.assertContainsExactly(users, "JohnSmith");
        users = this.userDAO.search(2L, QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Restriction.on((Property)UserTermKeys.USERNAME).exactlyMatching((Object)"jOhNsMiTh")).returningAtMost(10));
        this.assertContainsExactly(users, "JohnSmith");
    }

    public void testSearchMixedCaseUsernameAttributeMatch() {
        List users = this.userDAO.search(2L, QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Restriction.on((Property)PropertyUtils.ofTypeString((String)"color")).containing((Object)"violet")).returningAtMost(10));
        this.assertContainsExactly(users, EXISTING_USER_3, "JohnSmith");
    }

    public void testAddAll() {
        HashSet<UserTemplateWithCredentialAndAttributes> users = new HashSet<UserTemplateWithCredentialAndAttributes>();
        for (int i = 0; i < 50; ++i) {
            UserTemplateWithCredentialAndAttributes user = new UserTemplateWithCredentialAndAttributes("User" + i, 1L, new PasswordCredential("secret", true));
            user.setEmailAddress("blah@example.com");
            user.setFirstName("Clone");
            user.setLastName("Drone");
            user.setDisplayName("Clone Drone");
            user.setAttribute("flavour", "chocolate");
            user.setAttribute("drink", "coke");
            users.add(user);
        }
        BatchResult result = this.userDAO.addAll(users);
        UserDAOHibernateTest.assertEquals((int)50, (int)result.getTotalSuccessful());
        UserDAOHibernateTest.assertEquals((int)50, (int)result.getTotalAttempted());
        UserDAOHibernateTest.assertTrue((boolean)result.getFailedEntities().isEmpty());
        UserDAOHibernateTest.assertEquals((int)50, (int)this.userDAO.search(1L, QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Restriction.on((Property)UserTermKeys.USERNAME).startingWith((Object)"user")).returningAtMost(100)).size());
        UserDAOHibernateTest.assertEquals((int)50, (int)this.userDAO.search(1L, QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Restriction.on((Property)PropertyUtils.ofTypeString((String)"flavour")).exactlyMatching((Object)"chocolate")).returningAtMost(100)).size());
        UserDAOHibernateTest.assertEquals((int)50, (int)this.userDAO.search(1L, QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Restriction.on((Property)PropertyUtils.ofTypeString((String)"drink")).exactlyMatching((Object)"coke")).returningAtMost(100)).size());
    }

    public void testAddAllWithErrorsAndDuplicates() throws Exception {
        int userCount = this.userDAO.search(1L, QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).returningAtMost(100)).size();
        HashSet<UserTemplateWithCredentialAndAttributes> users = new HashSet<UserTemplateWithCredentialAndAttributes>();
        UserTemplateWithCredentialAndAttributes user = new UserTemplateWithCredentialAndAttributes("user", 1L, new PasswordCredential("secret", true));
        user.setEmailAddress("common@example.com");
        user.setFirstName("Clone");
        user.setLastName("Drone");
        user.setDisplayName("Clone Drone");
        user.setAttribute("flavour", "chocolate");
        user.setAttribute("drink", "coke");
        users.add(user);
        UserTemplateWithCredentialAndAttributes existingUser = new UserTemplateWithCredentialAndAttributes((User)this.userDAO.findByName(1L, EXISTING_USER_1), new PasswordCredential("secret", true));
        existingUser.setEmailAddress("common@example.com");
        users.add(existingUser);
        UserTemplateWithCredentialAndAttributes incompleteUser = new UserTemplateWithCredentialAndAttributes("user2", 1L, new PasswordCredential("secret", true));
        users.add(incompleteUser);
        UserTemplateWithCredentialAndAttributes differentDirectoryUser = new UserTemplateWithCredentialAndAttributes("user3", 2L, new PasswordCredential("secret", true));
        differentDirectoryUser.setEmailAddress("common@example.com");
        differentDirectoryUser.setFirstName("Clone");
        differentDirectoryUser.setLastName("Drone");
        differentDirectoryUser.setDisplayName("Clone Drone");
        differentDirectoryUser.setAttribute("flavour", "chocolate");
        differentDirectoryUser.setAttribute("drink", "coke");
        users.add(differentDirectoryUser);
        BatchResult result = this.userDAO.addAll(users);
        UserDAOHibernateTest.assertEquals((int)3, (int)result.getTotalSuccessful());
        UserDAOHibernateTest.assertEquals((int)users.size(), (int)result.getTotalAttempted());
        this.assertContainsExactly(result.getFailedEntities(), EXISTING_USER_1);
        UserDAOHibernateTest.assertEquals((int)(userCount + 2), (int)this.userDAO.search(1L, QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).returningAtMost(100)).size());
        UserDAOHibernateTest.assertEquals((int)1, (int)this.userDAO.search(1L, QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Restriction.on((Property)PropertyUtils.ofTypeString((String)"flavour")).exactlyMatching((Object)"chocolate")).returningAtMost(100)).size());
        UserDAOHibernateTest.assertEquals((int)1, (int)this.userDAO.search(1L, QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Restriction.on((Property)PropertyUtils.ofTypeString((String)"drink")).exactlyMatching((Object)"coke")).returningAtMost(100)).size());
    }

    public void testFindByNames() {
        ArrayList<User> users = new ArrayList<User>(this.userDAO.findByNames(1L, Arrays.asList(EXISTING_USER_1, "bogus", EXISTING_USER_3)));
        this.assertContainsExactly(users, EXISTING_USER_1, EXISTING_USER_3);
    }

    @Override
    public String getSampleDataFileName() {
        return "sample-data.xml";
    }

    public void setUserDAO(UserDAOHibernate userDAO) {
        this.userDAO = userDAO;
    }

    public void setMembershipDAO(MembershipDAOHibernate membershipDAO) {
        this.membershipDAO = membershipDAO;
    }
}

