/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.persistence.dao.token;

import com.atlassian.crowd.acceptance.tests.persistence.dao.token.TokenDAOTester;
import com.atlassian.crowd.dao.token.TokenDAO;
import com.atlassian.crowd.dao.token.TokenDAOMemory;
import com.atlassian.crowd.manager.cache.CacheManagerEhcache;
import com.atlassian.crowd.model.token.Token;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.sf.ehcache.CacheManager;

public class TokenDAOMemoryTest
extends TokenDAOTester {
    private TokenDAOMemory tokenDAO;
    private CacheManagerEhcache cacheManager;

    protected void onSetUpBeforeTransaction() throws Exception {
        super.onSetUpBeforeTransaction();
        this.tokenDAO = new TokenDAOMemory();
        this.cacheManager = new CacheManagerEhcache(new CacheManager());
        this.cacheManager.afterPropertiesSet();
        this.tokenDAO.setCacheManager((com.atlassian.crowd.manager.cache.CacheManager)this.cacheManager);
        SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss");
        Token token1 = this.generateToken("oFpXcZ2lfvtc0YQBgE1EeA00", "admin", "hash", 1L, sdf.parse("25-01-2009 11:00:30"), 1234567890L);
        Token token2 = this.generateToken("oFpScZ2lfvtc0YQBgE1EeA00", "user", "hash", 1L, sdf.parse("25-01-2009 11:22:30"), 0L);
        Token token3 = this.generateToken("dHFiDosttLVTLlTKc08BEw00", "crowd", "hash", -1L, sdf.parse("25-01-2009 11:50:30"), 123456789012345L);
        this.cacheManager.put(TokenDAOMemory.RANDOM_HASH_CACHE, (Serializable)((Object)token1.getRandomHash()), (Serializable)token1);
        this.cacheManager.put(TokenDAOMemory.RANDOM_HASH_CACHE, (Serializable)((Object)token2.getRandomHash()), (Serializable)token2);
        this.cacheManager.put(TokenDAOMemory.RANDOM_HASH_CACHE, (Serializable)((Object)token3.getRandomHash()), (Serializable)token3);
        this.cacheManager.put(TokenDAOMemory.IDENTIFIER_HASH_CAHE, (Serializable)((Object)token1.getIdentifierHash()), (Serializable)token1);
        this.cacheManager.put(TokenDAOMemory.IDENTIFIER_HASH_CAHE, (Serializable)((Object)token2.getIdentifierHash()), (Serializable)token2);
        this.cacheManager.put(TokenDAOMemory.IDENTIFIER_HASH_CAHE, (Serializable)((Object)token3.getIdentifierHash()), (Serializable)token3);
        this.setTokenDAO((TokenDAO)this.tokenDAO);
    }

    public String getSampleDataFileName() {
        return null;
    }

    private Token generateToken(String key, String name, String identifierHash, long directoryId, Date expiryTime, long secretNumber) {
        return new Token(directoryId, name, identifierHash, secretNumber, key, expiryTime, expiryTime);
    }

    public void testFindByID() throws Exception {
        try {
            Token token = this.tokenDAO.findByID(TOKEN_ID.longValue());
            TokenDAOMemoryTest.fail((String)"Currently not supported");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }
}

