/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.persistence.dao.property;

import com.atlassian.crowd.acceptance.tests.persistence.BaseSpringTestCase;
import com.atlassian.crowd.dao.property.PropertyDAOHibernate;
import com.atlassian.crowd.exception.ObjectNotFoundException;
import com.atlassian.crowd.model.property.Property;
import com.atlassian.crowd.util.persistence.PersistenceException;
import java.util.List;
import org.hibernate.exception.ConstraintViolationException;

public class PropertyDAOHibernateTest
extends BaseSpringTestCase {
    private PropertyDAOHibernate propertyDAO;
    private static final String CROWD_KEY = "crowd";
    private static final String NAME = "name1";
    private static final String VALUE = "value1";
    private static final String NEW_NAME = "newName";
    private static final String NEW_VALUE = "newValue";
    private static final String JIRA_KEY = "jira";

    public void setPropertyDAO(PropertyDAOHibernate propertyDAO) {
        this.propertyDAO = propertyDAO;
    }

    public void testFindByName() throws Exception {
        Property property = this.propertyDAO.find(CROWD_KEY, NAME);
        PropertyDAOHibernateTest.assertEquals((String)VALUE, (String)property.getValue());
    }

    public void testAdd() throws Exception {
        Property property = new Property(CROWD_KEY, NEW_NAME, NEW_VALUE);
        this.propertyDAO.add(property);
        this.propertyDAO.getSessionFactory().getCurrentSession().flush();
        this.propertyDAO.getSessionFactory().getCurrentSession().clear();
        PropertyDAOHibernateTest.assertEquals((String)NEW_VALUE, (String)this.propertyDAO.find(CROWD_KEY, NEW_NAME).getValue());
    }

    public void testAddDuplication() {
        Property property = new Property(CROWD_KEY, NAME, VALUE);
        this.propertyDAO.add(property);
        try {
            this.propertyDAO.getSessionFactory().getCurrentSession().flush();
            PropertyDAOHibernateTest.fail((String)"ConstraintViolationException expected");
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
    }

    public void testUpdate() throws Exception {
        Property property = this.propertyDAO.find(CROWD_KEY, NAME);
        property.setValue(NEW_VALUE);
        this.propertyDAO.update(property);
        this.propertyDAO.getSessionFactory().getCurrentSession().flush();
        this.propertyDAO.getSessionFactory().getCurrentSession().clear();
        PropertyDAOHibernateTest.assertEquals((String)NEW_VALUE, (String)this.propertyDAO.find(CROWD_KEY, NAME).getValue());
    }

    public void testFindAllByKey() {
        List properties = this.propertyDAO.findAll(CROWD_KEY);
        PropertyDAOHibernateTest.assertEquals((int)2, (int)properties.size());
        properties = this.propertyDAO.findAll(JIRA_KEY);
        PropertyDAOHibernateTest.assertEquals((int)1, (int)properties.size());
        properties = this.propertyDAO.findAll("boguskey");
        PropertyDAOHibernateTest.assertEquals((int)0, (int)properties.size());
    }

    public void testFindAll() throws PersistenceException {
        List allProperties = this.propertyDAO.findAll();
        PropertyDAOHibernateTest.assertEquals((int)3, (int)allProperties.size());
    }

    public void testRemoveProperty() {
        this.propertyDAO.remove(CROWD_KEY, NAME);
        try {
            this.propertyDAO.find(CROWD_KEY, NAME);
            PropertyDAOHibernateTest.fail((String)"ObjectNotFoundException expected");
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            // empty catch block
        }
    }

    public String getSampleDataFileName() {
        return "sample-data.xml";
    }
}

