/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.persistence.dao.directory;

import com.atlassian.crowd.acceptance.tests.persistence.BaseSpringTestCase;
import com.atlassian.crowd.dao.directory.DirectoryDAOHibernate;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectoryType;
import com.atlassian.crowd.embedded.api.OperationType;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.model.directory.DirectoryImpl;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.Combine;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.constants.DirectoryTermKeys;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import org.hibernate.exception.ConstraintViolationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectoryDAOHibernateTest
extends BaseSpringTestCase {
    private DirectoryDAOHibernate directoryDAO;
    private static final long DIRECTORY_ID = 1L;
    private static final String DIRECTORY_NAME_1 = "directory1";
    private static final String DIRECTORY_NAME_2 = "Directory Too";
    private static final String DIRECTORY_NAME_3 = "Third One";

    public void setDirectoryDAO(DirectoryDAOHibernate directoryDAO) {
        this.directoryDAO = directoryDAO;
    }

    public void testAddDirectory() {
        DirectoryImpl directory = new DirectoryImpl();
        directory.setActive(true);
        directory.setName("New Directory");
        directory.setImplementationClass("com.atlassian.crowd.TestClass");
        directory.setType(DirectoryType.INTERNAL);
        directory.setAttribute("key", "value");
        DirectoryImpl returnedDirectory = this.directoryDAO.add((Directory)directory);
        this.directoryDAO.getSessionFactory().getCurrentSession().flush();
        DirectoryDAOHibernateTest.assertNotNull((Object)returnedDirectory);
        DirectoryDAOHibernateTest.assertNotNull((Object)returnedDirectory.getId());
        DirectoryDAOHibernateTest.assertTrue((boolean)returnedDirectory.isActive());
        DirectoryDAOHibernateTest.assertEquals((Object)DirectoryType.INTERNAL, (Object)returnedDirectory.getType());
        DirectoryDAOHibernateTest.assertEquals((String)"New Directory", (String)returnedDirectory.getName());
        DirectoryDAOHibernateTest.assertEquals((String)IdentifierUtils.toLowerCase((String)"New Directory"), (String)returnedDirectory.getLowerName());
        DirectoryDAOHibernateTest.assertNotNull((Object)returnedDirectory.getCreatedDate());
        DirectoryDAOHibernateTest.assertNotNull((Object)returnedDirectory.getUpdatedDate());
        DirectoryDAOHibernateTest.assertEquals((String)"com.atlassian.crowd.TestClass", (String)returnedDirectory.getImplementationClass());
        DirectoryDAOHibernateTest.assertEquals((String)"com.atlassian.crowd.TestClass".toLowerCase(Locale.ENGLISH), (String)returnedDirectory.getLowerImplementationClass());
        DirectoryDAOHibernateTest.assertNull((Object)returnedDirectory.getDescription());
        DirectoryDAOHibernateTest.assertFalse((boolean)returnedDirectory.getAttributes().isEmpty());
        DirectoryDAOHibernateTest.assertTrue((boolean)returnedDirectory.getAllowedOperations().isEmpty());
        DirectoryDAOHibernateTest.assertEquals((String)"value", (String)returnedDirectory.getValue("key"));
    }

    public void testAddDirectoryDuplicate() {
        DirectoryImpl directory = new DirectoryImpl();
        directory.setActive(false);
        directory.setName(DIRECTORY_NAME_1);
        directory.setImplementationClass("com.atlassian.crowd.TestClassic");
        directory.setType(DirectoryType.CONNECTOR);
        this.directoryDAO.add((Directory)directory);
        try {
            this.directoryDAO.getSessionFactory().getCurrentSession().flush();
            DirectoryDAOHibernateTest.fail((String)"ConstraintViolationException expected");
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
    }

    public void testAddDirectoryIncomplete() {
        DirectoryImpl directory = new DirectoryImpl();
        directory.setActive(true);
        directory.setName("New Directory");
        try {
            this.directoryDAO.add((Directory)directory);
            DirectoryDAOHibernateTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testFindById() throws Exception {
        DirectoryImpl directory = this.directoryDAO.findById(1L);
        DirectoryDAOHibernateTest.assertNotNull((Object)directory.getId());
        DirectoryDAOHibernateTest.assertEquals((String)DIRECTORY_NAME_1, (String)directory.getName());
        DirectoryDAOHibernateTest.assertEquals((String)IdentifierUtils.toLowerCase((String)DIRECTORY_NAME_1), (String)directory.getLowerName());
        DirectoryDAOHibernateTest.assertEquals((String)"Simple Directory", (String)directory.getDescription());
        DirectoryDAOHibernateTest.assertEquals((String)"com.atlassian.crowd.directory.InternalDirectory", (String)directory.getImplementationClass());
        DirectoryDAOHibernateTest.assertEquals((String)"com.atlassian.crowd.directory.InternalDirectory".toLowerCase(Locale.ENGLISH), (String)directory.getLowerImplementationClass());
        DirectoryDAOHibernateTest.assertEquals((Object)DirectoryType.INTERNAL, (Object)directory.getType());
        DirectoryDAOHibernateTest.assertTrue((boolean)directory.isActive());
        DirectoryDAOHibernateTest.assertEquals((String)"Ten", (String)directory.getValue("Number"));
        DirectoryDAOHibernateTest.assertEquals((String)"Red", (String)directory.getValue("color"));
        DirectoryDAOHibernateTest.assertEquals((int)4, (int)directory.getKeys().size());
        DirectoryDAOHibernateTest.assertEquals((int)6, (int)directory.getAllowedOperations().size());
        DirectoryDAOHibernateTest.assertTrue((boolean)directory.getAllowedOperations().contains(OperationType.CREATE_GROUP));
        DirectoryDAOHibernateTest.assertTrue((boolean)directory.getAllowedOperations().contains(OperationType.CREATE_USER));
        DirectoryDAOHibernateTest.assertTrue((boolean)directory.getAllowedOperations().contains(OperationType.UPDATE_GROUP));
        DirectoryDAOHibernateTest.assertTrue((boolean)directory.getAllowedOperations().contains(OperationType.UPDATE_USER));
        DirectoryDAOHibernateTest.assertTrue((boolean)directory.getAllowedOperations().contains(OperationType.DELETE_GROUP));
        DirectoryDAOHibernateTest.assertTrue((boolean)directory.getAllowedOperations().contains(OperationType.DELETE_USER));
    }

    public void testFindByIdNotFound() {
        try {
            this.directoryDAO.findById(-1L);
            DirectoryDAOHibernateTest.fail((String)"DirectoryNotFoundException expected");
        }
        catch (DirectoryNotFoundException directoryNotFoundException) {
            // empty catch block
        }
    }

    public void testFindByName() throws Exception {
        DirectoryImpl directory = this.directoryDAO.findByName(DIRECTORY_NAME_2.toUpperCase());
        DirectoryDAOHibernateTest.assertNotNull((Object)directory.getId());
        DirectoryDAOHibernateTest.assertEquals((String)DIRECTORY_NAME_2, (String)directory.getName());
        DirectoryDAOHibernateTest.assertEquals((String)IdentifierUtils.toLowerCase((String)DIRECTORY_NAME_2), (String)directory.getLowerName());
        DirectoryDAOHibernateTest.assertEquals((String)"Another Simple Directory", (String)directory.getDescription());
        DirectoryDAOHibernateTest.assertEquals((String)"com.atlassian.crowd.directory.MyDirectory", (String)directory.getImplementationClass());
        DirectoryDAOHibernateTest.assertEquals((String)"com.atlassian.crowd.directory.MyDirectory".toLowerCase(Locale.ENGLISH), (String)directory.getLowerImplementationClass());
        DirectoryDAOHibernateTest.assertEquals((Object)DirectoryType.CUSTOM, (Object)directory.getType());
        DirectoryDAOHibernateTest.assertFalse((boolean)directory.isActive());
    }

    public void testFindByNameNotFound() {
        try {
            this.directoryDAO.findByName("bogus");
            DirectoryDAOHibernateTest.fail((String)"DirectoryNotFoundException expected");
        }
        catch (DirectoryNotFoundException directoryNotFoundException) {
            // empty catch block
        }
    }

    public void testUpdateDirectory() throws Exception {
        DirectoryImpl directory = this.directoryDAO.findById(1L);
        directory.setActive(false);
        directory.setName("New Directory");
        directory.setImplementationClass("com.atlassian.crowd.TestClassic");
        directory.setType(DirectoryType.CUSTOM);
        directory.setDescription(null);
        this.directoryDAO.update((Directory)directory);
        this.directoryDAO.getSessionFactory().getCurrentSession().flush();
        DirectoryImpl updatedDirectory = this.directoryDAO.findById(1L);
        DirectoryDAOHibernateTest.assertEquals((String)"New Directory", (String)updatedDirectory.getName());
        DirectoryDAOHibernateTest.assertEquals((String)IdentifierUtils.toLowerCase((String)"New Directory"), (String)updatedDirectory.getLowerName());
        DirectoryDAOHibernateTest.assertNull((Object)updatedDirectory.getDescription());
        DirectoryDAOHibernateTest.assertEquals((String)"com.atlassian.crowd.TestClassic", (String)updatedDirectory.getImplementationClass());
        DirectoryDAOHibernateTest.assertEquals((String)"com.atlassian.crowd.TestClassic".toLowerCase(Locale.ENGLISH), (String)directory.getLowerImplementationClass());
        DirectoryDAOHibernateTest.assertEquals((Object)DirectoryType.CUSTOM, (Object)updatedDirectory.getType());
        DirectoryDAOHibernateTest.assertFalse((boolean)updatedDirectory.isActive());
        DirectoryDAOHibernateTest.assertEquals((String)"Ten", (String)directory.getValue("Number"));
        DirectoryDAOHibernateTest.assertEquals((String)"Red", (String)directory.getValue("color"));
        DirectoryDAOHibernateTest.assertEquals((int)4, (int)directory.getKeys().size());
        DirectoryDAOHibernateTest.assertEquals((int)6, (int)directory.getAllowedOperations().size());
    }

    public void testAddDirectoryWithBellsAndWhistles() throws Exception {
        DirectoryImpl directory = new DirectoryImpl();
        directory.setActive(true);
        directory.setName("New Directory");
        directory.setImplementationClass("com.atlassian.crowd.TestClass");
        directory.setType(DirectoryType.INTERNAL);
        directory.setAttribute("One", "Two");
        directory.setAttribute("Three", "Four");
        HashSet<OperationType> ops = new HashSet<OperationType>(Arrays.asList(OperationType.CREATE_GROUP, OperationType.CREATE_USER));
        directory.setAllowedOperations(ops);
        this.directoryDAO.add((Directory)directory);
        this.directoryDAO.getSessionFactory().getCurrentSession().flush();
        DirectoryImpl addedDirectory = this.directoryDAO.findByName(directory.getName().toUpperCase());
        DirectoryDAOHibernateTest.assertTrue((boolean)directory.isActive());
        DirectoryDAOHibernateTest.assertEquals((String)"New Directory", (String)addedDirectory.getName());
        DirectoryDAOHibernateTest.assertEquals((String)IdentifierUtils.toLowerCase((String)"New Directory"), (String)addedDirectory.getLowerName());
        DirectoryDAOHibernateTest.assertEquals((String)"com.atlassian.crowd.TestClass", (String)addedDirectory.getImplementationClass());
        DirectoryDAOHibernateTest.assertEquals((String)"com.atlassian.crowd.TestClass".toLowerCase(Locale.ENGLISH), (String)addedDirectory.getLowerImplementationClass());
        DirectoryDAOHibernateTest.assertEquals((Object)DirectoryType.INTERNAL, (Object)addedDirectory.getType());
        DirectoryDAOHibernateTest.assertEquals((String)"Two", (String)directory.getValue("One"));
        DirectoryDAOHibernateTest.assertEquals((String)"Four", (String)directory.getValue("Three"));
        DirectoryDAOHibernateTest.assertEquals((int)2, (int)directory.getKeys().size());
        DirectoryDAOHibernateTest.assertEquals(ops, (Object)directory.getAllowedOperations());
    }

    public void testUpdateDirectoryWithBellsAndWhistles() throws Exception {
        DirectoryImpl directory = this.directoryDAO.findById(1L);
        directory.setActive(false);
        directory.setName("New Directory");
        directory.setImplementationClass("com.atlassian.crowd.TestClassic");
        directory.setType(DirectoryType.CUSTOM);
        directory.setDescription(null);
        directory.setAttribute("Number", "one");
        directory.getAllowedOperations().remove(OperationType.DELETE_GROUP);
        directory.getAllowedOperations().remove(OperationType.DELETE_USER);
        this.directoryDAO.update((Directory)directory);
        this.directoryDAO.getSessionFactory().getCurrentSession().flush();
        DirectoryImpl updatedDirectory = this.directoryDAO.findById(1L);
        DirectoryDAOHibernateTest.assertEquals((String)"New Directory", (String)updatedDirectory.getName());
        DirectoryDAOHibernateTest.assertEquals((String)IdentifierUtils.toLowerCase((String)"New Directory"), (String)updatedDirectory.getLowerName());
        DirectoryDAOHibernateTest.assertNull((Object)updatedDirectory.getDescription());
        DirectoryDAOHibernateTest.assertEquals((String)"com.atlassian.crowd.TestClassic", (String)updatedDirectory.getImplementationClass());
        DirectoryDAOHibernateTest.assertEquals((String)"com.atlassian.crowd.TestClassic".toLowerCase(Locale.ENGLISH), (String)updatedDirectory.getLowerImplementationClass());
        DirectoryDAOHibernateTest.assertEquals((Object)DirectoryType.CUSTOM, (Object)updatedDirectory.getType());
        DirectoryDAOHibernateTest.assertFalse((boolean)updatedDirectory.isActive());
        DirectoryDAOHibernateTest.assertEquals((String)"one", (String)directory.getValue("Number"));
        DirectoryDAOHibernateTest.assertEquals((String)"Red", (String)directory.getValue("color"));
        DirectoryDAOHibernateTest.assertEquals((int)4, (int)directory.getKeys().size());
        DirectoryDAOHibernateTest.assertEquals((int)4, (int)directory.getAllowedOperations().size());
        DirectoryDAOHibernateTest.assertTrue((boolean)directory.getAllowedOperations().contains(OperationType.CREATE_GROUP));
        DirectoryDAOHibernateTest.assertTrue((boolean)directory.getAllowedOperations().contains(OperationType.CREATE_USER));
        DirectoryDAOHibernateTest.assertTrue((boolean)directory.getAllowedOperations().contains(OperationType.UPDATE_GROUP));
        DirectoryDAOHibernateTest.assertTrue((boolean)directory.getAllowedOperations().contains(OperationType.UPDATE_USER));
    }

    public void testRemove() throws Exception {
        this.jdbcTemplate.execute("delete from CWD_APP_DIR_GROUP_MAPPING");
        this.jdbcTemplate.execute("delete from CWD_APP_DIR_OPERATION");
        this.jdbcTemplate.execute("delete from CWD_APP_DIR_MAPPING");
        DirectoryImpl directory = this.directoryDAO.findById(1L);
        this.directoryDAO.remove((Directory)directory);
        this.directoryDAO.getSessionFactory().getCurrentSession().flush();
        try {
            this.directoryDAO.findById(1L);
            DirectoryDAOHibernateTest.fail((String)"DirectoryNotFoundException expected");
        }
        catch (DirectoryNotFoundException directoryNotFoundException) {
            // empty catch block
        }
        DirectoryDAOHibernateTest.assertEquals((int)0, (int)this.jdbcTemplate.queryForInt("select count(*) from CWD_DIRECTORY_ATTRIBUTE where directory_id = 1"));
        DirectoryDAOHibernateTest.assertEquals((int)0, (int)this.jdbcTemplate.queryForInt("select count(*) from CWD_DIRECTORY_OPERATION where directory_id = 1"));
        DirectoryDAOHibernateTest.assertEquals((int)0, (int)this.jdbcTemplate.queryForInt("select count(*) from CWD_USER where directory_id = 1"));
        DirectoryDAOHibernateTest.assertEquals((int)0, (int)this.jdbcTemplate.queryForInt("select count(*) from CWD_USER_ATTRIBUTE where directory_id = 1"));
        DirectoryDAOHibernateTest.assertEquals((int)0, (int)this.jdbcTemplate.queryForInt("select count(*) from CWD_USER_CREDENTIAL_RECORD"));
        DirectoryDAOHibernateTest.assertEquals((int)0, (int)this.jdbcTemplate.queryForInt("select count(*) from CWD_GROUP where directory_id = 1"));
        DirectoryDAOHibernateTest.assertEquals((int)0, (int)this.jdbcTemplate.queryForInt("select count(*) from CWD_GROUP_ATTRIBUTE where directory_id = 1"));
        DirectoryDAOHibernateTest.assertEquals((int)0, (int)this.jdbcTemplate.queryForInt("select count(*) from CWD_MEMBERSHIP where directory_id = 1"));
    }

    public void testSearchAll() {
        List directories = this.directoryDAO.search(QueryBuilder.queryFor(Directory.class, (EntityDescriptor)EntityDescriptor.directory()).returningAtMost(10));
        this.assertContainsExactly(directories, DIRECTORY_NAME_1, DIRECTORY_NAME_2, DIRECTORY_NAME_3);
    }

    public void testSearchByNameStartingWith() {
        List directories = this.directoryDAO.search(QueryBuilder.queryFor(Directory.class, (EntityDescriptor)EntityDescriptor.directory()).with((SearchRestriction)Restriction.on((Property)DirectoryTermKeys.NAME).startingWith((Object)"directory")).returningAtMost(10));
        this.assertContainsExactly(directories, DIRECTORY_NAME_1, DIRECTORY_NAME_2);
    }

    public void testSearchByNameContaining() {
        List direcotries = this.directoryDAO.search(QueryBuilder.queryFor(Directory.class, (EntityDescriptor)EntityDescriptor.directory()).with((SearchRestriction)Restriction.on((Property)DirectoryTermKeys.NAME).containing((Object)"oo")).returningAtMost(10));
        this.assertContainsExactly(direcotries, DIRECTORY_NAME_2);
    }

    public void testSearchByActive() {
        List directories = this.directoryDAO.search(QueryBuilder.queryFor(Directory.class, (EntityDescriptor)EntityDescriptor.directory()).with((SearchRestriction)Restriction.on((Property)DirectoryTermKeys.ACTIVE).exactlyMatching((Object)true)).returningAtMost(10));
        this.assertContains(directories, DIRECTORY_NAME_1);
    }

    public void testSearchByType() {
        List directories = this.directoryDAO.search(QueryBuilder.queryFor(Directory.class, (EntityDescriptor)EntityDescriptor.directory()).with((SearchRestriction)Restriction.on((Property)DirectoryTermKeys.TYPE).exactlyMatching((Object)DirectoryType.INTERNAL)).returningAtMost(10));
        this.assertContains(directories, DIRECTORY_NAME_1);
    }

    public void testSearchByImplementationClass() {
        List directories = this.directoryDAO.search(QueryBuilder.queryFor(Directory.class, (EntityDescriptor)EntityDescriptor.directory()).with((SearchRestriction)Restriction.on((Property)DirectoryTermKeys.IMPLEMENTATION_CLASS).containing((Object)"InternalDirectory")).returningAtMost(10));
        this.assertContains(directories, DIRECTORY_NAME_1);
    }

    public void testSearchNestedQuery() {
        List directories = this.directoryDAO.search(QueryBuilder.queryFor(Directory.class, (EntityDescriptor)EntityDescriptor.directory()).with((SearchRestriction)Combine.anyOf((SearchRestriction[])new SearchRestriction[]{Combine.allOf((SearchRestriction[])new SearchRestriction[]{Restriction.on((Property)DirectoryTermKeys.NAME).startingWith((Object)"dir"), Restriction.on((Property)DirectoryTermKeys.ACTIVE).exactlyMatching((Object)true)}), Combine.allOf((SearchRestriction[])new SearchRestriction[]{Restriction.on((Property)DirectoryTermKeys.IMPLEMENTATION_CLASS).containing((Object)"my"), Restriction.on((Property)DirectoryTermKeys.TYPE).exactlyMatching((Object)DirectoryType.CUSTOM)})})).returningAtMost(10));
        this.assertContainsExactly(directories, DIRECTORY_NAME_1, DIRECTORY_NAME_2);
    }

    private void assertContainsExactly(List<Directory> directories, String ... directorynames) {
        DirectoryDAOHibernateTest.assertEquals((int)directorynames.length, (int)directories.size());
        for (String directoryname : directorynames) {
            this.assertContains(directories, directoryname);
        }
    }

    private void assertContains(List<Directory> directories, String directoryname) {
        DirectoryDAOHibernateTest.assertTrue((String)("Directory " + directoryname + " not found in " + directories), (boolean)this.contains(directories, directoryname));
    }

    private boolean contains(List<Directory> directories, String directoryname) {
        for (Directory directory : directories) {
            if (!directory.getName().equals(directoryname)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getSampleDataFileName() {
        return "sample-data.xml";
    }
}

