/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.directory;

import com.atlassian.crowd.acceptance.utils.AbstractDbCachingLoadTest;
import com.atlassian.crowd.acceptance.utils.LoadStatWriter;

public class DbCachingLoadTest
extends AbstractDbCachingLoadTest {
    private LoadStatWriter statWriter;

    public void setUp() throws Exception {
        super.setUp();
        this.setScriptingEnabled(true);
        this.restoreBaseSetup();
        this.statWriter = new LoadStatWriter(((Object)((Object)this)).getClass().getName());
    }

    public void tearDown() throws Exception {
        this.statWriter.close();
        this.restoreBaseSetup();
        this.setScriptingEnabled(false);
        super.tearDown();
    }

    public void testSynchronise() throws InterruptedException {
        this._testSynchronise10kTo5kUsers();
        this._testSynchroniseSwap2kUsers();
        this._testSynchronise1kTo10kUsers();
        this._testSynchronise5kTo10kUsers();
        this._testSynchronise10kTo1kUsers();
    }

    private void _testSynchroniseSwap2kUsers() throws InterruptedException {
        this.logger.info((Object)"Running: _testSynchroniseSwap2kUsers");
        this.restoreBaseSetup();
        this.createLoadTestingDirectory(CONNECTOR_URL, CHILD_OU_B, CONNECTOR_USERDN, CONNECTOR_USERPW);
        long duration1 = this.synchroniseDirectory("2k Users");
        this.assertUsersAndGroupsFromOUPresent("B");
        this.assertUsersAndGroupsFromOUNotPresent("C");
        DbCachingLoadTest.assertFalse((boolean)this.isLargeRootGroupPresent());
        this.assertMembershipsPresent("B", MEMBERSHIPS_COUNT);
        this.changeDirectoryBaseDN(CHILD_OU_C);
        long duration2 = this.synchroniseDirectory("2k Users");
        this.assertUsersAndGroupsFromOUNotPresent("B");
        this.assertUsersAndGroupsFromOUPresent("C");
        DbCachingLoadTest.assertFalse((boolean)this.isLargeRootGroupPresent());
        this.assertMembershipsPresent("C", MEMBERSHIPS_COUNT);
        this.logger.info((Object)"");
        this.logger.info((Object)"======================================================================");
        this.logger.info((Object)"# Synchronise 2k users and then change ou to synchronise a new set of 2k users");
        this.logger.info((Object)("#    Initial 2k users took (in seconds):\t\t" + duration1));
        this.logger.info((Object)("#    Swap to new 2k users took (in seconds):\t" + duration2));
        this.logger.info((Object)"======================================================================");
        this.logger.info((Object)"");
        this.statWriter.addPoint("testSynchroniseSwap2kUsers_initial_2k_users", duration1);
        this.statWriter.addPoint("testSynchroniseSwap2kUsers_swap_to_new_2k_users", duration2);
    }

    private void _testSynchronise1kTo10kUsers() throws InterruptedException {
        this.logger.info((Object)"Running: _testSynchronise1kTo10kUsers");
        this.restoreBaseSetup();
        this.createLoadTestingDirectory(CONNECTOR_URL, CHILD_OU_D, CONNECTOR_USERDN, CONNECTOR_USERPW);
        long duration1 = this.synchroniseDirectory("1k Users");
        this.assertUsersAndGroupsFromOUNotPresent("A");
        this.assertUsersAndGroupsFromOUPresent("D");
        DbCachingLoadTest.assertFalse((boolean)this.isLargeRootGroupPresent());
        this.assertMembershipsPresent("D", MEMBERSHIPS_COUNT);
        this.changeDirectoryBaseDN(CONNECTOR_BASEDN);
        long duration2 = this.synchroniseDirectory("10k Users");
        this.assertUsersAndGroupsFromOUPresent("A");
        this.assertUsersAndGroupsFromOUPresent("B");
        this.assertUsersAndGroupsFromOUPresent("C");
        this.assertUsersAndGroupsFromOUPresent("D");
        DbCachingLoadTest.assertTrue((boolean)this.isLargeRootGroupPresent());
        this.assertMembershipsPresent("A", MEMBERSHIPS_COUNT + 1);
        this.assertMembershipsPresent("B", MEMBERSHIPS_COUNT + 1);
        this.assertMembershipsPresent("C", MEMBERSHIPS_COUNT + 1);
        this.assertMembershipsPresent("D", MEMBERSHIPS_COUNT + 1);
        this.logger.info((Object)"======================================================================");
        this.logger.info((Object)"# Synchronise 1k users and then change ou to synchronise 10k users");
        this.logger.info((Object)("#    Initial 1k users took (in seconds):\t\t" + duration1));
        this.logger.info((Object)("#    Increase to 10k users took (in seconds):\t" + duration2));
        this.logger.info((Object)"======================================================================");
        this.statWriter.addPoint("testSynchronise1kTo10kUsers_initial_1k_users", duration1);
        this.statWriter.addPoint("testSynchronise1kTo10kUsers_increase_to_10k_users", duration2);
    }

    private void _testSynchronise5kTo10kUsers() throws InterruptedException {
        this.logger.info((Object)"Running: _testSynchronise5kTo10kUsers");
        this.restoreBaseSetup();
        this.createLoadTestingDirectory(CONNECTOR_URL, CHILD_OU_A, CONNECTOR_USERDN, CONNECTOR_USERPW);
        long duration1 = this.synchroniseDirectory("5k Users");
        this.assertUsersAndGroupsFromOUPresent("A");
        this.assertUsersAndGroupsFromOUNotPresent("D");
        DbCachingLoadTest.assertFalse((boolean)this.isLargeRootGroupPresent());
        this.assertMembershipsPresent("A", MEMBERSHIPS_COUNT);
        this.changeDirectoryBaseDN(CONNECTOR_BASEDN);
        long duration2 = this.synchroniseDirectory("10k Users");
        this.assertUsersAndGroupsFromOUPresent("A");
        this.assertUsersAndGroupsFromOUPresent("B");
        this.assertUsersAndGroupsFromOUPresent("C");
        this.assertUsersAndGroupsFromOUPresent("D");
        DbCachingLoadTest.assertTrue((boolean)this.isLargeRootGroupPresent());
        this.assertMembershipsPresent("A", MEMBERSHIPS_COUNT + 1);
        this.assertMembershipsPresent("B", MEMBERSHIPS_COUNT + 1);
        this.assertMembershipsPresent("C", MEMBERSHIPS_COUNT + 1);
        this.assertMembershipsPresent("D", MEMBERSHIPS_COUNT + 1);
        this.logger.info((Object)"======================================================================");
        this.logger.info((Object)"# Synchronise 5k users and then change ou to synchronise 10k users");
        this.logger.info((Object)("#    Initial 5k users took (in seconds):\t\t" + duration1));
        this.logger.info((Object)("#    Increase to 10k users took (in seconds):\t" + duration2));
        this.logger.info((Object)"======================================================================");
        this.statWriter.addPoint("testSynchronise5kTo10kUsers_initial_5k_users", duration1);
        this.statWriter.addPoint("testSynchronise5kTo10kUsers_increase_to_10k_users", duration2);
    }

    private void _testSynchronise10kTo1kUsers() throws InterruptedException {
        this.logger.info((Object)"Running: _testSynchronise10kTo1kUsers");
        this.restoreBaseSetup();
        this.createLoadTestingDirectory(CONNECTOR_URL, CONNECTOR_BASEDN, CONNECTOR_USERDN, CONNECTOR_USERPW);
        long duration1 = this.synchroniseDirectory("10k Users");
        this.assertUsersAndGroupsFromOUPresent("A");
        this.assertUsersAndGroupsFromOUPresent("B");
        this.assertUsersAndGroupsFromOUPresent("C");
        this.assertUsersAndGroupsFromOUPresent("D");
        DbCachingLoadTest.assertTrue((boolean)this.isLargeRootGroupPresent());
        this.assertMembershipsPresent("A", MEMBERSHIPS_COUNT + 1);
        this.assertMembershipsPresent("B", MEMBERSHIPS_COUNT + 1);
        this.assertMembershipsPresent("C", MEMBERSHIPS_COUNT + 1);
        this.assertMembershipsPresent("D", MEMBERSHIPS_COUNT + 1);
        this.changeDirectoryBaseDN(CHILD_OU_D);
        long duration2 = this.synchroniseDirectory("1k Users");
        this.assertUsersAndGroupsFromOUNotPresent("A");
        this.assertUsersAndGroupsFromOUPresent("D");
        DbCachingLoadTest.assertFalse((boolean)this.isLargeRootGroupPresent());
        this.assertMembershipsPresent("D", MEMBERSHIPS_COUNT);
        this.logger.info((Object)"");
        this.logger.info((Object)"======================================================================");
        this.logger.info((Object)"# Synchronise 10k users and then change ou to synchronise 1k users");
        this.logger.info((Object)("#    Initial 10k users took (in seconds):\t\t" + duration1));
        this.logger.info((Object)("#    Decrease to 1k users took (in seconds):\t" + duration2));
        this.logger.info((Object)"======================================================================");
        this.logger.info((Object)"");
        this.statWriter.addPoint("testSynchronise10kTo1kUsers_initial_10k_users", duration1);
        this.statWriter.addPoint("testSynchronise10kTo1kUsers_decrease_to_1k_users", duration2);
    }

    private void _testSynchronise10kTo5kUsers() throws InterruptedException {
        this.logger.info((Object)"Running: _testSynchronise10kTo5kUsers");
        this.restoreBaseSetup();
        this.createLoadTestingDirectory(CONNECTOR_URL, CONNECTOR_BASEDN, CONNECTOR_USERDN, CONNECTOR_USERPW);
        long duration1 = this.synchroniseDirectory("10k Users");
        this.assertUsersAndGroupsFromOUPresent("A");
        this.assertUsersAndGroupsFromOUPresent("B");
        this.assertUsersAndGroupsFromOUPresent("C");
        this.assertUsersAndGroupsFromOUPresent("D");
        DbCachingLoadTest.assertTrue((boolean)this.isLargeRootGroupPresent());
        this.assertMembershipsPresent("A", MEMBERSHIPS_COUNT + 1);
        this.assertMembershipsPresent("B", MEMBERSHIPS_COUNT + 1);
        this.assertMembershipsPresent("C", MEMBERSHIPS_COUNT + 1);
        this.assertMembershipsPresent("D", MEMBERSHIPS_COUNT + 1);
        this.changeDirectoryBaseDN(CHILD_OU_A);
        long duration2 = this.synchroniseDirectory("5k Users");
        this.assertUsersAndGroupsFromOUPresent("A");
        this.assertUsersAndGroupsFromOUNotPresent("D");
        DbCachingLoadTest.assertFalse((boolean)this.isLargeRootGroupPresent());
        this.assertMembershipsPresent("A", MEMBERSHIPS_COUNT);
        this.logger.info((Object)"");
        this.logger.info((Object)"======================================================================");
        this.logger.info((Object)"# Synchronise 10k users and then change ou to synchronise 5k users");
        this.logger.info((Object)("#    Initial 10k users took (in seconds):\t\t" + duration1));
        this.logger.info((Object)("#    Decrease to 5k users took (in seconds):\t" + duration2));
        this.logger.info((Object)"======================================================================");
        this.logger.info((Object)"");
        this.statWriter.addPoint("testSynchronise10kTo5kUsers_initial_10k_users", duration1);
        this.statWriter.addPoint("testSynchronise10kTo5kUsers_decrease_to_5k_users", duration2);
    }

    private boolean isLargeRootGroupPresent() {
        this.gotoBrowseGroups();
        this.setWorkingForm("browsegroups");
        this.setTextField("name", "all-");
        this.selectOption("directoryID", "Test Connector Directory");
        this.submit();
        return this.isTextPresent("all-group-");
    }

    private void assertMembershipsPresent(String childOU, int membershipsCount) {
        for (int i = 0; i < 5; ++i) {
            this.gotoViewPrincipal(this.createUserName(childOU, i), "Test Connector Directory");
            this.clickLink("user-groups-tab");
            this.setWorkingForm("groupsForm");
            this.assertTableRowCountEquals("groupsTable", membershipsCount + 1);
            this.assertTextPresent(childOU + PARTIAL_GROUPNAME);
        }
    }

    private void changeDirectoryBaseDN(String newBaseDN) {
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText("Test Connector Directory");
        this.clickLink("connector-connectiondetails");
        this.setWorkingForm("connectordetails");
        this.setTextField("baseDN", newBaseDN);
        this.submit();
        this.assertTextFieldEquals("baseDN", newBaseDN);
    }
}

