/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.client.atlassianuser;

import com.atlassian.crowd.acceptance.tests.client.atlassianuser.CrowdEntityQueryParserTest;
import com.atlassian.crowd.acceptance.tests.directory.BaseTest;
import com.atlassian.crowd.acceptance.utils.DbCachingTestHelper;
import com.atlassian.crowd.acceptance.utils.DirectoryTestHelper;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.model.group.GroupTemplate;
import com.atlassian.crowd.model.group.GroupType;
import com.atlassian.crowd.model.user.UserTemplate;
import com.atlassian.crowd.model.user.UserTemplateWithAttributes;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import java.util.List;
import java.util.Properties;

public class CrowdEntityQueryParserLDAPTest
extends CrowdEntityQueryParserTest {
    private static final String DIRECTORY_NAME = "ApacheDS";
    private static final long MAX_WAIT_TIME_MS = 10000L;
    private static boolean setUpOnce = false;

    protected boolean hasBeenSetUpOnce() {
        return setUpOnce;
    }

    protected void setUpOnce() throws Exception {
        super.setUpOnce();
        this.restoreCrowdFromXML("atlassianusersearchldap.xml");
        LDAPLoader ldapLoader = new LDAPLoader();
        ldapLoader.accessibleSetUp();
        setUpOnce = true;
    }

    private void synchroniseDirectory() {
        DbCachingTestHelper.synchroniseDirectory(this.tester, DIRECTORY_NAME, 10000L);
    }

    private static class LDAPLoader
    extends BaseTest {
        LDAPLoader() {
            this.setDirectoryConfigFile(DirectoryTestHelper.getApacheDS102ConfigFileName());
        }

        protected void configureDirectory(Properties directorySettings) {
            super.configureDirectory(directorySettings);
            this.directory.setAttribute("com.atlassian.crowd.directory.sync.cache.enabled", Boolean.FALSE.toString());
        }

        protected void loadTestData() throws Exception {
            List existingUsernames = this.getRemoteDirectory().searchUsers(QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).returningAtMost(-1));
            for (String username : existingUsernames) {
                this.getRemoteDirectory().removeUser(username);
            }
            List existingGroups = this.getRemoteDirectory().searchGroups(QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group((GroupType)GroupType.GROUP)).returningAtMost(-1));
            for (String groupName : existingGroups) {
                this.getRemoteDirectory().removeGroup(groupName);
            }
            UserTemplateWithAttributes admin = this.buildUser("admin", "admin@example.com", "Super", "User", this.directory.getId());
            admin.setDisplayName("Super User");
            this.getRemoteDirectory().addUser((UserTemplate)admin, new PasswordCredential("secret"));
            UserTemplateWithAttributes alice = this.buildUser("alice", "alice@example.com", "Alice", "Smith", this.directory.getId());
            alice.setDisplayName("Alice Smith");
            this.getRemoteDirectory().addUser((UserTemplate)alice, new PasswordCredential("secret"));
            UserTemplateWithAttributes bob = this.buildUser("bob", "bob@example.com", "Bob", "Smith", this.directory.getId());
            bob.setDisplayName("Bob Smith");
            this.getRemoteDirectory().addUser((UserTemplate)bob, new PasswordCredential("secret"));
            UserTemplateWithAttributes confadmin = this.buildUser("confadmin", "confadmin@example.com", "Conf", "Admin", this.directory.getId());
            confadmin.setDisplayName("Conf Admin");
            this.getRemoteDirectory().addUser((UserTemplate)confadmin, new PasswordCredential("secret"));
            UserTemplateWithAttributes shihab = this.buildUser("shihab", "shamid@atlassian.com", "Shihab", "Hamid", this.directory.getId());
            shihab.setDisplayName("Shihab Hamid");
            this.getRemoteDirectory().addUser((UserTemplate)shihab, new PasswordCredential("secret"));
            this.getRemoteDirectory().addGroup(new GroupTemplate("crowd-administrators", this.directory.getId().longValue(), GroupType.GROUP));
            this.getRemoteDirectory().addGroup(new GroupTemplate("confluence-administrators", this.directory.getId().longValue(), GroupType.GROUP));
            this.getRemoteDirectory().addGroup(new GroupTemplate("confluence-users", this.directory.getId().longValue(), GroupType.GROUP));
        }

        protected void removeTestData() {
        }

        public void accessibleSetUp() throws Exception {
            super.setUp();
        }

        public void accessibleTearDown() throws Exception {
            super.tearDown();
        }
    }
}

