/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.applications.jira;

import com.atlassian.crowd.acceptance.tests.applications.jira.JiraAcceptanceTestCase;

public class JiraUserMutationTest
extends JiraAcceptanceTestCase {
    protected static final String JIRA_USER_USERNAME = "jira-user";
    protected static final String JIRA_USER_PASSWORD = "password";
    protected static final String JIRA_USER_FIRSTNAME = "Jira";
    protected static final String JIRA_USER_LASTNAME = "User";
    protected static final String JIRA_USER_FULLNAME = "Jira User";
    protected static final String JIRA_USER_EMAIL = "jirauser@example.com";
    protected static final String JIRA_USER_FIRSTNAME_UPDATED = "JiraUser";
    protected static final String JIRA_USER_LASTNAME_UPDATED = "Mutant";
    protected static final String JIRA_USER_FULLNAME_UPDATED = "JiraUser Mutant";
    protected static final String JIRA_USER_EMAIL_UPDATED = "jirauser@updatedemail.com";

    protected void setUp() throws Exception {
        super.setUp();
        this.adminLoginToJira();
    }

    public void testJiraUserCrud() {
        this._testCreateJiraUser();
        this._testUpdateJiraUser();
        this._testAddJiraUserGroupMembership();
        this._testRemoveJiraUserGroupMembership();
        this._testDeleteJiraUser();
    }

    public void _testCreateJiraUser() {
        this.gotoBrowseUsers();
        this.clickLink("add_user");
        this.assertTextPresent("Create New User");
        this.setWorkingForm("jiraform");
        this.setTextField("username", JIRA_USER_USERNAME);
        this.setTextField(JIRA_USER_PASSWORD, JIRA_USER_PASSWORD);
        this.setTextField("confirm", JIRA_USER_PASSWORD);
        this.setTextField("fullname", JIRA_USER_FULLNAME);
        this.setTextField("email", JIRA_USER_EMAIL);
        this.uncheckCheckbox("sendEmail");
        this.submit();
        this.assertTextPresent("User: Jira User");
        this.assertTextPresent(JIRA_USER_USERNAME);
        this.assertTextPresent(JIRA_USER_FULLNAME);
        this.assertTextPresent(JIRA_USER_EMAIL);
        this.assertTextPresent("jira-users");
        this.verifyUserExistsInCrowd(JIRA_USER_USERNAME, JIRA_USER_FIRSTNAME, JIRA_USER_LASTNAME, JIRA_USER_EMAIL, "jira-users");
    }

    private void _testUpdateJiraUser() {
        this.verifyUserExistsInCrowd(JIRA_USER_USERNAME, JIRA_USER_FIRSTNAME, JIRA_USER_LASTNAME, JIRA_USER_EMAIL, "jira-users");
        this.gotoBrowseUsers();
        this.clickLink(JIRA_USER_USERNAME);
        this.clickLinkWithText("Edit Details");
        this.setWorkingForm("jiraform");
        this.setTextField("fullName", JIRA_USER_FULLNAME_UPDATED);
        this.setTextField("email", JIRA_USER_EMAIL_UPDATED);
        this.submit();
        this.assertTextPresent("User: JiraUser Mutant");
        this.assertTextPresent(JIRA_USER_USERNAME);
        this.assertTextPresent(JIRA_USER_EMAIL_UPDATED);
        this.assertTextPresent("jira-users");
        this.verifyUserExistsInCrowd(JIRA_USER_USERNAME, JIRA_USER_FIRSTNAME_UPDATED, JIRA_USER_LASTNAME_UPDATED, JIRA_USER_EMAIL_UPDATED, "jira-users");
    }

    private void _testAddJiraUserGroupMembership() {
        this.gotoBrowseUsers();
        this.clickLink(JIRA_USER_USERNAME);
        this.clickLink("editgroups_link");
        this.assertTextPresent("Edit User Groups");
        this.assertSelectOptionsPresent("groupsToJoin", new String[]{"jira-administrators", "jira-developers", "crowd-administrators"});
        this.assertSelectOptionsPresent("groupsToLeave", new String[]{"jira-users"});
        this.setWorkingForm("jiraform");
        this.selectOptionByValue("groupsToJoin", "jira-developers");
        this.submit("join");
        this.assertSelectOptionsPresent("groupsToJoin", new String[]{"jira-administrators", "crowd-administrators"});
        this.assertSelectOptionsPresent("groupsToLeave", new String[]{"jira-users", "jira-developers"});
        this.verifyUserExistsInCrowd(JIRA_USER_USERNAME, JIRA_USER_FIRSTNAME_UPDATED, JIRA_USER_LASTNAME_UPDATED, JIRA_USER_EMAIL_UPDATED, "jira-users", "jira-developers");
    }

    private void _testRemoveJiraUserGroupMembership() {
        this.gotoBrowseUsers();
        this.clickLink(JIRA_USER_USERNAME);
        this.clickLink("editgroups_link");
        this.assertTextPresent("Edit User Groups");
        this.assertSelectOptionsPresent("groupsToJoin", new String[]{"jira-administrators", "crowd-administrators"});
        this.assertSelectOptionsPresent("groupsToLeave", new String[]{"jira-users", "jira-developers"});
        this.setWorkingForm("jiraform");
        this.selectOptionByValue("groupsToLeave", "jira-developers");
        this.submit("leave");
        this.assertSelectOptionsPresent("groupsToJoin", new String[]{"jira-administrators", "jira-developers", "crowd-administrators"});
        this.assertSelectOptionsPresent("groupsToLeave", new String[]{"jira-users"});
        this.verifyUserExistsInCrowd(JIRA_USER_USERNAME, JIRA_USER_FIRSTNAME_UPDATED, JIRA_USER_LASTNAME_UPDATED, JIRA_USER_EMAIL_UPDATED, "jira-users");
    }

    private void _testDeleteJiraUser() {
        this.gotoBrowseUsers();
        this.clickLink("deleteuser_link_jira-user");
        this.assertTextPresent("Delete User: jira-user");
        this.setWorkingForm("jiraform");
        this.submit();
        this.assertTextPresent("User Browser");
        this.assertTextNotInTable("user_browser_table", new String[]{JIRA_USER_USERNAME});
        this.verifyUserDoesNotExistInCrowd(JIRA_USER_USERNAME, JIRA_USER_FIRSTNAME_UPDATED, JIRA_USER_LASTNAME_UPDATED, JIRA_USER_EMAIL_UPDATED, new String[0]);
    }
}

