/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.applications.jira;

import com.atlassian.crowd.acceptance.tests.ApplicationAcceptanceTestCase;
import java.util.ResourceBundle;
import junit.framework.AssertionFailedError;
import org.apache.log4j.Logger;

public class JiraAcceptanceTestCase
extends ApplicationAcceptanceTestCase {
    protected static final String JIRA_ADMIN_USERNAME = "jira-admin";
    protected static final String JIRA_ADMIN_PASSWORD = "password";
    protected static final String JIRA_ADMIN_EMAIL = "jiraadmin@example.com";
    protected static final String JIRA_ADMIN_FIRSTNAME = "Jira";
    protected static final String JIRA_ADMIN_LASTNAME = "Administrator";
    protected static final String JIRA_ADMIN_FULLNAME = "Jira Administrator";
    protected static final String JIRA_TEST_USERNAME = "test";
    protected static final String JIRA_TEST_PASSWORD = "password";
    protected static final String JIRA_TEST_EMAIL = "test@example.com";
    protected static final String JIRA_TEST_FIRSTNAME = "Test";
    protected static final String JIRA_TEST_LASTNAME = "User";
    protected static final String JIRA_TEST_FULLNAME = "Test User";
    protected static final String JIRA_ADMINISTRATORS_GROUP = "jira-administrators";
    protected static final String JIRA_DEVELOPERS_GROUP = "jira-developers";
    protected static final String JIRA_USERS_GROUP = "jira-users";
    protected final Logger logger = Logger.getLogger(((Object)((Object)this)).getClass());
    protected static final String UNLIMITED_LICENSE_KEY = "AAABPQ0ODAoPeNptkU1vwjAMhu/5FZF2LgowJECqNNaGqVNLWVt22sULZgSlKUpSNv79Sj8kNO0YO\nX6e1/ZDcaxpKhxlc8qmy9njcjqnQVjQCWMLEqIVRp6drLT/GmUrutNKltLhnu4sGvuxpEFVlmiEB\nEVjKVBbJIFBuLWE4NC/cbwx89icBJV2INwGSvRPtXVSP4FTYK0EPRJVSU7SwKin8L1stXxT8GybR\nTkf+nkCUv0P4BdQdev2D6CaKPfE4nrG1h2kScKzIFrFXb1hygv6ztRIVPf3vRnuRpmQRqYdatAC+\nc9Zmms/1Yz1U6XmC7S0nXU1xKF5dXDfYJDmV+uwtJ1qU5efaNJDuz3fG5MczQVNFPrPiyDzkngXe\nevt+M17SdZT0gdvqnEUDq+7FPVwDbKtjTiCxb8r/wWJZKNbMCwCFBgUYwgWHGNYRpjIKqbRxPD4h\nP1SAhRzYHNcg7c9QxgHkDmIAYxORN1bYw==X02fr";
    private ResourceBundle i18n;

    protected void setUp() throws Exception {
        super.setUp();
        this.setScriptingEnabled(false);
    }

    protected String getResourceBundleName() {
        return null;
    }

    protected String getApplicationName() {
        return "jira";
    }

    protected String getLocalTestPropertiesFileName() {
        return "localtest.properties";
    }

    protected void useJira() {
        this.useApp();
    }

    protected String loginToJira(String username, String password) {
        this.logoutFromJira();
        this.gotoPage("/login.jsp");
        this.setWorkingForm("login-form");
        this.setTextField("os_username", username);
        this.setTextField("os_password", password);
        this.submit();
        return this.getCurrentlyLoggedInJiraUserFullName();
    }

    protected void adminLoginToJira() {
        this.loginToJira(JIRA_ADMIN_USERNAME, "password");
        this.assertTextPresent(JIRA_ADMIN_FULLNAME);
    }

    protected void logoutFromJira() {
        this.gotoPage("/secure/Dashboard.jspa");
        try {
            this.assertTextNotPresent("Log In");
        }
        catch (AssertionFailedError e) {
            return;
        }
        this.clickLink("log_out");
        this.assertTextPresent("logged out");
    }

    protected void gotoBrowseUsers() {
        this.gotoPage("/secure/admin/user/UserBrowser.jspa");
    }

    protected void gotoBrowseGroups() {
        this.gotoPage("/secure/admin/user/GroupBrowser.jspa");
    }

    protected void gotoGlobalPermissions() {
        this.gotoPage("/secure/admin/jira/GlobalPermissions!default.jspa");
    }

    protected String getCurrentlyLoggedInJiraUserFullName() {
        this.gotoPage("/secure/Dashboard.jspa");
        try {
            return this.getElementTextByXPath("//*[@id=\"header-details-user\"]/a[@href=\"/jira/secure/ViewProfile.jspa\"]");
        }
        catch (AssertionFailedError e) {
            return null;
        }
    }

    public void restoreCrowdFromXMLNoSync(String xmlFilename) {
        super.restoreCrowdFromXML(xmlFilename);
    }

    public void restoreCrowdFromXML(String xmlFilename) {
        super.restoreCrowdFromXML(xmlFilename);
        this.synchroniseJIRAWithCrowd();
    }

    protected void synchroniseJIRAWithCrowd() {
        this.gotoPage("/plugins/servlet/embedded-crowd/directories/list");
        if (!this.isTextPresent("Synchronising")) {
            this.clickLinkWithText("Synchronise");
        }
        long startTime = System.currentTimeMillis();
        while (!this.isTextPresent("Synchronise") && System.currentTimeMillis() < startTime + 60000L) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            this.gotoPage("/plugins/servlet/embedded-crowd/directories/list");
        }
        this.assertTextPresent("Last synchronised at");
    }
}

