/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.applications.demo;

import com.atlassian.crowd.acceptance.tests.applications.demo.DemoAcceptanceTestCase;

public class SingleSignOnTest
extends DemoAcceptanceTestCase {
    public void setUp() throws Exception {
        super.setUp();
        this.restoreCrowdFromXML("singlesignontest.xml");
        this.logoutFromCrowd();
        this.logoutFromDemo();
    }

    public void testLoginToCrowdConsequentlyLoggedInToDemo() {
        this.log("Running testLoginToCrowdConsequentlyLoggedInToDemo");
        this.logoutFromCrowd();
        this.logoutFromDemo();
        String crowdUser = this.loginToCrowd("admin", "admin");
        SingleSignOnTest.assertNotNull((Object)crowdUser);
        String demoUser = this.getCurrentlyLoggedInDemoUserFullName();
        SingleSignOnTest.assertEquals((String)crowdUser, (String)demoUser);
        crowdUser = this.getCurrentlyLoggedInCrowdUserFullName();
        SingleSignOnTest.assertEquals((String)crowdUser, (String)demoUser);
    }

    public void testLoginToDemoConsequentlyLoggedInToCrowd() {
        this.log("Running testLoginToDemoConsequentlyLoggedInToCrowd");
        this.logoutFromCrowd();
        this.logoutFromDemo();
        String demoUser = this.loginToDemo("admin", "admin");
        SingleSignOnTest.assertNotNull((Object)demoUser);
        String crowdUser = this.getCurrentlyLoggedInCrowdUserFullName();
        SingleSignOnTest.assertEquals((String)demoUser, (String)crowdUser);
        demoUser = this.getCurrentlyLoggedInDemoUserFullName();
        SingleSignOnTest.assertEquals((String)demoUser, (String)crowdUser);
    }

    public void testLogoutOfCrowdConsequentlyLoggedOutOfDemo() {
        this.log("Running testLogoutOfCrowdConsequentlyLoggedOutOfDemo");
        String crowdUser = this.loginToCrowd("admin", "admin");
        SingleSignOnTest.assertNotNull((Object)crowdUser);
        String demoUser = this.getCurrentlyLoggedInDemoUserFullName();
        SingleSignOnTest.assertNotNull((Object)demoUser);
        this.logoutFromCrowd();
        demoUser = this.getCurrentlyLoggedInDemoUserFullName();
        SingleSignOnTest.assertNull((Object)demoUser);
    }

    public void testLogoutOfDemoConsequentlyLoggedOutOfCrowd() {
        this.log("Running testLogoutOfDemoConsequentlyLoggedOutOfCrowd");
        String crowdUser = this.loginToCrowd("admin", "admin");
        SingleSignOnTest.assertNotNull((Object)crowdUser);
        String demoUser = this.getCurrentlyLoggedInDemoUserFullName();
        SingleSignOnTest.assertNotNull((Object)demoUser);
        this.logoutFromDemo();
        crowdUser = this.getCurrentlyLoggedInCrowdUserFullName();
        SingleSignOnTest.assertNull((Object)crowdUser);
    }

    public void testSwitchUserInCrowdConsequentlySwitchesUserInDemo() {
        this.log("Running testSwitchUserInCrowdConsequentlySwitchesUserInDemo");
        String crowdUser = this.loginToCrowd("admin", "admin");
        SingleSignOnTest.assertNotNull((Object)crowdUser);
        String demoUser = this.getCurrentlyLoggedInDemoUserFullName();
        SingleSignOnTest.assertNotNull((Object)demoUser);
        this.logoutFromCrowd();
        String newCrowdUser = this.loginToCrowd("user", "password");
        SingleSignOnTest.assertTrue((!newCrowdUser.equals(crowdUser) ? 1 : 0) != 0);
        String newDemoUser = this.getCurrentlyLoggedInDemoUserFullName();
        SingleSignOnTest.assertEquals((String)newCrowdUser, (String)newDemoUser);
    }

    public void testSwitchUserInDemoConsequentlySwitchesUserInCrowd() {
        this.log("Running testSwitchUserInDemoConsequentlySwitchesUserInCrowd");
        String crowdUser = this.loginToCrowd("admin", "admin");
        SingleSignOnTest.assertNotNull((Object)crowdUser);
        String demoUser = this.getCurrentlyLoggedInDemoUserFullName();
        SingleSignOnTest.assertNotNull((Object)demoUser);
        this.logoutFromDemo();
        String newDemoUser = this.loginToDemo("user", "password");
        SingleSignOnTest.assertTrue((!newDemoUser.equals(demoUser) ? 1 : 0) != 0);
        String newCrowdUser = this.getCurrentlyLoggedInCrowdUserFullName();
        SingleSignOnTest.assertEquals((String)newCrowdUser, (String)newDemoUser);
    }

    public void testLoginToDemoConsequentlyLoggedInToCrowd_unauthorisedFailure() {
        this.log("Running testLoginToDemoConsequentlyLoggedInToCrowd_unauthorisedFailure");
        this.logoutFromCrowd();
        this.logoutFromDemo();
        String demoUser = this.loginToDemo("demo", "password");
        SingleSignOnTest.assertNotNull((Object)demoUser);
        String crowdUser = this.getCurrentlyLoggedInCrowdUserFullName();
        SingleSignOnTest.assertNull((Object)crowdUser);
        String currentDemoUser = this.getCurrentlyLoggedInDemoUserFullName();
        SingleSignOnTest.assertEquals((String)demoUser, (String)currentDemoUser);
    }

    public void testLoginToCrowdConsequentlyLoggedInToDemo_unauthorisedFailure() {
        this.log("Running testLoginToCrowdConsequentlyLoggedInToDemo_unauthorisedFailure");
        this.logoutFromCrowd();
        this.logoutFromDemo();
        String crowdUser = this.loginToCrowd("immutable", "password");
        SingleSignOnTest.assertNotNull((Object)crowdUser);
        String demoUser = this.getCurrentlyLoggedInDemoUserFullName();
        SingleSignOnTest.assertNull((Object)demoUser);
        String currentCrowdUser = this.getCurrentlyLoggedInCrowdUserFullName();
        SingleSignOnTest.assertEquals((String)crowdUser, (String)currentCrowdUser);
    }

    public void testSwitchUserInCrowdConsequentlySwitchesUserInDemo_unauthorisedFailure() {
        this.log("Running testSwitchUserInCrowdConsequentlySwitchesUserInDemo_unauthorisedFailure");
        String crowdUser = this.loginToCrowd("admin", "admin");
        SingleSignOnTest.assertNotNull((Object)crowdUser);
        String demoUser = this.getCurrentlyLoggedInDemoUserFullName();
        SingleSignOnTest.assertNotNull((Object)demoUser);
        this.logoutFromCrowd();
        String newCrowdUser = this.loginToCrowd("immutable", "password");
        SingleSignOnTest.assertTrue((!newCrowdUser.equals(crowdUser) ? 1 : 0) != 0);
        String newDemoUser = this.getCurrentlyLoggedInDemoUserFullName();
        SingleSignOnTest.assertNull((Object)newDemoUser);
    }

    public void testSwitchUserInDemoConsequentlySwitchesUserInCrowd_unauthorisedFailure() {
        this.log("Running testSwitchUserInDemoConsequentlySwitchesUserInCrowd_unauthorisedFailure");
        String crowdUser = this.loginToCrowd("admin", "admin");
        SingleSignOnTest.assertNotNull((Object)crowdUser);
        String demoUser = this.getCurrentlyLoggedInDemoUserFullName();
        SingleSignOnTest.assertNotNull((Object)demoUser);
        this.logoutFromDemo();
        String newDemoUser = this.loginToDemo("demo", "password");
        SingleSignOnTest.assertTrue((!newDemoUser.equals(demoUser) ? 1 : 0) != 0);
        String newCrowdUser = this.getCurrentlyLoggedInCrowdUserFullName();
        SingleSignOnTest.assertNull((Object)newCrowdUser);
    }
}

