/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.applications.crowd;

import com.atlassian.core.util.collection.EasyList;
import com.atlassian.crowd.acceptance.tests.applications.crowd.CrowdAcceptanceTestCase;
import com.atlassian.crowd.acceptance.utils.DbCachingTestHelper;

public class AutoGroupAdderTest
extends CrowdAcceptanceTestCase {
    private static final String CROWD_DIRECTORY_NAME = "remotecrowd";
    private static final long MAX_WAIT_TIME_MS = 10000L;

    public void setUp() throws Exception {
        super.setUp();
        this._loginAdminUser();
        this.restoreCrowdFromXML("autogroupaddertest.xml");
    }

    public void testAutoAddWithInternalDirectory() {
        this.log("Running testAutoAddWithInternalDirectory");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText("Crowd Local");
        this.clickLink("internal-options");
        this.assertTextPresent("group1");
        this.assertTextPresent("group2");
        this.assertTextPresent("group3");
        this.gotoAddPrincipal();
        this.setTextField("email", "testuser@atlassian.com");
        this.setTextField("name", "testuser");
        this.setTextField("password", "password");
        this.setTextField("passwordConfirm", "password");
        this.setTextField("firstname", "Test");
        this.setTextField("lastname", "User");
        this.selectOption("directoryID", "Crowd Local");
        this.submit();
        this.assertKeyPresent("menu.viewprincipal.label");
        this.assertTextPresent("testuser");
        this.clickLink("user-groups-tab");
        this.assertTableNotPresent("groupsTable");
        this._loginAsUser("testuser", "password");
        this.gotoPage("/console/user/viewprofile.action");
        this.clickLink("view-groups");
        this.assertTextPresent(this.getText("user.console.groups.text"));
        this.assertTextPresent("group1");
        this.assertTextPresent("group2");
        this.assertTextPresent("group3");
    }

    public void testAutoAddWithDelegatedDirectory() {
        this.log("Running testAutoAddWithDelegatedDirectory");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText("delg");
        this.clickLink("delegated-options");
        this.assertTextPresent("test1");
        this.gotoAddPrincipal();
        this.setTextField("email", "jdoe@testingarea.org");
        this.setTextField("name", "jdoe");
        this.setTextField("password", "jdoe");
        this.setTextField("passwordConfirm", "jdoe");
        this.setTextField("firstname", "John");
        this.setTextField("lastname", "Doe");
        this.selectOption("directoryID", "delg");
        this.submit();
        this.assertKeyPresent("menu.viewprincipal.label");
        this.assertTextPresent("jdoe");
        this.clickLink("user-groups-tab");
        this.assertTableNotPresent("groupsTable");
        this.increaseDirectoryPriorityTo("crowd", "delg", 2);
        this._loginAsUser("jdoe", "jdoe");
        this.gotoPage("/console/user/viewprofile.action");
        this.clickLink("view-groups");
        this.assertTextPresent(this.getText("user.console.groups.text"));
        this.assertTextPresent("test1");
    }

    public void testAutoAddWithLDAPDirectory() {
        this.log("Running testAutoAddWithLDAPDirectory");
        DbCachingTestHelper.synchroniseDirectory(this.tester, "ldap", 10000L);
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText("ldap");
        this.clickLink("connector-options");
        this.assertTextPresent("groupA");
        this.assertTextPresent("groupB");
        this.assertTextPresent("groupC");
        this.gotoAddPrincipal();
        this.setTextField("email", "testuser@atlassian.com");
        this.setTextField("name", "testuser");
        this.setTextField("password", "password");
        this.setTextField("passwordConfirm", "password");
        this.setTextField("firstname", "Test");
        this.setTextField("lastname", "User");
        this.selectOption("directoryID", "ldap");
        this.submit();
        this.assertKeyPresent("menu.viewprincipal.label");
        this.assertTextPresent("testuser");
        this.clickLink("user-groups-tab");
        this.assertTableNotPresent("groupsTable");
        this.increaseDirectoryPriorityTo("crowd", "ldap", 2);
        this._loginAsUser("testuser", "password");
        this.gotoPage("/console/user/viewprofile.action");
        this.clickLink("view-groups");
        this.assertTextPresent(this.getText("user.console.groups.text"));
        this.assertTextPresent("groupA");
        this.assertTextPresent("groupB");
        this.assertTextPresent("groupC");
        this._loginAdminUser();
        this.gotoViewPrincipal("testuser", "ldap");
        this.clickLink("remove-principal");
        this.submit();
        this.assertTextNotPresent("testuser");
    }

    public void testAutoAddWithRemoteCrowdDirectory() {
        this.log("Running testAutoAddWithRemoteCrowdDirectory");
        this.updateRemoteCrowdUrl(CROWD_DIRECTORY_NAME);
        DbCachingTestHelper.synchroniseDirectory(this.tester, CROWD_DIRECTORY_NAME, 10000L);
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(CROWD_DIRECTORY_NAME);
        this.clickLink("crowd-options");
        this.assertTextPresent("group1");
        this.assertTextPresent("group2");
        this.assertTextPresent("group3");
        this.gotoAddPrincipal();
        this.setTextField("email", "testuser@atlassian.com");
        this.setTextField("name", "testuser");
        this.setTextField("password", "password");
        this.setTextField("passwordConfirm", "password");
        this.setTextField("firstname", "Test");
        this.setTextField("lastname", "User");
        this.selectOption("directoryID", CROWD_DIRECTORY_NAME);
        this.submit();
        this.assertKeyPresent("menu.viewprincipal.label");
        this.assertTextPresent("testuser");
        this.clickLink("user-groups-tab");
        this.assertTableNotPresent("groupsTable");
        this.increaseDirectoryPriorityTo("crowd", CROWD_DIRECTORY_NAME, 1);
        this._loginAsUser("testuser", "password");
        this.gotoPage("/console/user/viewprofile.action");
        this.clickLink("view-groups");
        this.assertTextPresent(this.getText("user.console.groups.text"));
        this.assertTextPresent("group1");
        this.assertTextPresent("group2");
        this.assertTextPresent("group3");
        this._loginAdminUser();
        this.gotoViewPrincipal("testuser", CROWD_DIRECTORY_NAME);
        this.clickLink("remove-principal");
        this.submit();
        this.assertTextNotPresent("testuser");
    }

    public void testAutoAddWithRemoteCrowdDirectoryUsingDelegatedDirectory() {
        this.log("Running testAutoAddWithRemoteCrowdDirectoryUsingDelegatedDirectory");
        this.updateRemoteCrowdUrl("Remote Crowd Directory - Delegated");
        DbCachingTestHelper.synchroniseDirectory(this.tester, "Remote Crowd Directory - Delegated", 10000L);
        this.increaseDirectoryPriorityTo("crowd", "Remote Crowd Directory - Delegated", 2);
        this._loginAsUser("jdoe", "jdoe");
        this.gotoPage("/console/user/viewprofile.action");
        this.clickLink("view-groups");
        this.assertTextPresent(this.getText("user.console.groups.text"));
        this.assertTextPresent("test1");
    }

    public void testAutoAddWithRemoteCrowdDirectoryUsingDelegatedDirectory_NoGroup() {
        this.log("Running testAutoAddWithRemoteCrowdDirectoryUsingDelegatedDirectory_NoGroup");
        this.updateRemoteCrowdUrl("Remote Crowd Directory - Delegated");
        this.increaseDirectoryPriorityTo("crowd", "Remote Crowd Directory - Delegated", 2);
        this._loginAsUser("jdoe", "jdoe");
        this.gotoPage("/console/user/viewprofile.action");
        this.clickLink("view-groups");
        this.assertTextPresent(this.getText("user.console.nogroups.text"));
    }

    public void testAutoAddOnlyAddingGroupsOnce() throws Exception {
        this.log("Running testAutoAddOnlyAddingGroupsOnce");
        this.setScriptingEnabled(true);
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText("Crowd Local");
        this.clickLink("internal-options");
        this.clickLinkWithText("remove", 2);
        this.assertTextPresent("group1");
        this.assertTextPresent("group2");
        this.assertTextNotPresent("group3");
        this.gotoAddPrincipal();
        this.setTextField("email", "testuser@atlassian.com");
        this.setTextField("name", "testuser");
        this.setTextField("password", "password");
        this.setTextField("passwordConfirm", "password");
        this.setTextField("firstname", "Test");
        this.setTextField("lastname", "User");
        this.selectOption("directoryID", "Crowd Local");
        this.submit();
        this.assertKeyPresent("menu.viewprincipal.label");
        this.assertTextPresent("testuser");
        this.clickLink("user-groups-tab");
        this.assertTableNotPresent("groupsTable");
        this._loginAsUser("testuser", "password");
        this.gotoPage("/console/user/viewprofile.action");
        this.clickLink("view-groups");
        this.assertTextPresent(this.getText("user.console.groups.text"));
        this.assertTextPresent("group1");
        this.assertTextPresent("group2");
        this.assertTextNotPresent("group3");
        this._loginAdminUser();
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText("Crowd Local");
        this.clickLink("internal-options");
        this.clickButton("addGroups");
        this.waitForText(this.getText("picker.addgroups.generic.message"));
        this.setTextField("searchString", "group3");
        this.submit("searchButton");
        this.waitForText("Description");
        this.setWorkingForm("selectentities");
        this.checkCheckbox("selectedEntityNames");
        this.clickButtonWithText(this.getText("picker.addselected.groups.label"));
        this.assertTextPresent("group3 (");
        this._loginAsUser("testuser", "password");
        this.gotoPage("/console/user/viewprofile.action");
        this.clickLink("view-groups");
        this.assertTextPresent(this.getText("user.console.groups.text"));
        this.assertTextPresent("group1");
        this.assertTextPresent("group2");
        this.assertTextNotPresent("group3");
        this.setScriptingEnabled(false);
    }

    private void increaseDirectoryPriorityTo(String application, String directoryName, int order) {
        this.gotoViewApplication(application);
        this.clickLink("application-directories");
        this.assertTextInTable("directoriesTable", directoryName);
        while (!this.tester.getTestingEngine().hasElementByXPath("id('directoriesTable')/tbody/tr[" + (order + 1) + "][contains(.,'" + directoryName + "')]")) {
            this.clickElementByXPath("id('directoriesTable')/tbody/tr[contains(.,'" + directoryName + "')]/td/a[@name='Move Up']");
        }
    }

    private void updateRemoteCrowdUrl(String directoryName) {
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(directoryName);
        this.assertKeyPresent("menu.viewdirectory.label", EasyList.build((Object)directoryName));
        this.clickLink("crowd-connectiondetails");
        this.setTextField("url", this.getBaseUrl());
        this.submit();
    }
}

