/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.applications.crowd;

import com.atlassian.crowd.acceptance.tests.applications.crowd.CrowdAcceptanceTestCase;

public class AddRoleTest
extends CrowdAcceptanceTestCase {
    private static final String CROWD_TEST_ROLE = "crowd test role";

    public void setUp() throws Exception {
        super.setUp();
        this._loginAdminUser();
    }

    public void testAddRoleWithNoDetails() {
        this.log("Running testAddRoleWithNoDetails");
        this.gotoAddRole();
        this.setTextField("name", "");
        this.setTextField("description", "");
        this.selectOptionByValue("directoryID", "-1");
        this.submit();
        this.assertKeyPresent("role.name.invalid");
        this.assertKeyPresent("role.directory.invalid");
    }

    public void testAddRoleThatAlreadyExists() {
        this.log("Running testAddRoleThatAlreadyExists");
        this.addRole("crowd-admins", "Crowd Administrators", "Test Internal Directory");
        this.gotoAddRole();
        this.setTextField("name", "crowd-admins");
        this.setTextField("description", "Crowd Administrators");
        this.selectOption("directoryID", "Test Internal Directory");
        this.submit();
        this.assertKeyPresent("invalid.namealreadyexist");
    }

    public void testAddRoleToInternalDirectory() {
        this.log("Running testAddRoleToInternalDirectory");
        this.gotoAddRole();
        this.setTextField("name", CROWD_TEST_ROLE);
        this.setTextField("description", "Crowd Acceptance Test Role");
        this.selectOption("directoryID", "Test Internal Directory");
        this.submit();
        this.assertKeyPresent("menu.viewrole.label");
        this.assertTextPresent(CROWD_TEST_ROLE);
    }
}

