/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.applications.confluence;

import com.atlassian.crowd.acceptance.tests.applications.confluence.ConfluenceAcceptanceTestCase;

public class ConfluenceMixedCaseUserTest
extends ConfluenceAcceptanceTestCase {
    protected static final String CONFLUENCE_USER_USERNAME = "MixedCaseUser";
    protected static final String CONFLUENCE_USER_PASSWORD = "password";
    protected static final String CONFLUENCE_USER_FIRSTNAME = "Mixed";
    protected static final String CONFLUENCE_USER_LASTNAME = "Case";
    protected static final String CONFLUENCE_USER_FULLNAME = "Mixed Case";
    protected static final String CONFLUENCE_USER_EMAIL = "mixedCase@example.com";
    protected static final String CONFLUENCE_USER_FIRSTNAME_UPDATED = "MixedCase";
    protected static final String CONFLUENCE_USER_LASTNAME_UPDATED = "User";
    protected static final String CONFLUENCE_USER_FULLNAME_UPDATED = "MixedCase User";
    protected static final String CONFLUENCE_USER_EMAIL_UPDATED = "mixedCase@updated.com";

    protected void setUp() throws Exception {
        super.setUp();
        this.logoutFromCrowd();
        this.adminLoginToConfluence();
    }

    public void testConfluenceUserCrud() {
        this._testUpdateConfluenceUser();
        this._testAddConfluenceUserGroupMembership();
        this._testRemoveConfluenceUserGroupMembership();
        this._testDeleteConfluenceUser();
    }

    private void _testUpdateConfluenceUser() {
        this.verifyUserExistsInCrowd(CONFLUENCE_USER_USERNAME, CONFLUENCE_USER_FIRSTNAME, CONFLUENCE_USER_LASTNAME, CONFLUENCE_USER_EMAIL, "confluence-users");
        this.gotoBrowseUsers();
        this.clickLinkWithText("Show all users");
        this.clickUsernameLink(CONFLUENCE_USER_USERNAME);
        this.clickLinkWithText("Edit Details");
        this.setWorkingForm("editUser");
        this.setTextField("fullName", CONFLUENCE_USER_FULLNAME_UPDATED);
        this.setTextField("email", CONFLUENCE_USER_EMAIL_UPDATED);
        this.submit();
        this.assertTextPresent("User: MixedCaseUser");
        this.assertTextPresent(CONFLUENCE_USER_USERNAME);
        this.assertTextPresent(CONFLUENCE_USER_FULLNAME_UPDATED);
        this.assertTextPresent(CONFLUENCE_USER_EMAIL_UPDATED);
        this.assertTextPresent("confluence-users");
        this.verifyUserExistsInCrowd(CONFLUENCE_USER_USERNAME, CONFLUENCE_USER_FIRSTNAME_UPDATED, CONFLUENCE_USER_LASTNAME_UPDATED, CONFLUENCE_USER_EMAIL_UPDATED, "confluence-users");
    }

    private void _testAddConfluenceUserGroupMembership() {
        this.gotoBrowseUsers();
        this.clickLinkWithText("Show all users");
        this.clickUsernameLink(CONFLUENCE_USER_USERNAME);
        this.clickLinkWithText("Edit Groups");
        this.setWorkingForm("editusergroupsform");
        this.assertCheckboxSelected("newGroups", "confluence-users");
        this.assertCheckboxNotSelected("newGroups", "confluence-administrators");
        this.assertCheckboxNotSelected("newGroups", "crowd-administrators");
        this.checkCheckbox("newGroups", "confluence-administrators");
        this.submit("save");
        this.clickLinkWithText("Edit Groups");
        this.setWorkingForm("editusergroupsform");
        this.assertCheckboxNotSelected("newGroups", "crowd-administrators");
        this.assertCheckboxSelected("newGroups", "confluence-users");
        this.assertCheckboxSelected("newGroups", "confluence-administrators");
        this.verifyUserExistsInCrowd(CONFLUENCE_USER_USERNAME, CONFLUENCE_USER_FIRSTNAME_UPDATED, CONFLUENCE_USER_LASTNAME_UPDATED, CONFLUENCE_USER_EMAIL_UPDATED, "confluence-administrators", "confluence-users");
    }

    private void _testRemoveConfluenceUserGroupMembership() {
        this.gotoBrowseUsers();
        this.clickLinkWithText("Show all users");
        this.clickUsernameLink(CONFLUENCE_USER_USERNAME);
        this.clickLinkWithText("Edit Groups");
        this.setWorkingForm("editusergroupsform");
        this.assertCheckboxNotSelected("newGroups", "crowd-administrators");
        this.assertCheckboxSelected("newGroups", "confluence-administrators");
        this.assertCheckboxSelected("newGroups", "confluence-users");
        this.uncheckCheckbox("newGroups", "confluence-administrators");
        this.submit("save");
        this.clickLinkWithText("Edit Groups");
        this.setWorkingForm("editusergroupsform");
        this.assertCheckboxNotSelected("newGroups", "crowd-administrators");
        this.assertCheckboxNotSelected("newGroups", "confluence-administrators");
        this.assertCheckboxSelected("newGroups", "confluence-users");
        this.verifyUserExistsInCrowd(CONFLUENCE_USER_USERNAME, CONFLUENCE_USER_FIRSTNAME_UPDATED, CONFLUENCE_USER_LASTNAME_UPDATED, CONFLUENCE_USER_EMAIL_UPDATED, "confluence-users");
    }

    private void _testDeleteConfluenceUser() {
        this.gotoBrowseUsers();
        this.clickLinkWithText("Show all users");
        this.clickUsernameLink(CONFLUENCE_USER_USERNAME);
        this.clickLinkWithText("Remove");
        this.assertTextPresent("Remove User");
        this.setWorkingForm("removeuserform");
        this.submit();
        this.assertTextPresent("Manage Users");
        this.clickLinkWithText("Show all users");
        this.assertTextNotPresent(CONFLUENCE_USER_USERNAME);
        this.assertTextNotPresent(CONFLUENCE_USER_FULLNAME_UPDATED);
        this.assertTextNotPresent(CONFLUENCE_USER_EMAIL_UPDATED);
        this.verifyUserDoesNotExistInCrowd(CONFLUENCE_USER_USERNAME, CONFLUENCE_USER_FIRSTNAME_UPDATED, CONFLUENCE_USER_LASTNAME_UPDATED, CONFLUENCE_USER_EMAIL_UPDATED, new String[0]);
    }
}

