/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.applications.bamboo;

import com.atlassian.crowd.acceptance.tests.applications.bamboo.BambooAcceptanceTestCase;

public class SetupBambooTest
extends BambooAcceptanceTestCase {
    public void testSetup() throws Exception {
        this.restoreCrowdFromXML("crowdwithbamboo.xml");
        this.setScriptingEnabled(true);
        this._setupLicense();
        this.waitForText("Set Up Administrator User");
        this._setupAdminUser();
        this.waitForText("Welcome to Bamboo");
        this.setScriptingEnabled(false);
        this.verifyUserExistsInCrowd("bamboo-admin-user", "Bamboo", "Administrator", "bambooadmin@example.com", "bamboo-admin");
    }

    private void _setupLicense() {
        this.beginAt("/");
        this.assertTitleEquals("Bamboo Setup Wizard - Atlassian Bamboo");
        this.assertTextPresent("License Key:");
        this.setWorkingForm("validateLicense");
        this.setTextField("licenseString", "QONmvUrfDmCQVPgjriJkvAnJoMmCNoXgwTKkikTeEaRimkS\nmj2Kvx2S7BG9NQlaN1RkcZbB2L0LhczvdiOmzsV9HL9Cvxy\nrNnxWnnrQMpPRqOPnmwTPQOrqoQMOoMpRSUwvxtVWvuTqvp\nUUormuvppsmmmmmUUormuvppsmmmmmUU1qiXppfXk");
        this.submit("expressInstall");
    }

    private void _setupAdminUser() {
        this.assertTitleEquals("Set Up Administrator User - Atlassian Bamboo");
        this.assertTextPresent("Administrator User Details");
        this.setWorkingForm("performSetupAdminUser");
        this.setTextField("username", "bamboo-admin-user");
        this.setTextField("password", "password");
        this.setTextField("confirmPassword", "password");
        this.setTextField("fullName", "Bamboo Administrator");
        this.setTextField("email", "bambooadmin@example.com");
        this.submit();
    }
}

