/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.applications.bamboo;

import com.atlassian.crowd.acceptance.tests.applications.bamboo.BambooAcceptanceTestCase;

public class BambooUserBrowserTest
extends BambooAcceptanceTestCase {
    protected void setUp() throws Exception {
        super.setUp();
        this.adminLoginToBamboo();
    }

    public void testBrowseUsers() {
        this.gotoBrowseUsers();
        this.assertTextInTable("existingUsers", new String[]{"admin", "admin@example.com", "Super User", "bamboo-admin \n bamboo-users \n crowd-administrators \n", "", "Edit | Delete"});
        this.assertTextInTable("existingUsers", new String[]{"bamboo-admin-user", "bambooadmin@example.com", "Bamboo Administrator", "bamboo-admin \n", "", "Edit"});
        this.assertTextInTable("existingUsers", new String[]{"MixedCaseUser", "mixedCase@example.com", "Mixed Case", "", "", "Edit | Delete"});
    }

    public void testSearchUsersViaEmail() {
        this.gotoBrowseUsers();
        this.setWorkingForm("searchUsers");
        this.setTextField("emailTerm", "admin");
        this.submit();
        this.assertTextInTable("existingUsers", new String[]{"admin", "admin@example.com", "Super User", "bamboo-admin \n bamboo-users \n crowd-administrators \n", "", "Edit | Delete"});
        this.assertTextInTable("existingUsers", new String[]{"bamboo-admin-user", "bambooadmin@example.com", "Bamboo Administrator", "bamboo-admin \n", "", "Edit"});
    }

    public void testSearchUsersViaEmailFullnameAndUsername() {
        this.gotoBrowseUsers();
        this.setWorkingForm("searchUsers");
        this.setTextField("emailTerm", "admin");
        this.setTextField("fullnameTerm", "Bamboo Administrator");
        this.setTextField("usernameTerm", "bamboo-admin-user");
        this.submit();
        this.assertTextInTable("existingUsers", new String[]{"bamboo-admin-user", "bambooadmin@example.com", "Bamboo Administrator", "bamboo-admin \n", "", "Edit"});
        this.assertTextNotInTable("existingUsers", new String[]{"admin", "admin@example.com", "Super User", "bamboo-admin \n bamboo-users \n crowd-administrators"});
    }

    public void testSearchNoResults() {
        this.gotoBrowseUsers();
        this.setWorkingForm("searchUsers");
        this.setTextField("emailTerm", "admin");
        this.setTextField("fullnameTerm", "Super");
        this.setTextField("usernameTerm", "bamboo");
        this.submit();
        this.assertTableRowCountEquals("existingUsers", 1);
        this.assertTextNotInTable("existingUsers", new String[]{"bamboo-admin-user", "bambooadmin@example.com", "Bamboo Administrator", "bamboo-admin \n"});
        this.assertTextNotInTable("existingUsers", new String[]{"admin", "admin@example.com", "Super User", "bamboo-admin \n bamboo-users \n crowd-administrators"});
    }
}

