/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.applications.bamboo;

import com.atlassian.crowd.acceptance.tests.applications.bamboo.BambooAcceptanceTestCase;

public class BambooGroupMutationTest
extends BambooAcceptanceTestCase {
    private static final String BAMBOO_BABOONS_GROUP = "bamboo-baboons";

    protected void setUp() throws Exception {
        super.setUp();
        this.adminLoginToBamboo();
    }

    public void testBambooGroupCrud() {
        this._testCreateBambooGroup();
        this._testAddBambooUserGroupMembership();
        this._testRemoveBambooUserGroupMembership();
        this._testDeleteBambooGroup();
    }

    private void _testCreateBambooGroup() {
        this.gotoBrowseGroups();
        this.setWorkingForm("createGroup");
        this.setTextField("groupName", BAMBOO_BABOONS_GROUP);
        this.submit();
        this.assertTextInTable("existingGroups", new String[]{"bamboo-MixedCase-group", "0", "Edit | Delete"});
        this.assertTextInTable("existingGroups", new String[]{"bamboo-admin", "2", "Edit"});
        this.assertTextInTable("existingGroups", new String[]{BAMBOO_BABOONS_GROUP, "0", "Edit | Delete"});
        this.assertTextInTable("existingGroups", new String[]{"bamboo-users", "1", "Edit | Delete"});
        this.assertTextInTable("existingGroups", new String[]{"crowd-administrators", "1", "Edit | Delete"});
        this.verifyGroupExistsInCrowd(BAMBOO_BABOONS_GROUP, new String[0]);
    }

    private void _testAddBambooUserGroupMembership() {
        this.gotoBrowseGroups();
        this.clickLink("editGroup-bamboo-baboons");
        this.setWorkingForm("updateGroup");
        this.setTextField("membersInput", "bamboo-admin-user");
        this.submit();
        this.assertTextInTable("existingGroups", new String[]{"bamboo-MixedCase-group", "0", "Edit | Delete"});
        this.assertTextInTable("existingGroups", new String[]{"bamboo-admin", "2", "Edit"});
        this.assertTextInTable("existingGroups", new String[]{BAMBOO_BABOONS_GROUP, "1", "Edit | Delete"});
        this.assertTextInTable("existingGroups", new String[]{"bamboo-users", "1", "Edit | Delete"});
        this.assertTextInTable("existingGroups", new String[]{"crowd-administrators", "1", "Edit | Delete"});
        this.verifyGroupExistsInCrowd(BAMBOO_BABOONS_GROUP, "bamboo-admin-user");
    }

    private void _testRemoveBambooUserGroupMembership() {
        this.gotoBrowseGroups();
        this.clickLink("editGroup-bamboo-baboons");
        this.setWorkingForm("updateGroup");
        this.getDialog().unselectOptions("currentMembers", new String[]{"bamboo-admin-user"});
        this.submit();
        this.assertTextInTable("existingGroups", new String[]{"bamboo-MixedCase-group", "0", "Edit | Delete"});
        this.assertTextInTable("existingGroups", new String[]{"bamboo-admin", "2", "Edit"});
        this.assertTextInTable("existingGroups", new String[]{BAMBOO_BABOONS_GROUP, "0", "Edit | Delete"});
        this.assertTextInTable("existingGroups", new String[]{"bamboo-users", "1", "Edit | Delete"});
        this.assertTextInTable("existingGroups", new String[]{"crowd-administrators", "1", "Edit | Delete"});
        this.verifyGroupExistsInCrowd(BAMBOO_BABOONS_GROUP, new String[0]);
    }

    private void _testDeleteBambooGroup() {
        this.gotoBrowseGroups();
        this.clickLink("deleteGroup-bamboo-baboons");
        this.assertTextInTable("existingGroups", new String[]{"bamboo-MixedCase-group", "0", "Edit | Delete"});
        this.assertTextInTable("existingGroups", new String[]{"bamboo-admin", "2", "Edit"});
        this.assertTextInTable("existingGroups", new String[]{"bamboo-users", "1", "Edit | Delete"});
        this.assertTextInTable("existingGroups", new String[]{"crowd-administrators", "1", "Edit | Delete"});
        this.verifyGroupDoesNotExistInCrowd(BAMBOO_BABOONS_GROUP);
    }
}

