/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.persistence.manager.token;

import com.atlassian.crowd.dao.application.ApplicationDAO;
import com.atlassian.crowd.dao.token.TokenDAO;
import com.atlassian.crowd.dao.token.TokenDAOHibernate;
import com.atlassian.crowd.dao.token.TokenDAOMemory;
import com.atlassian.crowd.embedded.spi.DirectoryDao;
import com.atlassian.crowd.exception.InvalidTokenException;
import com.atlassian.crowd.manager.property.PropertyManager;
import com.atlassian.crowd.manager.token.TokenManagerImpl;
import com.atlassian.crowd.model.token.Token;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.spring.container.ContainerContext;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.spring.container.SpringContainerContext;
import junit.framework.Assert;
import org.jmock.Mock;
import org.quartz.Scheduler;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.test.AbstractDependencyInjectionSpringContextTests;

public class TokenManagerImplTest
extends AbstractDependencyInjectionSpringContextTests {
    private TokenManagerImpl tokenManagerImpl;
    private int VOLUME_TEST_SIZE = 500;

    protected String[] getConfigLocations() {
        this.setAutowireMode(1);
        return new String[]{"classpath:/applicationContext-config.xml", "classpath:/applicationContext-CrowdDAO.xml", "classpath:/applicationContext-CrowdLDAP.xml", "classpath:/applicationContext-CrowdManagers.xml", "classpath:/applicationContext-CrowdServer.xml", "classpath:/applicationContext-CrowdEncryption.xml", "classpath:/applicationContext-CrowdUtils.xml", "classpath:/applicationContext-CrowdClient.xml"};
    }

    protected void customizeBeanFactory(DefaultListableBeanFactory beanFactory) {
        beanFactory.registerSingleton("applicationDao", new Mock(ApplicationDAO.class).proxy());
        beanFactory.registerSingleton("directoryDao", new Mock(DirectoryDao.class).proxy());
        beanFactory.registerSingleton("scheduler", new Mock(Scheduler.class).proxy());
    }

    protected void onSetUp() throws Exception {
        SpringContainerContext springContainerContext = new SpringContainerContext();
        springContainerContext.setApplicationContext((ApplicationContext)this.applicationContext);
        ContainerManager.getInstance().setContainerContext((ContainerContext)springContainerContext);
        this.tokenManagerImpl = new TokenManagerImpl(true, (TokenDAO)((TokenDAOMemory)ContainerManager.getComponent((String)"tokenDAOMemory")), (TokenDAO)((TokenDAOHibernate)ContainerManager.getComponent((String)"tokenDAOHibernate")), (PropertyManager)ContainerManager.getComponent((String)"propertyManager"), (EventPublisher)ContainerManager.getComponent((String)"eventPublisher"));
        super.onSetUp();
    }

    protected void onTearDown() throws Exception {
        ((TokenDAOMemory)ContainerManager.getComponent((String)"tokenDAOMemory")).removeAll();
        ((TokenDAOHibernate)ContainerManager.getComponent((String)"tokenDAOHibernate")).removeAll();
        this.tokenManagerImpl = null;
        super.onTearDown();
    }

    public void testAdd() throws InvalidTokenException {
        this.tokenManagerImpl.add(new Token(-1L, "my-test-token", "idhash", 12345L, "secret-key"));
    }

    public void testSwitch() {
        Assert.assertFalse((boolean)this.tokenManagerImpl.isUsingDatabaseStorage());
        this.tokenManagerImpl.switchToHibernate();
        Assert.assertTrue((boolean)this.tokenManagerImpl.isUsingDatabaseStorage());
    }

    public void testInvalidSwitch() {
        Assert.assertFalse((boolean)this.tokenManagerImpl.isUsingDatabaseStorage());
        try {
            this.tokenManagerImpl.switchToMemory();
            Assert.fail((String)"Should not have allowed switch to memory caching while in memory caching");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        Assert.assertFalse((boolean)this.tokenManagerImpl.isUsingDatabaseStorage());
    }

    public void testSwitchAfterAdd() throws InvalidTokenException {
        Assert.assertFalse((boolean)this.tokenManagerImpl.isUsingDatabaseStorage());
        this.tokenManagerImpl.add(new Token(-1L, "admin", "idhash1", 12345L, "my-test-token"));
        this.tokenManagerImpl.add(new Token(-1L, "admin2", "idhash2", 123456L, "my-test-token-2"));
        this.tokenManagerImpl.add(new Token(-1L, "admin3", "idhash3", 1234567L, "my-test-token-3"));
        TokenManagerImplTest.assertEquals((int)3, (int)this.tokenManagerImpl.search(QueryBuilder.queryFor(Token.class, (EntityDescriptor)EntityDescriptor.token()).returningAtMost(10)).size());
        this.tokenManagerImpl.switchToHibernate();
        Assert.assertTrue((boolean)this.tokenManagerImpl.isUsingDatabaseStorage());
        TokenManagerImplTest.assertEquals((int)3, (int)this.tokenManagerImpl.search(QueryBuilder.queryFor(Token.class, (EntityDescriptor)EntityDescriptor.token()).returningAtMost(10)).size());
    }

    private void addLotsOfTokens(int numTokens) throws InvalidTokenException {
        for (int i = 0; i < numTokens; ++i) {
            this.tokenManagerImpl.add(new Token(-1L, "admin-1", "idhash" + i, (long)i, "vol-token-" + i));
        }
    }

    public void testSwitchToMemoryVolumeTest() throws InvalidTokenException {
        this.tokenManagerImpl.switchToHibernate();
        Assert.assertTrue((boolean)this.tokenManagerImpl.isUsingDatabaseStorage());
        this.addLotsOfTokens(this.VOLUME_TEST_SIZE);
        TokenManagerImplTest.assertEquals((int)this.VOLUME_TEST_SIZE, (int)this.tokenManagerImpl.search(QueryBuilder.queryFor(Token.class, (EntityDescriptor)EntityDescriptor.token()).returningAtMost(1000)).size());
        TokenManagerImplTest.assertEquals((int)this.VOLUME_TEST_SIZE, (int)((TokenDAOHibernate)ContainerManager.getComponent((String)"tokenDAOHibernate")).search(QueryBuilder.queryFor(Token.class, (EntityDescriptor)EntityDescriptor.token()).returningAtMost(1000)).size());
        TokenManagerImplTest.assertEquals((int)0, (int)((TokenDAOMemory)ContainerManager.getComponent((String)"tokenDAOMemory")).search(QueryBuilder.queryFor(Token.class, (EntityDescriptor)EntityDescriptor.token()).returningAtMost(10)).size());
        long sysTimeStart = System.currentTimeMillis();
        this.tokenManagerImpl.switchToMemory();
        long sysTimeEnd = System.currentTimeMillis();
        System.out.println("Hibernate->Mem execution time: " + (sysTimeEnd - sysTimeStart) + "ms for " + this.VOLUME_TEST_SIZE + " elements.");
        TokenManagerImplTest.assertEquals((int)this.VOLUME_TEST_SIZE, (int)this.tokenManagerImpl.search(QueryBuilder.queryFor(Token.class, (EntityDescriptor)EntityDescriptor.token()).returningAtMost(1000)).size());
        TokenManagerImplTest.assertEquals((int)this.VOLUME_TEST_SIZE, (int)((TokenDAOMemory)ContainerManager.getComponent((String)"tokenDAOMemory")).search(QueryBuilder.queryFor(Token.class, (EntityDescriptor)EntityDescriptor.token()).returningAtMost(1000)).size());
        TokenManagerImplTest.assertEquals((int)0, (int)((TokenDAOHibernate)ContainerManager.getComponent((String)"tokenDAOHibernate")).search(QueryBuilder.queryFor(Token.class, (EntityDescriptor)EntityDescriptor.token()).returningAtMost(1000)).size());
    }

    public void testSwitchToHibernateVolumeTest() throws InvalidTokenException {
        Assert.assertFalse((boolean)this.tokenManagerImpl.isUsingDatabaseStorage());
        this.addLotsOfTokens(this.VOLUME_TEST_SIZE);
        TokenManagerImplTest.assertEquals((int)this.VOLUME_TEST_SIZE, (int)this.tokenManagerImpl.search(QueryBuilder.queryFor(Token.class, (EntityDescriptor)EntityDescriptor.token()).returningAtMost(1000)).size());
        TokenManagerImplTest.assertEquals((int)this.VOLUME_TEST_SIZE, (int)((TokenDAOMemory)ContainerManager.getComponent((String)"tokenDAOMemory")).search(QueryBuilder.queryFor(Token.class, (EntityDescriptor)EntityDescriptor.token()).returningAtMost(1000)).size());
        TokenManagerImplTest.assertEquals((int)0, (int)((TokenDAOHibernate)ContainerManager.getComponent((String)"tokenDAOHibernate")).search(QueryBuilder.queryFor(Token.class, (EntityDescriptor)EntityDescriptor.token()).returningAtMost(1000)).size());
        long sysTimeStart = System.currentTimeMillis();
        this.tokenManagerImpl.switchToHibernate();
        long sysTimeEnd = System.currentTimeMillis();
        System.out.println("Mem->Hibernate execution time: " + (sysTimeEnd - sysTimeStart) + "ms for " + this.VOLUME_TEST_SIZE + " elements.");
        TokenManagerImplTest.assertEquals((int)this.VOLUME_TEST_SIZE, (int)this.tokenManagerImpl.search(QueryBuilder.queryFor(Token.class, (EntityDescriptor)EntityDescriptor.token()).returningAtMost(1000)).size());
        TokenManagerImplTest.assertEquals((int)this.VOLUME_TEST_SIZE, (int)((TokenDAOHibernate)ContainerManager.getComponent((String)"tokenDAOHibernate")).search(QueryBuilder.queryFor(Token.class, (EntityDescriptor)EntityDescriptor.token()).returningAtMost(1000)).size());
        TokenManagerImplTest.assertEquals((int)0, (int)((TokenDAOMemory)ContainerManager.getComponent((String)"tokenDAOMemory")).search(QueryBuilder.queryFor(Token.class, (EntityDescriptor)EntityDescriptor.token()).returningAtMost(1000)).size());
    }
}

