/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.directory;

import com.atlassian.crowd.acceptance.tests.directory.BaseTest;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.InvalidCredentialException;
import com.atlassian.crowd.exception.InvalidGroupException;
import com.atlassian.crowd.exception.InvalidMembershipException;
import com.atlassian.crowd.exception.InvalidUserException;
import com.atlassian.crowd.exception.MembershipNotFoundException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.ReadOnlyGroupException;
import com.atlassian.crowd.exception.UserAlreadyExistsException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.model.group.GroupTemplate;
import com.atlassian.crowd.model.group.GroupType;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import java.util.Iterator;
import java.util.List;

public abstract class NestedGroupsTest
extends BaseTest {
    protected final String groupName1 = "group-1";
    protected final String groupName2 = "group-2";
    protected final String groupName3 = "group-3";
    protected final String groupName4 = "group-4";
    protected final String groupName5 = "group-5";
    protected final String userNameA = "user-A";
    protected final String userNameB = "user-B";
    protected final String userNameC = "user-C";
    protected final String userNameD = "user-D";
    protected final String userNameE = "user-E";
    protected final String userNameF = "user-F";
    protected final String userNameG = "user-G";
    protected final String firstName = "First";
    protected final String surName = "Last";
    protected final String password = "secret-password";

    protected void removeTestData() {
        this.removeGroup("group-1");
        this.removeGroup("group-2");
        this.removeGroup("group-3");
        this.removeGroup("group-4");
        this.removeGroup("group-5");
        this.removeUser("user-A");
        this.removeUser("user-B");
        this.removeUser("user-C");
        this.removeUser("user-D");
        this.removeUser("user-E");
        this.removeUser("user-F");
        this.removeUser("user-G");
    }

    protected void loadTestData() throws OperationFailedException, InvalidGroupException, InvalidCredentialException, InvalidUserException, InvalidMembershipException, DirectoryNotFoundException, GroupNotFoundException, UserAlreadyExistsException, UserNotFoundException, ReadOnlyGroupException {
        GroupTemplate group1 = new GroupTemplate("group-1", this.directory.getId().longValue(), GroupType.GROUP);
        this.getRemoteDirectory().addGroup(group1);
        GroupTemplate group2 = new GroupTemplate("group-2", this.directory.getId().longValue(), GroupType.GROUP);
        this.getRemoteDirectory().addGroup(group2);
        GroupTemplate group3 = new GroupTemplate("group-3", this.directory.getId().longValue(), GroupType.GROUP);
        this.getRemoteDirectory().addGroup(group3);
        GroupTemplate group4 = new GroupTemplate("group-4", this.directory.getId().longValue(), GroupType.GROUP);
        this.getRemoteDirectory().addGroup(group4);
        GroupTemplate group5 = new GroupTemplate("group-5", this.directory.getId().longValue(), GroupType.GROUP);
        this.getRemoteDirectory().addGroup(group5);
        this.addUser("user-A", this.directory.getId(), "secret-password");
        this.addUser("user-B", this.directory.getId(), "secret-password");
        this.addUser("user-C", this.directory.getId(), "secret-password");
        this.addUser("user-D", this.directory.getId(), "secret-password");
        this.addUser("user-E", this.directory.getId(), "secret-password");
        this.addUser("user-F", this.directory.getId(), "secret-password");
        this.addUser("user-G", this.directory.getId(), "secret-password");
        this.getRemoteDirectory().addUserToGroup("user-A", "group-1");
        this.getRemoteDirectory().addUserToGroup("user-B", "group-2");
        this.getRemoteDirectory().addUserToGroup("user-C", "group-3");
        this.getRemoteDirectory().addUserToGroup("user-D", "group-3");
        this.getRemoteDirectory().addUserToGroup("user-E", "group-4");
        this.getRemoteDirectory().addGroupToGroup("group-2", "group-1");
        this.getRemoteDirectory().addGroupToGroup("group-3", "group-2");
        this.getRemoteDirectory().addGroupToGroup("group-1", "group-3");
        this.getRemoteDirectory().addGroupToGroup("group-4", "group-3");
        this.getRemoteDirectory().addGroupToGroup("group-5", "group-4");
    }

    public void testNestedGroups() throws Exception {
        this.logger.info((Object)"Running testNestedGroups");
        List users = this.directoryManager.searchNestedGroupRelationships(this.directory.getId(), QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group((GroupType)GroupType.GROUP)).withName("group-1").returningAtMost(-1));
        NestedGroupsTest.assertNotNull((Object)users);
        NestedGroupsTest.assertEquals((int)(5 + this.getInitialGroupMemberCount()), (int)users.size());
        NestedGroupsTest.assertTrue((boolean)users.contains("user-A"));
        NestedGroupsTest.assertTrue((boolean)users.contains("user-B"));
        NestedGroupsTest.assertTrue((boolean)users.contains("user-C"));
        NestedGroupsTest.assertTrue((boolean)users.contains("user-D"));
        NestedGroupsTest.assertTrue((boolean)users.contains("user-E"));
        users = this.directoryManager.searchNestedGroupRelationships(this.directory.getId(), QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group((GroupType)GroupType.GROUP)).withName("group-4").returningAtMost(-1));
        NestedGroupsTest.assertNotNull((Object)users);
        NestedGroupsTest.assertEquals((int)(1 + this.getInitialGroupMemberCount()), (int)users.size());
        NestedGroupsTest.assertTrue((boolean)users.contains("user-E"));
    }

    public void testAddUserToNestedGroups() throws Exception {
        this.logger.info((Object)"Running testAddUserToNestedGroups");
        this.directoryManager.addUserToGroup(this.directory.getId(), "user-F", "group-1");
        List users = this.directoryManager.searchNestedGroupRelationships(this.directory.getId(), QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group((GroupType)GroupType.GROUP)).withName("group-1").returningAtMost(-1));
        NestedGroupsTest.assertNotNull((Object)users);
        NestedGroupsTest.assertEquals((int)(6 + this.getInitialGroupMemberCount()), (int)users.size());
        NestedGroupsTest.assertTrue((boolean)users.contains("user-A"));
        NestedGroupsTest.assertTrue((boolean)users.contains("user-B"));
        NestedGroupsTest.assertTrue((boolean)users.contains("user-C"));
        NestedGroupsTest.assertTrue((boolean)users.contains("user-D"));
        NestedGroupsTest.assertTrue((boolean)users.contains("user-E"));
        NestedGroupsTest.assertTrue((boolean)users.contains("user-F"));
        users = this.directoryManager.searchNestedGroupRelationships(this.directory.getId(), QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group((GroupType)GroupType.GROUP)).withName("group-4").returningAtMost(-1));
        NestedGroupsTest.assertNotNull((Object)users);
        NestedGroupsTest.assertEquals((int)(1 + this.getInitialGroupMemberCount()), (int)users.size());
        NestedGroupsTest.assertTrue((boolean)users.contains("user-E"));
    }

    public void testRemoveUserFromNestedGroupsFail() throws Exception {
        this.logger.info((Object)"Running testRemoveUserFromNestedGroupsFail");
        try {
            this.directoryManager.removeUserFromGroup(this.directory.getId(), "user-B", "group-1");
            NestedGroupsTest.fail((String)"Should have thrown exception");
        }
        catch (MembershipNotFoundException e) {
            // empty catch block
        }
        List users = this.directoryManager.searchNestedGroupRelationships(this.directory.getId(), QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group((GroupType)GroupType.GROUP)).withName("group-1").returningAtMost(-1));
        NestedGroupsTest.assertNotNull((Object)users);
        NestedGroupsTest.assertEquals((int)(5 + this.getInitialGroupMemberCount()), (int)users.size());
        NestedGroupsTest.assertTrue((boolean)users.contains("user-A"));
        NestedGroupsTest.assertTrue((boolean)users.contains("user-B"));
        NestedGroupsTest.assertTrue((boolean)users.contains("user-C"));
        NestedGroupsTest.assertTrue((boolean)users.contains("user-D"));
        NestedGroupsTest.assertTrue((boolean)users.contains("user-E"));
        users = this.directoryManager.searchNestedGroupRelationships(this.directory.getId(), QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group((GroupType)GroupType.GROUP)).withName("group-4").returningAtMost(-1));
        NestedGroupsTest.assertNotNull((Object)users);
        NestedGroupsTest.assertEquals((int)(1 + this.getInitialGroupMemberCount()), (int)users.size());
        NestedGroupsTest.assertTrue((boolean)users.contains("user-E"));
    }

    public void testRemoveUserFromNestedGroupsOk() throws Exception {
        this.logger.info((Object)"Running testRemoveUserFromNestedGroupsOk");
        this.directoryManager.removeUserFromGroup(this.directory.getId(), "user-A", "group-1");
        List users = this.directoryManager.searchNestedGroupRelationships(this.directory.getId(), QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group((GroupType)GroupType.GROUP)).withName("group-1").returningAtMost(-1));
        NestedGroupsTest.assertNotNull((Object)users);
        NestedGroupsTest.assertEquals((int)(4 + this.getInitialGroupMemberCount()), (int)users.size());
        NestedGroupsTest.assertTrue((boolean)users.contains("user-B"));
        NestedGroupsTest.assertTrue((boolean)users.contains("user-C"));
        NestedGroupsTest.assertTrue((boolean)users.contains("user-D"));
        NestedGroupsTest.assertTrue((boolean)users.contains("user-E"));
        users = this.directoryManager.searchNestedGroupRelationships(this.directory.getId(), QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group((GroupType)GroupType.GROUP)).withName("group-4").returningAtMost(-1));
        NestedGroupsTest.assertNotNull((Object)users);
        NestedGroupsTest.assertEquals((int)(1 + this.getInitialGroupMemberCount()), (int)users.size());
        NestedGroupsTest.assertTrue((boolean)users.contains("user-E"));
    }

    public void testNestedGroupsDirectFetch() throws Exception {
        this.logger.info((Object)"Running testNestedGroupsDirectFetch");
        List groups = this.directoryManager.searchDirectGroupRelationships(this.directory.getId(), QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group((GroupType)GroupType.GROUP)).childrenOf(EntityDescriptor.group((GroupType)GroupType.GROUP)).withName("group-1").returningAtMost(-1));
        NestedGroupsTest.assertNotNull((Object)groups);
        NestedGroupsTest.assertEquals((int)1, (int)groups.size());
        Iterator iterator = groups.iterator();
        String groupName = (String)iterator.next();
        NestedGroupsTest.assertEquals((String)"group-2", (String)groupName);
        List users = this.directoryManager.searchDirectGroupRelationships(this.directory.getId(), QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group((GroupType)GroupType.GROUP)).withName("group-1").returningAtMost(-1));
        NestedGroupsTest.assertNotNull((Object)users);
        NestedGroupsTest.assertEquals((int)(1 + this.getInitialGroupMemberCount()), (int)users.size());
        NestedGroupsTest.assertTrue((boolean)users.contains("user-A"));
    }

    public void testIsGroupMemberDirect() throws Exception {
        this.logger.info((Object)"Running testIsGroupMemberDirect");
        boolean isMember = this.directoryManager.isUserDirectGroupMember(this.directory.getId(), "user-A", "group-1");
        NestedGroupsTest.assertTrue((String)"user-A should be a member of group-1", (boolean)isMember);
    }

    public void testIsGroupMemberDirectNot() throws Exception {
        this.logger.info((Object)"Running testIsGroupMemberDirectNot");
        boolean isMember = this.directoryManager.isUserDirectGroupMember(this.directory.getId(), "user-G", "group-1");
        NestedGroupsTest.assertFalse((String)"user-G should NOT be a member of group-1", (boolean)isMember);
    }

    public void testIsGroupMemberDirectNonExistent() throws Exception {
        this.logger.info((Object)"Running testIsGroupMemberDirectNonExistent");
        String nonExistentUserName = "badgers-Ahoy!";
        boolean isMember = this.directoryManager.isUserDirectGroupMember(this.directory.getId(), nonExistentUserName, "group-1");
        NestedGroupsTest.assertFalse((String)(nonExistentUserName + " should NOT be a member of " + "group-1"), (boolean)isMember);
    }

    public void testIsGroupMemberNested() throws Exception {
        this.logger.info((Object)"Running testIsGroupMemberNested");
        boolean isMember = this.directoryManager.isUserNestedGroupMember(this.directory.getId(), "user-B", "group-1");
        NestedGroupsTest.assertTrue((String)"user-B should be a nested member of group-1", (boolean)isMember);
    }

    protected int getInitialGroupMemberCount() {
        return 0;
    }
}

