/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.client;

import com.atlassian.crowd.acceptance.tests.applications.crowd.CrowdAcceptanceTestCase;
import com.atlassian.crowd.acceptance.utils.AcceptanceTestHelper;
import com.atlassian.crowd.integration.soap.SOAPEntity;
import com.atlassian.crowd.integration.soap.SOAPGroup;
import com.atlassian.crowd.integration.soap.SOAPPrincipal;
import com.atlassian.crowd.integration.soap.SearchRestriction;
import com.atlassian.crowd.model.authentication.UserAuthenticationContext;
import com.atlassian.crowd.service.soap.client.SecurityServerClientImpl;
import com.atlassian.crowd.service.soap.client.SoapClientProperties;
import com.atlassian.crowd.service.soap.client.SoapClientPropertiesImpl;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityServerClientTest
extends CrowdAcceptanceTestCase {
    private SecurityServerClientImpl securityServerClient;
    private UserAuthenticationContext userAuthenticationContext;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.restoreCrowdFromXML("tokenauthenticationtest.xml");
        Properties sscProperties = AcceptanceTestHelper.loadProperties("localtest.crowd.properties");
        SoapClientPropertiesImpl cProperties = SoapClientPropertiesImpl.newInstanceFromProperties((Properties)sscProperties);
        this.securityServerClient = new SecurityServerClientImpl((SoapClientProperties)cProperties);
        this.userAuthenticationContext = new UserAuthenticationContext();
        this.userAuthenticationContext.setApplication("integrationtest");
    }

    public void testSearchGroupsWhereUserIsAMember() throws Exception {
        SearchRestriction restriction = new SearchRestriction("group.principal.member", "admin");
        SOAPGroup[] soapGroups = this.securityServerClient.searchGroups(new SearchRestriction[]{restriction});
        SecurityServerClientTest.assertEquals((int)2, (int)soapGroups.length);
        this.assertContainsExactly(Arrays.asList(soapGroups), "crowd-administrators", "general-group");
    }

    public void testSearchGroupsWithNameRestriction() throws Exception {
        SearchRestriction restriction = new SearchRestriction("group.name", "crowd-administrators");
        SOAPGroup[] soapGroups = this.securityServerClient.searchGroups(new SearchRestriction[]{restriction});
        this.assertContainsExactly(Arrays.asList(soapGroups), "crowd-administrators");
    }

    public void testSearchGroupsPopulatesEntityFields() throws Exception {
        SearchRestriction restriction = new SearchRestriction("group.name", "general-group");
        SOAPGroup[] soapGroups = this.securityServerClient.searchGroups(new SearchRestriction[]{restriction});
        SecurityServerClientTest.assertTrue((boolean)soapGroups[0].isActive());
        SecurityServerClientTest.assertEquals((String)"General Group", (String)soapGroups[0].getDescription());
        SecurityServerClientTest.assertEquals((long)32769L, (long)soapGroups[0].getDirectoryId());
    }

    public void assertContainsExactly(List<? extends SOAPEntity> entities, String ... names) {
        SecurityServerClientTest.assertEquals((int)names.length, (int)entities.size());
        int index = 0;
        for (SOAPEntity sOAPEntity : entities) {
            SecurityServerClientTest.assertEquals((String)names[index], (String)sOAPEntity.getName());
            ++index;
        }
    }

    public void testSearchPrincipals_Aliases() throws Exception {
        this.setApplication("aliases", "aliases");
        SOAPPrincipal[] principals = this.securityServerClient.searchPrincipals(new SearchRestriction[]{new SearchRestriction("principal.name", "alias")});
        SecurityServerClientTest.assertEquals((int)2, (int)principals.length);
        SecurityServerClientTest.assertEquals((String)"alias1", (String)principals[0].getName());
        SecurityServerClientTest.assertEquals((String)"alias2", (String)principals[1].getName());
    }

    public void testSearchPrincipals_AliasesIgnoreUsernameWhenAliasExists() throws Exception {
        this.setApplication("aliases", "aliases");
        SOAPPrincipal[] principals = this.securityServerClient.searchPrincipals(new SearchRestriction[]{new SearchRestriction("principal.name", "user")});
        SecurityServerClientTest.assertEquals((int)1, (int)principals.length);
        SecurityServerClientTest.assertEquals((String)"user2", (String)principals[0].getName());
    }

    public void testSearchPrincipals_AliasesAll() throws Exception {
        this.setApplication("aliases", "aliases");
        SOAPPrincipal[] principals = this.securityServerClient.searchPrincipals(new SearchRestriction[]{new SearchRestriction("principal.name", "s")});
        SecurityServerClientTest.assertEquals((int)3, (int)principals.length);
        SecurityServerClientTest.assertEquals((String)"alias1", (String)principals[0].getName());
        SecurityServerClientTest.assertEquals((String)"alias2", (String)principals[1].getName());
        SecurityServerClientTest.assertEquals((String)"user2", (String)principals[2].getName());
    }

    private void setApplication(String applicationName, String password) {
        Properties sscProperties = AcceptanceTestHelper.loadProperties("localtest.crowd.properties");
        sscProperties.setProperty("application.password", password);
        sscProperties.setProperty("application.name", applicationName);
        SoapClientPropertiesImpl cProperties = SoapClientPropertiesImpl.newInstanceFromProperties((Properties)sscProperties);
        this.securityServerClient = new SecurityServerClientImpl((SoapClientProperties)cProperties);
        this.userAuthenticationContext = new UserAuthenticationContext();
        this.userAuthenticationContext.setApplication("integrationtest");
    }
}

