/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.applications.crowd;

import com.atlassian.crowd.acceptance.tests.applications.crowd.CrowdAcceptanceTestCase;

public class ViewOptionsTest
extends CrowdAcceptanceTestCase {
    private static final String TEST_CLAZZ = "com.atlassian.crowd";
    private static final String FORGOTTEN_PASSWORD_TEMPLATE_TEXTAREA = "forgottenPasswordTemplate";

    public void setUp() throws Exception {
        super.setUp();
        this.setScriptingEnabled(true);
        this.restoreCrowdFromXML("viewoptions.xml");
    }

    public void tearDown() throws Exception {
        this.setScriptingEnabled(false);
        this.restoreBaseSetup();
        super.tearDown();
    }

    public void testGeneralTabWithBlankData() {
        this.gotoGeneral();
        this.setWorkingForm("general");
        this.setTextField("title", "");
        this.setTextField("domain", "");
        this.setTextField("seed", "");
        this.submit();
        this.assertKeyPresent("options.title.invalid");
        this.assertKeyPresent("options.seed.invalid");
    }

    public void testGeneralWithInvalidDomain() {
        this.gotoGeneral();
        this.setWorkingForm("general");
        this.setTextField("domain", ".bad.localhost");
        this.submit();
        this.assertKeyPresent("options.domain.invalid");
    }

    public void testGeneralCancelButton() {
        this.gotoGeneral();
        this.assertKeyPresent("menu.options.label");
        this.clickButton("cancel");
        this.assertWarningAndErrorNotPresent();
        this.assertKeyPresent("menu.options.label");
    }

    public void testTokenSeedGeneration() {
        this.gotoGeneral();
        this.setWorkingForm("general");
        String originalSeedValue = this.getFormElementValue("seed");
        this.clickButton("generate-token-seed");
        String newSeedValue = this.getFormElementValue("seed");
        ViewOptionsTest.assertNotSame((String)"We should have different seed values", (Object)originalSeedValue, (Object)newSeedValue);
    }

    public void testGeneralTab() {
        this.gotoGeneral();
        this.setWorkingForm("general");
        this.setTextField("title", "New Atlassian Title");
        this.setTextField("domain", "localhost");
        this.checkCheckbox("secureCookie");
        this.submit();
        this.assertKeyPresent("updatesuccessful.label");
        this.assertTextFieldEquals("title", "New Atlassian Title");
        this.assertTextFieldEquals("domain", "localhost");
        this.assertCheckboxSelected("secureCookie");
        this.uncheckCheckbox("secureCookie");
        this.submit();
        this.assertKeyPresent("updatesuccessful.label");
        this.assertCheckboxNotSelected("secureCookie");
    }

    public void testMailServerWithBlankData() {
        this.gotoMailServer();
        this.setTextField("notificationEmail", "");
        this.setTextField("host", "");
        this.setTextField("from", "");
        this.setTextField("prefix", "");
        this.setTextField("username", "");
        this.setTextField("password", "");
        this.submit();
        this.assertKeyPresent("mailserver.notification.invalid");
        this.assertKeyPresent("mailserver.host.invalid");
        this.assertKeyPresent("mailserver.from.invalid");
    }

    public void testJNDIMailServerWithBlankData() {
        this.gotoMailServer();
        this.setTextField("notificationEmail", "");
        this.setTextField("from", "");
        this.clickRadioOption("jndiMailActive", "true");
        this.assertRadioOptionSelected("jndiMailActive", "true");
        this.setTextField("jndiLocation", "");
        this.submit();
        this.assertKeyPresent("mailserver.jndiLocation.invalid");
        this.assertKeyPresent("mailserver.notification.invalid");
        this.assertKeyPresent("mailserver.from.invalid");
    }

    public void testMailServer() {
        this.gotoMailServer();
        this.setTextField("notificationEmail", "crowd-admin@test.com");
        this.setTextField("host", "localhost");
        this.setTextField("from", "admin@test.com");
        this.setTextField("prefix", "Crowd Email");
        this.setTextField("username", "admin");
        this.setTextField("password", "password");
        this.submit();
        this.assertKeyPresent("updatesuccessful.label");
        this.assertTextFieldEquals("notificationEmail", "crowd-admin@test.com");
        this.assertTextFieldEquals("host", "localhost");
        this.assertTextFieldEquals("from", "admin@test.com");
        this.assertTextFieldEquals("prefix", "Crowd Email");
        this.assertTextFieldEquals("username", "admin");
    }

    public void testMailServerSSLPort() {
        this.gotoMailServer();
        this.setScriptingEnabled(true);
        this.checkCheckbox("useSSL");
        this.assertTextInElement("port", "465");
        this.uncheckCheckbox("useSSL");
        this.assertTextInElement("port", "25");
        this.setScriptingEnabled(false);
    }

    public void testMailServerCancelButton() {
        this.gotoMailServer();
        this.assertKeyPresent("menu.mailserver.label");
        this.clickButton("cancel");
        this.assertWarningAndErrorNotPresent();
        this.assertKeyPresent("menu.mailserver.label");
    }

    public void testMailTemplateWithBlankData() {
        this.gotoMailTemplate();
        this.setTextField(FORGOTTEN_PASSWORD_TEMPLATE_TEXTAREA, "");
        this.submit();
        this.assertKeyPresent("mailtemplate.template.invalid");
    }

    public void testMailTemplate() {
        this.gotoMailTemplate();
        this.setTextField(FORGOTTEN_PASSWORD_TEMPLATE_TEXTAREA, "A mail template that is for testing");
        this.submit();
        this.assertTextFieldEquals(FORGOTTEN_PASSWORD_TEMPLATE_TEXTAREA, "A mail template that is for testing");
    }

    public void testMailTemplateCancelButton() {
        this.gotoMailTemplate();
        this.assertKeyPresent("menu.mailtemplate.label");
        this.clickButton("cancel");
        this.assertWarningAndErrorNotPresent();
        this.assertKeyPresent("menu.mailtemplate.label");
    }

    public void testSessionWithBlankData() {
        this.gotoSessionConfig();
        this.setTextField("sessionTime", "");
        this.submit();
        this.assertKeyPresent("session.sessiontime.invalid");
    }

    public void testSessionWithInvalidData() {
        this.gotoSessionConfig();
        this.setTextField("sessionTime", "asda");
        this.submit();
        this.assertKeyPresent("session.sessiontime.invalid");
    }

    public void testTrustedProxyUpdate() {
        this.gotoTrustedProxies();
        this.setTextField("address", "10.1.2.3");
        this.submit();
        this.assertWarningAndErrorNotPresent();
        this.assertTextPresent("10.1.2.3");
    }

    public void testProfiling() {
        this.gotoLoggingProfiling();
        this.setWorkingForm("profiling");
        this.assertKeyPresent("loglevel.precursor");
        this.assertKeyPresent("loglevel.profilingOn");
        this.submit();
        this.assertKeyPresent("loglevel.profilingOff");
        this.setWorkingForm("profiling");
        this.submit();
        this.assertKeyPresent("loglevel.profilingOn");
    }

    public void testLogging() {
        this.gotoLoggingProfiling();
        this.setWorkingForm("logging");
        String row = this.getElementTextByXPath("id(\"com.atlassian.crowd\")");
        ViewOptionsTest.assertTrue((row.indexOf("INFO") >= 0 ? 1 : 0) != 0);
        this.selectOption("levelNames", "DEBUG");
        this.submit("updateLogging");
        row = this.getElementTextByXPath("id(\"com.atlassian.crowd\")");
        ViewOptionsTest.assertTrue((row.indexOf("DEBUG") >= 0 ? 1 : 0) != 0);
        this.submit("profileName");
        row = this.getElementTextByXPath("id(\"com.atlassian.crowd\")");
        ViewOptionsTest.assertTrue((row.indexOf("INFO") >= 0 ? 1 : 0) != 0);
    }

    public void testSession() {
        this.gotoSessionConfig();
        this.setTextField("sessionTime", "1234");
        this.submit();
        this.assertTextFieldEquals("sessionTime", "1234");
    }

    public void testLicenseWithBlankData() {
        this.gotoLicensing();
        this.setTextField("key", "");
        this.submit();
        this.assertKeyPresent("license.key.error.blank");
    }

    public void testLicenseWithInvalidData() {
        this.gotoLicensing();
        this.setTextField("key", "some bad data");
        this.submit();
        this.assertKeyPresent("license.key.error.invalid");
    }

    public void testLicenseWithAValidKey() {
        this.gotoLicensing();
        this.setTextField("key", "MprrTWaDMMgqqQFpjxNimIQipnxxoLHCfBhpuriOFeiHJo\nmi2Kf0GbDqztZI94<4TFAhw72Kl7Ojoz6JPyOhv<sLxwCc\nnMRVURrNpmqPrQoorqVTqomnMqQoOOQQnUVSvsxTtwVuWS\nmOnnqsmvUUnurtvvoqmmmmmUUnurtvvoqmmmmmUU1qiXpp\nfXkUUnmmmm");
        this.submit();
        this.assertKeyPresent("updatesuccessful.label");
    }

    public void testLicenseWithAnExpiredMaintenaceKeyTooOldForBuild() {
        this.gotoLicensing();
        this.setTextField("key", "AAABFw0ODAoPeNp9kFFLwzAQx9/zKQI+t7TbZGUQEJc4CnWdrlMRX2J607A0LZe0um9vu3UgPvh4x\n/1+97+7eoaSbqGh0ZTGk8VssrieUrEt6CSKEsLBKdSN17VlS6y/yrcF5dCBqRtAooZOKJXXHTCPL\nZAlghyGufTAesM8iJIgismytr6fW8sKmDISD+EBrL8ppTbHxkgLPlR1NQozrcA6KI4NnAAunkSWb\n8TjRSPue+4/j+ikaU9B2F4aB6QHrAcrrQLx3Wg8XgImY8AcP6TV7szwQUc3Jx/ZAnaAKWe3xWwVr\nHbpXfCSP8yDnL+mY+B1W70D5vudA3QsiMl4QQ9lKb9Uvxa31uhKeyjJpkX1KR38fdgPj3SKEjAsA\nhQDnIHlSx5Ug4jClePbHxCPTYAwnQIUeTzFHGkn0bRuxJZNK5uaXO7y+uU=X02e6");
        this.submit();
        this.assertKeyPresent("license.key.error.maintenance.expired");
    }
}

