/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.applications.crowd;

import com.atlassian.core.util.collection.EasyList;
import com.atlassian.crowd.acceptance.tests.applications.crowd.CrowdAcceptanceTestCase;
import com.atlassian.crowd.acceptance.utils.DbCachingTestHelper;

public class SynchroniseDirectoryTest
extends CrowdAcceptanceTestCase {
    private static final String CONNECTOR_DIRECTORY_NAME_APACHEDS_CACHING = "ApacheDS Caching Directory";
    private static final long MAX_SYNC_WAIT_TIME_MS = 60000L;
    private DbCachingTestHelper dbCachingTestHelper;

    public void setUp() throws Exception {
        super.setUp();
        this.dbCachingTestHelper = new DbCachingTestHelper(this.tester);
        this.setScriptingEnabled(true);
        this.restoreCrowdFromXML("viewdirectory.xml");
    }

    public void tearDown() throws Exception {
        this.setScriptingEnabled(false);
        this.dbCachingTestHelper = null;
        super.tearDown();
    }

    public void testUserWithAttributesRemoved() throws InterruptedException {
        this.log("Running: testUserWithAttributesRemoved");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(CONNECTOR_DIRECTORY_NAME_APACHEDS_CACHING);
        this.assertKeyPresent("menu.viewdirectory.label", EasyList.build((Object)CONNECTOR_DIRECTORY_NAME_APACHEDS_CACHING));
        this.assertKeyPresent("directory.caching.sync.never.label");
        this.synchroniseDirectory();
        this.searchAllPrincipals();
        this.assertTableRowCountEquals("user-details", 7);
        this.gotoViewApplication("crowd");
        this.clickLink("application-directories");
        this.clickButton("add-directory");
        this.assertTextInTable("directoriesTable", CONNECTOR_DIRECTORY_NAME_APACHEDS_CACHING);
        this.setWorkingForm("directoriesForm");
        this.selectOption("directory3-allowAll", "True");
        this.submit();
        this.gotoViewPrincipal("Max Born", CONNECTOR_DIRECTORY_NAME_APACHEDS_CACHING);
        this.setTextField("password", "mypassword");
        this.setTextField("passwordConfirm", "mypassword");
        this.submit();
        this._logout();
        this._loginAsUser("Max Born", "mypassword");
        this._logout();
        this._loginAdminUser();
        this.gotoViewPrincipal("Max Born", CONNECTOR_DIRECTORY_NAME_APACHEDS_CACHING);
        this.clickLink("user-attributes-tab");
        this.assertTableRowCountEquals("attributesTable", 3);
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(CONNECTOR_DIRECTORY_NAME_APACHEDS_CACHING);
        this.assertKeyPresent("menu.viewdirectory.label", EasyList.build((Object)CONNECTOR_DIRECTORY_NAME_APACHEDS_CACHING));
        this.clickLinkWithExactText("Connector");
        this.setWorkingForm("connectordetails");
        this.setTextField("pollingIntervalInMin", "3600");
        this.setTextField("baseDN", "ou=sandbox,dc=example,dc=com");
        this.submit();
        this.clickLinkWithExactText("Configuration");
        this.setWorkingForm("configuration_details");
        this.setTextField("userDNaddition", "");
        this.submit();
        this.synchroniseDirectory();
        this.searchAllPrincipals();
        this.assertTableRowCountEquals("user-details", 5);
        this.assertTextNotPresent("Max Born");
    }

    public void testSynchronisation() throws Exception {
        this.log("Running: testSynchronisation");
        this.searchAllPrincipals();
        this.assertTableRowCountEquals("user-details", 1);
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(CONNECTOR_DIRECTORY_NAME_APACHEDS_CACHING);
        this.assertKeyPresent("menu.viewdirectory.label", EasyList.build((Object)CONNECTOR_DIRECTORY_NAME_APACHEDS_CACHING));
        this.assertKeyPresent("directory.caching.sync.never.label");
        this.synchroniseDirectory();
        this.searchAllPrincipals();
        this.assertTableRowCountEquals("user-details", 7);
    }

    public void testChangeDirectoryThenSync() throws Exception {
        this.log("Running: testChangeDirectoryThenSync");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(CONNECTOR_DIRECTORY_NAME_APACHEDS_CACHING);
        this.assertKeyPresent("menu.viewdirectory.label", EasyList.build((Object)CONNECTOR_DIRECTORY_NAME_APACHEDS_CACHING));
        this.assertKeyPresent("directory.caching.sync.never.label");
        this.synchroniseDirectory();
        this.searchAllPrincipals();
        this.assertTableRowCountEquals("user-details", 7);
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(CONNECTOR_DIRECTORY_NAME_APACHEDS_CACHING);
        this.assertKeyPresent("menu.viewdirectory.label", EasyList.build((Object)CONNECTOR_DIRECTORY_NAME_APACHEDS_CACHING));
        this.clickLinkWithExactText("Configuration");
        this.setWorkingForm("configuration_details");
        this.setTextField("userDNaddition", "");
        this.submit();
        this.synchroniseDirectory();
        this.searchAllPrincipals();
        this.assertTableRowCountEquals("user-details", 11);
    }

    public void testChangedToEmptyOU() throws InterruptedException {
        this.log("Running: testChangedToEmptyOU");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(CONNECTOR_DIRECTORY_NAME_APACHEDS_CACHING);
        this.assertKeyPresent("menu.viewdirectory.label", EasyList.build((Object)CONNECTOR_DIRECTORY_NAME_APACHEDS_CACHING));
        this.assertKeyPresent("directory.caching.sync.never.label");
        this.synchroniseDirectory();
        this.searchAllPrincipals();
        this.assertTableRowCountEquals("user-details", 7);
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(CONNECTOR_DIRECTORY_NAME_APACHEDS_CACHING);
        this.assertKeyPresent("menu.viewdirectory.label", EasyList.build((Object)CONNECTOR_DIRECTORY_NAME_APACHEDS_CACHING));
        this.clickLinkWithExactText("Connector");
        this.setWorkingForm("connectordetails");
        this.setTextField("pollingIntervalInMin", "3600");
        this.setTextField("baseDN", "ou=test,dc=example,dc=com");
        this.submit();
        this.clickLinkWithExactText("Configuration");
        this.setWorkingForm("configuration_details");
        this.setTextField("userDNaddition", "");
        this.submit();
        this.synchroniseDirectory();
        this.searchAllPrincipals();
        this.assertTableRowCountEquals("user-details", 1);
    }

    public void testSynchroniseCheckGroups() throws InterruptedException {
        this.log("Running: testSynchroniseCheckGroups");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(CONNECTOR_DIRECTORY_NAME_APACHEDS_CACHING);
        this.assertKeyPresent("menu.viewdirectory.label", EasyList.build((Object)CONNECTOR_DIRECTORY_NAME_APACHEDS_CACHING));
        this.assertKeyPresent("directory.caching.sync.never.label");
        this.synchroniseDirectory();
        this.gotoBrowseGroups();
        this.setWorkingForm("browsegroups");
        this.selectOption("directoryID", CONNECTOR_DIRECTORY_NAME_APACHEDS_CACHING);
        this.submit();
        this.assertTableRowCountEquals("group-details", 6);
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(CONNECTOR_DIRECTORY_NAME_APACHEDS_CACHING);
        this.assertKeyPresent("menu.viewdirectory.label", EasyList.build((Object)CONNECTOR_DIRECTORY_NAME_APACHEDS_CACHING));
        this.clickLinkWithExactText("Connector");
        this.setWorkingForm("connectordetails");
        this.setTextField("pollingIntervalInMin", "3600");
        this.setTextField("baseDN", "ou=Users,dc=example,dc=com");
        this.submit();
        this.clickLinkWithExactText("Configuration");
        this.setWorkingForm("configuration_details");
        this.setTextField("userDNaddition", "");
        this.submit();
        this.synchroniseDirectory();
        this.gotoBrowseGroups();
        this.setWorkingForm("browsegroups");
        this.selectOption("directoryID", CONNECTOR_DIRECTORY_NAME_APACHEDS_CACHING);
        this.submit();
        this.assertTableRowCountEquals("group-details", 1);
    }

    public void testCheckMembershipsRemoved() throws InterruptedException {
        this.log("Running: testCheckMembershipsRemoved");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(CONNECTOR_DIRECTORY_NAME_APACHEDS_CACHING);
        this.assertKeyPresent("menu.viewdirectory.label", EasyList.build((Object)CONNECTOR_DIRECTORY_NAME_APACHEDS_CACHING));
        this.assertKeyPresent("directory.caching.sync.never.label");
        this.clickLinkWithExactText("Configuration");
        this.setWorkingForm("configuration_details");
        this.setTextField("userDNaddition", "");
        this.submit();
        this.clickLink("connector-general");
        this.synchroniseDirectory();
        this.gotoBrowseGroups();
        this.setWorkingForm("browsegroups");
        this.selectOption("directoryID", CONNECTOR_DIRECTORY_NAME_APACHEDS_CACHING);
        this.submit();
        this.assertTableRowCountEquals("group-details", 6);
        this.searchAllPrincipals();
        this.clickLinkWithExactText("Albert Einstein");
        this.clickLink("user-groups-tab");
        this.assertTableRowCountEquals("groupsTable", 2);
        this.assertTextInTable("groupsTable", "Misc");
        this.assertTextNotInTable("groupsTable", new String[]{"ExplorersClub", "EliteExplorersClub"});
        this.searchAllPrincipals();
        this.clickLinkWithExactText("John Oxley");
        this.clickLink("user-groups-tab");
        this.assertTableRowCountEquals("groupsTable", 4);
        this.assertTextInTable("groupsTable", new String[]{"Misc", "ExplorersClub", "EliteExplorersClub"});
        this.searchAllPrincipals();
        this.clickLinkWithExactText("James Cook");
        this.clickLink("user-groups-tab");
        this.assertTableRowCountEquals("groupsTable", 2);
        this.assertTextInTable("groupsTable", "ExplorersClub");
        this.assertTextNotInTable("groupsTable", "EliteExplorersClub");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(CONNECTOR_DIRECTORY_NAME_APACHEDS_CACHING);
        this.assertKeyPresent("menu.viewdirectory.label", EasyList.build((Object)CONNECTOR_DIRECTORY_NAME_APACHEDS_CACHING));
        this.clickLinkWithExactText("Connector");
        this.setWorkingForm("connectordetails");
        this.setTextField("pollingIntervalInMin", "3600");
        this.setTextField("baseDN", "dc=example,dc=com");
        this.submit();
        this.clickLinkWithExactText("Configuration");
        this.setWorkingForm("configuration_details");
        this.setTextField("groupDNaddition", "ou=sandbox");
        this.submit();
        this.synchroniseDirectory();
        this.gotoBrowseGroups();
        this.setWorkingForm("browsegroups");
        this.selectOption("directoryID", CONNECTOR_DIRECTORY_NAME_APACHEDS_CACHING);
        this.submit();
        this.assertTableRowCountEquals("group-details", 3);
        this.searchAllPrincipals();
        this.clickLinkWithExactText("Albert Einstein");
        this.clickLink("user-groups-tab");
        this.assertTableNotPresent("groupsTable");
        this.searchAllPrincipals();
        this.clickLinkWithExactText("John Oxley");
        this.clickLink("user-groups-tab");
        this.assertTableRowCountEquals("groupsTable", 3);
        this.assertTextInTable("groupsTable", new String[]{"ExplorersClub", "EliteExplorersClub"});
        this.assertTextNotInTable("groupsTable", "Misc");
        this.searchAllPrincipals();
        this.clickLinkWithExactText("James Cook");
        this.clickLink("user-groups-tab");
        this.assertTableRowCountEquals("groupsTable", 2);
        this.assertTextInTable("groupsTable", "ExplorersClub");
        this.assertTextNotInTable("groupsTable", "EliteExplorersClub");
    }

    public void testCheckMembershipsAdded() throws InterruptedException {
        this.log("Running: testCheckMembershipsAdded");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(CONNECTOR_DIRECTORY_NAME_APACHEDS_CACHING);
        this.assertKeyPresent("menu.viewdirectory.label", EasyList.build((Object)CONNECTOR_DIRECTORY_NAME_APACHEDS_CACHING));
        this.assertKeyPresent("directory.caching.sync.never.label");
        this.clickLinkWithExactText("Configuration");
        this.setWorkingForm("configuration_details");
        this.setTextField("userDNaddition", "");
        this.setTextField("groupDNaddition", "ou=Groups");
        this.submit();
        this.clickLink("connector-general");
        this.synchroniseDirectory();
        this.gotoBrowseGroups();
        this.setWorkingForm("browsegroups");
        this.selectOption("directoryID", CONNECTOR_DIRECTORY_NAME_APACHEDS_CACHING);
        this.submit();
        this.assertTableRowCountEquals("group-details", 4);
        this.searchAllPrincipals();
        this.clickLinkWithExactText("Albert Einstein");
        this.clickLink("user-groups-tab");
        this.assertTableRowCountEquals("groupsTable", 2);
        this.assertTextInTable("groupsTable", "Misc");
        this.assertTextNotInTable("groupsTable", new String[]{"ExplorersClub", "EliteExplorersClub"});
        this.searchAllPrincipals();
        this.clickLinkWithExactText("John Oxley");
        this.clickLink("user-groups-tab");
        this.assertTableRowCountEquals("groupsTable", 2);
        this.assertTextInTable("groupsTable", "Misc");
        this.assertTextNotInTable("groupsTable", new String[]{"ExplorersClub", "EliteExplorersClub"});
        this.searchAllPrincipals();
        this.clickLinkWithExactText("James Cook");
        this.clickLink("user-groups-tab");
        this.assertTableNotPresent("groupsTable");
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(CONNECTOR_DIRECTORY_NAME_APACHEDS_CACHING);
        this.assertKeyPresent("menu.viewdirectory.label", EasyList.build((Object)CONNECTOR_DIRECTORY_NAME_APACHEDS_CACHING));
        this.clickLinkWithExactText("Connector");
        this.setWorkingForm("connectordetails");
        this.setTextField("pollingIntervalInMin", "3600");
        this.setTextField("baseDN", "dc=example,dc=com");
        this.submit();
        this.clickLinkWithExactText("Configuration");
        this.setWorkingForm("configuration_details");
        this.setTextField("groupDNaddition", "");
        this.submit();
        this.synchroniseDirectory();
        this.gotoBrowseGroups();
        this.setWorkingForm("browsegroups");
        this.selectOption("directoryID", CONNECTOR_DIRECTORY_NAME_APACHEDS_CACHING);
        this.submit();
        this.assertTableRowCountEquals("group-details", 6);
        this.searchAllPrincipals();
        this.clickLinkWithExactText("Albert Einstein");
        this.clickLink("user-groups-tab");
        this.assertTableRowCountEquals("groupsTable", 2);
        this.assertTextInTable("groupsTable", "Misc");
        this.assertTextNotInTable("groupsTable", new String[]{"ExplorersClub", "EliteExplorersClub"});
        this.searchAllPrincipals();
        this.clickLinkWithExactText("John Oxley");
        this.clickLink("user-groups-tab");
        this.assertTableRowCountEquals("groupsTable", 4);
        this.assertTextInTable("groupsTable", new String[]{"Misc", "ExplorersClub", "EliteExplorersClub"});
        this.searchAllPrincipals();
        this.clickLinkWithExactText("James Cook");
        this.clickLink("user-groups-tab");
        this.assertTableRowCountEquals("groupsTable", 2);
        this.assertTextInTable("groupsTable", "ExplorersClub");
        this.assertTextNotInTable("groupsTable", "EliteExplorersClub");
    }

    private void searchAllPrincipals() {
        this.gotoBrowsePrincipals();
        this.setWorkingForm("searchusers");
        this.selectOption("directoryID", CONNECTOR_DIRECTORY_NAME_APACHEDS_CACHING);
        this.submit("submit-search");
    }

    private void synchroniseDirectory() {
        this.dbCachingTestHelper.synchroniseDirectory(CONNECTOR_DIRECTORY_NAME_APACHEDS_CACHING, 60000L);
    }
}

