/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.applications.crowd;

import com.atlassian.core.util.PropertyUtils;
import com.atlassian.crowd.acceptance.utils.AcceptanceTestHelper;
import com.atlassian.crowd.acceptance.utils.CrowdWebTestCase;
import com.atlassian.crowd.service.client.ResourceLocator;
import com.atlassian.crowd.service.soap.client.SoapClientPropertiesImpl;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import java.util.ResourceBundle;
import junit.framework.AssertionFailedError;
import org.apache.log4j.Logger;

public class CrowdAcceptanceTestCase
extends CrowdWebTestCase {
    public static int CONSOLE_PORT;
    public static String CONTEXT_PATH;
    public static String WAR_PATH;
    public static String HOST_PATH;
    public static String HOST;
    protected static final String ADMIN_GROUP = "administrators";
    protected static final String ADMIN_USER = "admin";
    protected static final String ADMIN_PW = "admin";
    protected static final String ADMIN_FULL_NAME = "Super User";
    protected static final String ADMIN_EMAIL = "crowd@example.com";
    protected static final Properties specProperties;
    protected static String URL_HOME;
    protected final Logger logger = Logger.getLogger(((Object)((Object)this)).getClass());
    private ResourceBundle i18n;
    protected static final String WORKGROUP_LICENSE_KEY = "NONnnbGCEhMXASCOrPtIvuKpmrMdafAvINOGBPKfEUbSSwn\nmj2KLPN2K78vDnn5CiW4DEM72L0Mz2ZyRhyyclcRGZjv03C\npqmUvmorqMooooNMNmvvmqOMPOnPQPrNrtwwStVwwWusPSU\nUwxwSVMWuuwtUXwspOsmvUUnnvrtnnommmmmUUnnvrtnnom\nmmmmUU1qiXppfXkWJlcqtXobWJvpqbjpUUrm";
    protected static final String UNLIMITED_LICENSE_KEY = "MprrTWaDMMgqqQFpjxNimIQipnxxoLHCfBhpuriOFeiHJo\nmi2Kf0GbDqztZI94<4TFAhw72Kl7Ojoz6JPyOhv<sLxwCc\nnMRVURrNpmqPrQoorqVTqomnMqQoOOQQnUVSvsxTtwVuWS\nmOnnqsmvUUnurtvvoqmmmmmUUnurtvvoqmmmmmUU1qiXpp\nfXkUUnmmmm";
    protected static final String EXPIRED_MAINTENANCE_KEY = "AAABFw0ODAoPeNp9kFFLwzAQx9/zKQI+t7TbZGUQEJc4CnWdrlMRX2J607A0LZe0um9vu3UgPvh4x\n/1+97+7eoaSbqGh0ZTGk8VssrieUrEt6CSKEsLBKdSN17VlS6y/yrcF5dCBqRtAooZOKJXXHTCPL\nZAlghyGufTAesM8iJIgismytr6fW8sKmDISD+EBrL8ppTbHxkgLPlR1NQozrcA6KI4NnAAunkSWb\n8TjRSPue+4/j+ikaU9B2F4aB6QHrAcrrQLx3Wg8XgImY8AcP6TV7szwQUc3Jx/ZAnaAKWe3xWwVr\nHbpXfCSP8yDnL+mY+B1W70D5vudA3QsiMl4QQ9lKb9Uvxa31uhKeyjJpkX1KR38fdgPj3SKEjAsA\nhQDnIHlSx5Ug4jClePbHxCPTYAwnQIUeTzFHGkn0bRuxJZNK5uaXO7y+uU=X02e6";
    protected static final String DEVELOPER_LICENSE_KEY = "AAABgQ0ODAoPeNp1kstuwjAQRff5CktdB4XXAqQsIHELLS+RQCvUjWMGcBvsaJxA+fuaQNQkopJX1\n9d3zsz4aaokCSAhzQ5pdvutVr/dJTQISctxelbEjpFSjYngIDXQrUiFki6dhXS5WI4Dau2EPsAFC\nkd4ScB9Nhq9wGef+HCCWCWAFo/VCbBi83Kp4pplxwhwvltpQO12La7krsF4Kk7gppiBtciQH5gGn\n6XgXgltc5odq5Q7Y0dwfbqmk/mCLosb+pMIvOTPFu1R0Vc5OgA0OGPfHb70Qvtjte7Yb5vNyB46z\nXfrSyCrwL+OlwNCZQqYoNC1Xq/UlU6NEGcg+QNf0bIXZ9qkzdQWtOvUBp+nDHPpv6Jlwgd74phxE\ncXVRXl3sRI0ZcJUkMzQ1obGUZ23tQCjVF7fb80YV/JbqrO05rhnUmiWEw3SmGktmPwDKu/AQ8h99\nfXeKpedxb8raz5ojiLJC4WgUxLfYMhOIUnibC8k2Rak+jax8vv7Hy1Lv3FyG1gwLAIUHEP4zbqEf\n1DeOWKb7SpxQ1MEd8ACFGxZV5doE27OtsuNDT50k2xIhAozX02im";

    public static String _getTestProperty(String propName) {
        if (System.getProperty("acceptance.test." + propName) != null) {
            return System.getProperty("acceptance.test." + propName);
        }
        if (specProperties.getProperty(propName) != null) {
            return specProperties.getProperty(propName);
        }
        return "";
    }

    public String getBaseUrl() {
        return HOST_PATH;
    }

    public String getCrowdContext() {
        return CONTEXT_PATH;
    }

    public String getCrowdHome() {
        String crowdHome = System.getProperty("crowd.home");
        if (crowdHome == null) {
            this.gotoSystemInfo();
            String path = this.getElementTextByXPath("//*[@id=\"home-path\"]");
            File homePath = new File(path);
            if (homePath.exists() && homePath.isDirectory()) {
                try {
                    return homePath.getCanonicalPath();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return crowdHome;
    }

    public String getCrowdApplicationPassword() {
        return SoapClientPropertiesImpl.newInstanceFromResourceLocator((ResourceLocator)new ResourceLocator(){

            public String getResourceLocation() {
                return CrowdAcceptanceTestCase.this.getCrowdHome() + File.separator + this.getResourceName();
            }

            public String getResourceName() {
                return "crowd.properties";
            }

            public Properties getProperties() {
                return PropertyUtils.getPropertiesFromFile((File)new File(this.getResourceLocation()));
            }
        }).getApplicationPassword();
    }

    public void _loginAdminUser() {
        this._loginAsUser("admin", "admin");
    }

    public void _loginAsUser(String username, String password) {
        this.beginAt(URL_HOME);
        this.assertKeyPresent("login.title");
        this.setTextField("j_username", username);
        this.setTextField("j_password", password);
        this.submit();
        this.assertLinkPresentWithKey("menu.logout.label");
    }

    public void _logout() {
        this.gotoPage("/console/logoff.action");
        this.assertKeyPresent("login.title");
    }

    public void addRole(String name, String description, String directoryName) {
        this.gotoPage("/console/secure/role/browse.action");
        this.selectOption("directoryID", "Test Internal Directory");
        this.assertTextNotPresent(name);
        this.gotoAddRole();
        this.setTextField("name", name);
        this.setTextField("description", description);
        this.selectOption("directoryID", directoryName);
        this.submit();
    }

    public void restoreCrowdFromXML(String xmlfilename) {
        if (this.getPageText().contains(this.getText("setup.text"))) {
            this.setTextField("key", UNLIMITED_LICENSE_KEY);
            this.submit();
            this.clickRadioOption("installOption", "install.xml");
            this.submit();
            this.clickRadioOption("databaseOption", "db.embedded");
            this.submit();
            this.setTextField("filePath", AcceptanceTestHelper.getResourcePath("xml/" + xmlfilename));
            this.submit();
            this.assertKeyPresent("setupcomplete.title");
            this.clickElementByXPath("//input[@id='continueButton']");
            this.assertKeyPresent("login.title");
        } else {
            this.restoreCrowdFromXMLWithoutReloggingIn(xmlfilename);
        }
        this._loginAdminUser();
    }

    public void restoreCrowdFromXMLWithoutReloggingIn(String xmlfilename) {
        this.restoreCrowdFromXMLWithoutReloggingIn(xmlfilename, true);
    }

    public void restoreCrowdFromXMLWithoutReloggingIn(String xmlfilename, boolean checkForError) {
        String absolutePathfileLocation = AcceptanceTestHelper.getResourcePath("xml/" + xmlfilename);
        this._loginAdminUser();
        this.gotoRestore();
        this.setTextField("importFilePath", absolutePathfileLocation);
        this.logger.info((Object)("Restoring Crowd from: " + absolutePathfileLocation));
        this.submit("import-submit");
        if (checkForError) {
            this.assertErrorNotPresent();
        }
    }

    public void restoreBaseSetup() {
        this.restoreCrowdFromXML("basesetup.xml");
    }

    public void gotoAddRole() {
        this.gotoPage("/console/secure/role/add.action");
    }

    public void gotoAddApplication() {
        this.gotoPage("/console/secure/application/addapplicationdetails.action");
    }

    public void gotoCreateDirectory() {
        this.gotoPage("/console/secure/directory/create.action");
    }

    public void gotoAddGroup() {
        this.gotoPage("/console/secure/group/add.action");
    }

    public void gotoViewPrincipal(String principalName, String directoryName) {
        this.gotoPage("/console/secure/user/view.action?name=" + principalName + "&directoryName=" + directoryName);
        this.assertKeyPresent("menu.viewprincipal.label");
    }

    public void gotoRemovePrincipal(String principalName, String directoryName) {
        this.gotoPage("/console/secure/user/remove.action?name=" + principalName + "&directoryName=" + directoryName);
        this.assertKeyPresent("menu.removeprincipal.label");
    }

    public void gotoViewGroup(String groupName, String directoryName) {
        this.gotoPage("/console/secure/group/view.action?name=" + groupName + "&directoryName=" + directoryName);
    }

    public void gotoViewRole(String roleName, String directoryName) {
        this.gotoPage("/console/secure/role/view.action?name=" + roleName + "&directoryName=" + directoryName);
    }

    public void gotoAddPrincipal() {
        this.gotoPage("/console/secure/user/add.action");
    }

    public void gotoBrowseApplications() {
        this.gotoPage("/console/secure/application/browse.action");
        this.assertKeyPresent("browser.application.title");
    }

    public void gotoBrowsePrincipals() {
        this.gotoPage("/console/secure/user/browse.action");
        this.assertKeyPresent("browser.principal.title");
    }

    public void gotoBrowsePrincipals(int resultsStart) {
        this.gotoPage("/console/secure/user/browse.action?resultsStart=" + resultsStart);
        this.assertKeyPresent("browser.principal.title");
    }

    public void gotoBrowseGroups() {
        this.gotoPage("/console/secure/group/browse.action");
        this.assertKeyPresent("browser.group.title");
    }

    public void gotoBrowseGroups(int resultsStart) {
        this.gotoPage("/console/secure/group/browse.action?resultsStart=" + resultsStart);
        this.assertKeyPresent("browser.group.title");
    }

    public void gotoBrowseRoles() {
        this.gotoPage("/console/secure/role/browse.action");
        this.assertKeyPresent("browser.role.title");
    }

    public void gotoBrowseDirectories() {
        this.gotoPage("/console/secure/directory/browse.action");
    }

    public void gotoImporters() {
        this.gotoPage("/console/secure/dataimport/importtype.action");
    }

    public void gotoSystemInfo() {
        this.gotoPage("/console/secure/admin/systeminfo.action");
        this.assertKeyPresent("systeminfo.title");
    }

    protected void log(String message) {
        this.logger.info((Object)message);
    }

    public void setUp() throws Exception {
        super.setUp();
        this.i18n = ResourceBundle.getBundle("com.atlassian.crowd.console.action.BaseAction");
        this.getTestContext().setBaseUrl(HOST_PATH);
        this.getTestContext().setResourceBundleName("com.atlassian.crowd.console.action.BaseAction");
        this.log("Starting at URL: " + HOST_PATH);
        this.beginAt(URL_HOME);
    }

    public String getText(String key) {
        return this.i18n.getString(key);
    }

    public void tearDown() throws Exception {
        super.tearDown();
        this.tester = null;
    }

    public void gotoGeneral() {
        this.gotoPage("/console/secure/admin/general.action");
    }

    public void gotoLicensing() {
        this.gotoPage("/console/secure/admin/licensing.action");
    }

    public void gotoMailServer() {
        this.gotoPage("/console/secure/admin/mailserver.action");
    }

    public void gotoMailTemplate() {
        this.gotoPage("/console/secure/admin/mailtemplate.action");
    }

    public void gotoSessionConfig() {
        this.gotoPage("/console/secure/admin/sessionconfig.action");
    }

    public void gotoCurrentApplicationSessions() {
        this.gotoPage("/console/secure/session/browseapplicationsessions.action");
    }

    public void gotoCurrentPrincipalSessions() {
        this.gotoPage("/console/secure/session/browseusersessions.action");
    }

    public void gotoTrustedProxies() {
        this.gotoPage("/console/secure/admin/viewtrustedproxies.action");
    }

    public void gotoLoggingProfiling() {
        this.gotoPage("/console/secure/admin/loggingProfiling.action");
    }

    public void gotoBackup() {
        this.gotoPage("/console/secure/admin/backup.action");
        this.assertKeyPresent("administration.backup.text");
    }

    public void gotoRestore() {
        this.gotoPage("/console/secure/admin/restore.action");
    }

    public void gotoViewApplication(String applicationName) {
        this.gotoPage("/console/secure/application/viewdetails.action?name=" + applicationName);
    }

    public void gotoSAMLConfig() {
        this.gotoPage("/console/secure/application/samlconfig.action");
    }

    public void gotoLdapConnectionPool() {
        this.gotoPage("/console/secure/admin/connectionpool.action");
    }

    public void assertUserInTable(String userTableId, String username, String fullname, String email) {
        this.assertTextInTable(userTableId, new String[]{fullname, "Username: " + username + "\nEmail Address: " + email});
    }

    public void assertUserNotInTable(String userTableId, String username, String fullname, String email) {
        try {
            this.assertUserInTable(userTableId, username, fullname, email);
            CrowdAcceptanceTestCase.fail((String)("Found text in table: " + username + " " + fullname + " " + email));
        }
        catch (AssertionFailedError e) {
            // empty catch block
        }
    }

    public void assertUserInTable(String userTableId, String username, String fullname, String email, String alias) {
        this.assertTextInTable(userTableId, new String[]{fullname, "Username: " + username + "\nEmail Address: " + email + "\nAlias: " + alias});
    }

    static {
        URL_HOME = "/console/secure/console.action";
        specProperties = AcceptanceTestHelper.loadProperties("localtest.properties");
        CONSOLE_PORT = Integer.parseInt(CrowdAcceptanceTestCase._getTestProperty("crowd.port"));
        HOST = CrowdAcceptanceTestCase._getTestProperty("host.location");
        CONTEXT_PATH = CrowdAcceptanceTestCase._getTestProperty("crowd.context");
        WAR_PATH = CrowdAcceptanceTestCase._getTestProperty("crowd.path");
        HOST_PATH = "http://" + HOST + ":" + CONSOLE_PORT + CONTEXT_PATH;
    }
}

